/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtulivecheck;

import android.content.ContentResolver;
import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class StatisticsUtils {
    public static String getDeviceUid(Context context) {
        boolean bl;
        String string = StatisticsUtils.getIMEI(context.getApplicationContext());
        String string2 = StatisticsUtils.getMacAddr(context.getApplicationContext());
        boolean bl2 = bl = !TextUtils.isEmpty((CharSequence)string2);
        if (bl) {
            string2 = string2.replaceAll(":", "");
        }
        String string3 = StatisticsUtils.encryptUid(string + (bl ? string2 : ""));
        return StatisticsUtils.toMD5(string3);
    }

    public static String getMacAddr(Context context) {
        WifiInfo wifiInfo;
        if (context == null) {
            return null;
        }
        String string = null;
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        if (wifiManager != null && (wifiInfo = wifiManager.getConnectionInfo()) != null) {
            string = wifiInfo.getMacAddress();
        }
        return string;
    }

    public static String getIMEI(Context context) {
        String string = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if (TextUtils.isEmpty((CharSequence)string)) {
            try {
                TelephonyManager telephonyManager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
                if (telephonyManager != null) {
                    string = telephonyManager.getDeviceId();
                }
            }
            catch (Exception exception) {
                return string;
            }
        }
        return string;
    }

    public static String toMD5(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        String string2 = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.reset();
            messageDigest.update(string.getBytes());
            BigInteger bigInteger = new BigInteger(1, messageDigest.digest());
            string2 = bigInteger.toString(16);
            while (string2.length() < 32) {
                string2 = "0" + string2;
            }
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            string2 = "";
        }
        return string2;
    }

    private static char getChar(byte by, int n) {
        return (char)(by - StatisticsUtils.getOffset(n & 1));
    }

    private static byte getOffset(int n) {
        byte by = (byte)(0 == n ? 65 : 97);
        return by;
    }

    private static String encryptUid(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            stringBuilder.append(c2 + c2 % n);
        }
        stringBuilder.reverse();
        return stringBuilder.toString();
    }

    private StatisticsUtils() {
    }
}

