/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.graphics.ImageFormat;
import android.hardware.Camera;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import com.webank.mbank.wecamera.preview.Frame;
import com.webank.mbank.wecamera.preview.PreviewParameter;
import com.webank.mbank.wecamera.preview.PreviewProcessor;
import com.webank.mbank.wecamera.preview.WePreviewCallback;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class V1PreviewProcessor
implements PreviewProcessor {
    private static final String TAG = "V1PreviewProcessor";
    private static ExecutorService mPreviewCallbackExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("WeCamera-PreviewProcessorThread");
            return thread;
        }
    });
    private Camera mCamera;
    private CameraDevice mCameraDevice;
    private List<WePreviewCallback> mWePreviewCallbacks;
    private Size mPreviewSize;
    private int mImageFormat;
    private PreviewParameter mPreviewParameter;
    private byte[] frameData;
    private boolean useCopy = true;

    public V1PreviewProcessor(CameraDevice device, Camera camera) {
        this.mCamera = camera;
        this.mCameraDevice = device;
        this.mPreviewParameter = this.mCameraDevice.getDisplayFeature();
        this.mPreviewSize = this.mPreviewParameter.previewSize();
        this.mImageFormat = this.mPreviewParameter.imageFormat();
        this.mWePreviewCallbacks = new ArrayList<WePreviewCallback>();
    }

    @Override
    public void addCallbackBuffer() {
        WeCameraLogger.i(TAG, "add callback buffer", new Object[0]);
        this.mCamera.addCallbackBuffer(this.buffer(this.mPreviewSize));
    }

    public int yv21BufferSize(int width, int height) {
        int yStride = (int)Math.ceil((double)width / 16.0) * 16;
        int uvStride = (int)Math.ceil((double)(yStride / 2) / 16.0) * 16;
        int ySize = yStride * height;
        int uvSize = uvStride * height / 2;
        int size = ySize + uvSize * 2;
        return size;
    }

    private byte[] buffer(Size previewSize) {
        int previewFormat = this.mImageFormat;
        int size = previewFormat == 842094169 ? this.yv21BufferSize(previewSize.width, previewSize.height) : previewSize.width * previewSize.height * ImageFormat.getBitsPerPixel((int)previewFormat) / 8;
        WeCameraLogger.d(TAG, "camera preview format:" + previewFormat + ",calc buffer size:" + size, new Object[0]);
        byte[] buffer = new byte[size];
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPreviewFrameCallback(WePreviewCallback wePreviewCallback) {
        List<WePreviewCallback> list = this.mWePreviewCallbacks;
        synchronized (list) {
            WeCameraLogger.d(TAG, "register preview callback:" + wePreviewCallback, new Object[0]);
            if (wePreviewCallback != null && !this.mWePreviewCallbacks.contains(wePreviewCallback)) {
                this.mWePreviewCallbacks.add(wePreviewCallback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePreviewFrameCallback(WePreviewCallback wePreviewCallback) {
        List<WePreviewCallback> list = this.mWePreviewCallbacks;
        synchronized (list) {
            WeCameraLogger.d(TAG, "unregister preview callback:" + wePreviewCallback, new Object[0]);
            if (wePreviewCallback != null && this.mWePreviewCallbacks.contains(wePreviewCallback)) {
                this.mWePreviewCallbacks.remove(wePreviewCallback);
            }
        }
    }

    @Override
    public void start() {
        this.addCallbackBuffer();
        WeCameraLogger.i(TAG, "start preview callback.", new Object[0]);
        this.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(final byte[] data, Camera camera) {
                if (V1PreviewProcessor.this.useCopy) {
                    if (V1PreviewProcessor.this.frameData == null) {
                        V1PreviewProcessor.access$102(V1PreviewProcessor.this, new byte[data.length]);
                    }
                    System.arraycopy(data, 0, V1PreviewProcessor.this.frameData, 0, data.length);
                } else {
                    V1PreviewProcessor.access$102(V1PreviewProcessor.this, data);
                }
                mPreviewCallbackExecutor.submit(new Runnable(){

                    @Override
                    public void run() {
                        Frame frame = new Frame(V1PreviewProcessor.this.mPreviewSize, V1PreviewProcessor.this.frameData, V1PreviewProcessor.this.mPreviewParameter.displayOrientation(), V1PreviewProcessor.this.mImageFormat, V1PreviewProcessor.this.mPreviewParameter.cameraFacing());
                        V1PreviewProcessor.this.dispatchFrameCallbacks(frame, data);
                    }
                });
            }
        });
    }

    @Override
    public void stop() {
        WeCameraLogger.i(TAG, "stop preview callback.", new Object[0]);
        this.mCamera.setPreviewCallbackWithBuffer(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchFrameCallbacks(Frame frame, byte[] srcData) {
        List<WePreviewCallback> list = this.mWePreviewCallbacks;
        synchronized (list) {
            for (int i = 0; i < this.mWePreviewCallbacks.size(); ++i) {
                WePreviewCallback wePreviewCallback = this.mWePreviewCallbacks.get(i);
                wePreviewCallback.arrive(frame);
            }
        }
        this.mCamera.addCallbackBuffer(srcData);
    }

    static /* synthetic */ byte[] access$102(V1PreviewProcessor x0, byte[] x1) {
        x0.frameData = x1;
        return x1;
    }
}

