/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtulivecheck;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.PointF;
import android.os.Looper;
import com.tencent.youtulivecheck.Config;
import com.tencent.youtulivecheck.HttpUtil;
import com.tencent.youtulivecheck.Log;
import com.tencent.youtulivecheck.StatisticsUtils;
import java.io.IOException;
import java.util.Timer;

public class YoutuLiveCheck {
    private static long handle = 0L;
    public Context context = null;
    private static final String SDK_NAME = "YoutuLiveCheck";
    private static final String SDK_PREFIX = "YT";
    private static final String LICENCE_SUFFIX = "SDK.licence";
    private static final String DAT_SUFFIX = "SDK.dat";
    private Timer timerFlush;
    private Timer timerReport;
    private static final String TAG = "log_print";
    private static String licenceStr = "";
    private static HttpUtil.HttpResponseListener mListener = new HttpUtil.HttpResponseListener(){

        @Override
        public void onSuccess(String string) {
            try {
                Log.d(YoutuLiveCheck.TAG, "response: " + string);
                Log.d(YoutuLiveCheck.TAG, "handle: " + handle);
                YoutuLiveCheck.nativeUpdateFromServer(handle, string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public void onFail(int n) {
            try {
                Log.d(YoutuLiveCheck.TAG, "http request error : " + n);
                Log.d(YoutuLiveCheck.TAG, "handle: " + handle);
                YoutuLiveCheck.nativeUpdateFromServer(handle, null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };
    private long nativePtr;

    public static int initLicenceStr(Context context, String string) {
        licenceStr = string;
        int n = -1;
        try {
            byte[] byArray = string.getBytes();
            int n2 = byArray.length;
            if (n2 <= 0) {
                throw new IOException("licence error");
            }
            String string2 = context.getFilesDir().getPath() + "/" + SDK_PREFIX + SDK_NAME + DAT_SUFFIX;
            String string3 = context.getPackageName();
            String string4 = StatisticsUtils.getDeviceUid(context);
            Log.d(TAG, "Package name: " + string3);
            Log.d(TAG, "Device id: " + string4);
            n = YoutuLiveCheck.nativePreInitAndCheck(byArray, n2, string3, string4, string2);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return n;
    }

    public static void init(Context context, String string, int n, boolean bl) {
        Config.DEBUG = bl;
        String string2 = context.getFilesDir().getPath() + "/" + SDK_PREFIX + SDK_NAME + DAT_SUFFIX;
        handle = YoutuLiveCheck.nativeInitN(context, n, string, context.getAssets(), string2);
        Log.d(TAG, "handleinit: " + handle);
    }

    public static long getHandle() {
        return handle;
    }

    public static boolean check() {
        boolean bl = YoutuLiveCheck.nativeCheck(handle);
        android.util.Log.d((String)"sdk", (String)"--------------check");
        return bl;
    }

    public static native long nativeInitN(Context var0, int var1, String var2, AssetManager var3, String var4);

    public static native long nativeUpdateFromServer(long var0, String var2);

    public static native boolean nativeCheck(long var0);

    public static native String getReportContent();

    public static native long nativeFlush();

    public static native int nativePreInitAndCheck(byte[] var0, int var1, String var2, String var3, String var4);

    public static boolean isInMainThread() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    public static void report(final String string) {
        Log.d(TAG, "report: " + string);
        String string2 = "https://api.youtu.qq.com/auth/report";
        if (YoutuLiveCheck.isInMainThread()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        HttpUtil.post("https://api.youtu.qq.com/auth/report", string, mListener);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }).start();
        } else {
            try {
                HttpUtil.post("https://api.youtu.qq.com/auth/report", string, mListener);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static native String getSdkVersion();

    public YoutuLiveCheck() {
        if (!YoutuLiveCheck.isModelInited()) {
            throw new Error("YOUTU : Please call YoutuLiveCheck.Init() before getInstance()");
        }
        this.NativeConstructor();
    }

    public void destroy() {
        this.NativeDestructor();
    }

    protected void finalize() {
        this.NativeDestructor();
    }

    public native int DoDetectionInit();

    public static native boolean Init(String var0);

    public static native void Release();

    public native FaceStatus DoDetectionProcess(byte[] var1, int var2, int var3, boolean var4);

    public native FaceStatus DoDetectionProcessWithRotation(byte[] var1, int var2, int var3, boolean var4, int var5);

    public native FaceStatus DoDetectionProcessRGBA(byte[] var1, int var2, int var3);

    public native Bitmap GetResultImage();

    public native void StartLiveCheck();

    public native void EndLiveCheck();

    public native Bitmap GetResultLiveCheckImage();

    private native void NativeConstructor();

    private native void NativeDestructor();

    private static native boolean isModelInited();

    private static native boolean nativeInit();

    static {
        YoutuLiveCheck.nativeInit();
    }

    public static class FaceStatus {
        public int x;
        public int y;
        public int w;
        public int h;
        public PointF lefteye;
        public PointF righteye;
        public float pitch;
        public float yaw;
        public float roll;
        public int illumination_score;
        public int blur_score;
        public int save_photo;
        public int liveness_head;
        public int liveness_nod;
        public int liveness_mouth;
        public int liveness_eye;
        public float[] xys;
        public float[] pointsVis;
    }
}

