/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.hardware.ZoomOperator;
import com.webank.mbank.wecamera.log.WeCameraLogger;

public class V1ZoomOperator
implements ZoomOperator {
    private static final String TAG = "V1ZoomOperator";
    private Camera mCamera;

    public V1ZoomOperator(Camera camera) {
        this.mCamera = camera;
    }

    @Override
    public void takeZoom(float scale) {
        Camera.Parameters originParameters = this.mCamera.getParameters();
        try {
            Camera.Parameters parameters = this.mCamera.getParameters();
            int maxZoom = originParameters.getMaxZoom();
            if (scale > 1.0f) {
                scale = 1.0f;
            }
            if (scale < 0.0f) {
                scale = 0.0f;
            }
            int zoom = (int)((float)maxZoom * scale);
            parameters.setZoom(zoom);
            this.mCamera.setParameters(parameters);
            WeCameraLogger.d(TAG, "take scale success.", new Object[0]);
        }
        catch (Exception e2) {
            WeCameraLogger.i(TAG, "take scale failed, rollback:" + originParameters, new Object[0]);
            if (originParameters != null) {
                this.mCamera.setParameters(originParameters);
            }
            CameraErrors.throwError(CameraException.ofDevice(63, "set zoom failed", e2));
        }
    }
}

