/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.config.selector;

import android.content.Context;
import com.webank.mbank.wecamera.config.FeatureSelector;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.config.selector.BestPreviewSize4VideoSelector;
import com.webank.mbank.wecamera.config.selector.BestPreviewSizeSelector;
import com.webank.mbank.wecamera.config.selector.MaxAreaSelector;
import com.webank.mbank.wecamera.config.selector.TargetSelector;
import com.webank.mbank.wecamera.utils.CameraUtils;

public class SizeSelectors {
    public static FeatureSelector<Size> size(int width, int height) {
        return new TargetSelector<Size>(new Size(width, height));
    }

    public static FeatureSelector<Size> bestPreviewSize4Screen(Context ctx) {
        return SizeSelectors.bestPreviewSize(ctx, new Size(CameraUtils.getRealDisplaySize(ctx)));
    }

    public static FeatureSelector<Size> bestVideoPreviewSize4Screen(Context ctx) {
        return SizeSelectors.bestVideoPreviewSize(ctx, new Size(CameraUtils.getRealDisplaySize(ctx)));
    }

    public static FeatureSelector<Size> bestVideoPreviewSize(Context context, Size target) {
        return new BestPreviewSize4VideoSelector(context).size(target);
    }

    public static FeatureSelector<Size> bestPreviewSize(Context context, Size target) {
        return new BestPreviewSizeSelector(context).size(target);
    }

    public static FeatureSelector<Size> maxArea() {
        return new MaxAreaSelector();
    }
}

