/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.view;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.webank.mbank.wecamera.config.feature.CameraFacing;
import com.webank.mbank.wecamera.config.feature.ScaleType;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.face.FaceResult;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import com.webank.mbank.wecamera.preview.PreviewParameter;
import com.webank.mbank.wecamera.utils.MathUtils;
import com.webank.mbank.wecamera.view.CameraMatrix;
import com.webank.mbank.wecamera.view.CameraView;
import java.util.concurrent.CountDownLatch;

public class WeCameraView
extends FrameLayout
implements CameraView,
CameraMatrix {
    private static final String TAG = "CameraSurfaceView";
    private CountDownLatch mCountDownLatch = new CountDownLatch(1);
    private SurfaceView mSurfaceView;
    private volatile SurfaceHolder mSurfaceHolder;
    private ScaleType mScaleType;
    private PreviewParameter mPreviewParameter;
    private Rect mPreviewRect;

    public WeCameraView(Context context) {
        super(context);
        this.initView(context);
    }

    public WeCameraView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    public WeCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView(context);
    }

    public WeCameraView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initView(context);
    }

    private void initView(Context context) {
        this.mSurfaceView = new SurfaceView(context);
        if (this.mSurfaceHolder != null) {
            return;
        }
        this.mSurfaceView.getHolder().addCallback(new SurfaceHolder.Callback(){

            public void surfaceCreated(SurfaceHolder holder) {
                WeCameraView.this.mSurfaceHolder = holder;
                WeCameraView.this.mCountDownLatch.countDown();
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
            }
        });
        this.addView((View)this.mSurfaceView, new ViewGroup.LayoutParams(-1, -1));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mPreviewParameter == null || this.mScaleType == null) {
            super.onLayout(changed, left, top, right, bottom);
        } else {
            this.layoutSurfaceView();
        }
    }

    private void layoutSurfaceView() {
        int w = this.getMeasuredWidth();
        int h = this.getMeasuredHeight();
        Size fs = new Size(w, h);
        Size ps = this.mPreviewParameter.previewSize();
        if ((this.mPreviewParameter.screenOrientation() - this.mPreviewParameter.cameraOrientation()) % 180 != 0) {
            ps = new Size(ps.height, ps.width);
        }
        Size prs = this.mScaleType.name().startsWith("FIT") ? MathUtils.fit(ps, fs) : MathUtils.crop(ps, fs);
        WeCameraLogger.d(TAG, "container layout size:width=" + w + ",height=" + h, new Object[0]);
        WeCameraLogger.d(TAG, "preview size scale result:" + prs, new Object[0]);
        int paddingLeft = (prs.width - w) / 2;
        int paddingTop = (prs.height - h) / 2;
        int left = 0;
        int top = 0;
        int right = 0;
        int bottom = 0;
        switch (this.mScaleType) {
            case CROP_CENTER: {
                left = -paddingLeft;
                top = -paddingTop;
                right = w + paddingLeft;
                bottom = h + paddingTop;
                break;
            }
            case CROP_START: {
                left = -paddingLeft;
                top = 0;
                right = w + paddingLeft;
                bottom = h + 2 * paddingTop;
                break;
            }
            case CROP_END: {
                left = -paddingLeft;
                top = -2 * paddingTop;
                right = w + paddingLeft;
                bottom = h;
                break;
            }
            case FIT_START: {
                left = -paddingLeft;
                top = 0;
                right = w + paddingLeft;
                bottom = h + 2 * paddingTop;
                break;
            }
            case FIT_END: {
                left = -paddingLeft;
                top = -2 * paddingTop;
                right = w + paddingLeft;
                bottom = h;
                break;
            }
            case FIT_CENTER: {
                left = -paddingLeft;
                top = -paddingTop;
                right = w + paddingLeft;
                bottom = h + paddingTop;
            }
        }
        this.mPreviewRect = new Rect(left, top, right, bottom);
        WeCameraLogger.d(TAG, "we camera view child rect size:" + this.mPreviewRect.toShortString(), new Object[0]);
        this.layoutChildren();
    }

    private void layoutChildren() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            this.getChildAt(i).layout(this.mPreviewRect.left, this.mPreviewRect.top, this.mPreviewRect.right, this.mPreviewRect.bottom);
        }
    }

    public Rect previewRect() {
        return this.mPreviewRect;
    }

    @Override
    public void setScaleType(ScaleType scaleType) {
        this.mScaleType = scaleType;
    }

    @Override
    public void attachCameraView(CameraDevice cameraDevice) {
        PreviewParameter displayFeature;
        if (this.mSurfaceHolder == null) {
            try {
                WeCameraLogger.d(TAG, "attachCameraView:wait for surface create", new Object[0]);
                this.mCountDownLatch.await();
            }
            catch (InterruptedException e2) {
                e2.printStackTrace();
            }
        }
        this.mPreviewParameter = displayFeature = cameraDevice.getDisplayFeature();
        this.post(new Runnable(){

            @Override
            public void run() {
                WeCameraView.this.requestLayout();
            }
        });
        cameraDevice.setDisplayView(this.mSurfaceView);
    }

    @Override
    public Matrix getFaceMatrix() {
        return FaceResult.faceMatrix(this.previewRect().width(), this.previewRect().height(), this.mPreviewParameter.cameraFacing() == CameraFacing.FRONT, this.mPreviewParameter.displayOrientation());
    }

    @Override
    public Rect getPreviewRect() {
        return this.previewRect();
    }
}

