/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.config.CameraConfig;
import com.webank.mbank.wecamera.config.CameraConfigSelectors;
import com.webank.mbank.wecamera.config.feature.Fps;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.hardware.ConfigOperator;
import com.webank.mbank.wecamera.hardware.v1.CameraV1;
import com.webank.mbank.wecamera.hardware.v1.V1ConfigSelector;
import com.webank.mbank.wecamera.hardware.v1.V1OneByOneParameterOperator;
import com.webank.mbank.wecamera.log.WeCameraLogger;

public class V1ConfigOperator
implements ConfigOperator {
    private static final String TAG = "V1ConfigOperator";
    private CameraDevice mCameraDevice;
    private CameraV1 mCamera;

    public V1ConfigOperator(CameraDevice cameraDevice, CameraV1 camera) {
        this.mCameraDevice = cameraDevice;
        this.mCamera = camera;
    }

    @Override
    public CameraConfig updateConfig(CameraConfigSelectors cameraConfigs) {
        try {
            return this.updateCameraConfig(cameraConfigs);
        }
        catch (Exception e2) {
            WeCameraLogger.e(TAG, e2, "update camera config error:%s", e2.getMessage());
            return null;
        }
    }

    private CameraConfig updateCameraConfig(CameraConfigSelectors cameraConfigs) {
        V1ConfigSelector mCameraConfigSelector = new V1ConfigSelector(this.mCamera);
        CameraConfig config = mCameraConfigSelector.select(cameraConfigs);
        Camera.Parameters originParameters = this.mCamera.camera().getParameters();
        if (config == null) {
            config = new CameraConfig();
            this.getLastCameraConfig(config, originParameters);
            return config;
        }
        WeCameraLogger.i(TAG, "start camera config.", new Object[0]);
        V1OneByOneParameterOperator v1OneByOneParameterOperator = new V1OneByOneParameterOperator(config, cameraConfigs);
        v1OneByOneParameterOperator.operate(this.mCamera);
        this.mCameraDevice.takeZoom(config.zoom() / (float)originParameters.getMaxZoom());
        this.getLastCameraConfig(config, this.mCamera.camera().getParameters());
        return config;
    }

    private CameraConfig getLastCameraConfig(CameraConfig config, Camera.Parameters parameters) {
        int[] fps = new int[2];
        parameters.getPreviewFpsRange(fps);
        Fps fps1 = new Fps(fps[0], fps[1]);
        float zoom = -1.0f;
        if (parameters.isZoomSupported()) {
            zoom = (float)parameters.getZoom() / (float)parameters.getMaxZoom();
        }
        return config.zoom(parameters.getZoom()).previewSize(new Size(parameters.getPreviewSize().width, parameters.getPreviewSize().height)).pictureSize(new Size(parameters.getPictureSize().width, parameters.getPictureSize().height)).focusMode(parameters.getFocusMode()).flashMode(parameters.getFlashMode()).zoom(zoom).fps(fps1);
    }
}

