/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.config.CameraConfig;
import com.webank.mbank.wecamera.config.CameraConfigSelectors;
import com.webank.mbank.wecamera.config.ConfigOperate;
import com.webank.mbank.wecamera.config.feature.Fps;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.hardware.v1.CameraV1;
import com.webank.mbank.wecamera.hardware.v1.V1ParameterOperator;
import com.webank.mbank.wecamera.hardware.v1.V1ParametersOperator;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import java.util.List;

public class V1OneByOneParameterOperator {
    private static final String TAG = "V1SingParaOperator";
    private CameraConfig mCameraConfig;
    private CameraConfigSelectors cameraConfigs;

    public V1OneByOneParameterOperator(CameraConfig cameraConfig, CameraConfigSelectors cameraConfigs) {
        this.mCameraConfig = cameraConfig;
        this.cameraConfigs = cameraConfigs;
    }

    public void operate(CameraV1 cameraV1) {
        V1ParametersOperator operator = new V1ParametersOperator();
        final CameraConfig finalConfig = this.mCameraConfig;
        operator.addParameterOperator(new V1ParameterOperator(){

            @Override
            public void operate(Camera.Parameters parameters, CameraV1 cameraV1) {
                WeCameraLogger.d(V1OneByOneParameterOperator.TAG, "start config focus mode.", new Object[0]);
                String focusMode = finalConfig.focusMode();
                if (focusMode != null) {
                    parameters.setFocusMode(focusMode);
                }
            }
        });
        operator.addParameterOperator(new V1ParameterOperator(){

            @Override
            public void operate(Camera.Parameters parameters, CameraV1 cameraV1) {
                WeCameraLogger.d(V1OneByOneParameterOperator.TAG, "start config flash mode.", new Object[0]);
                String flashMode = finalConfig.flashMode();
                if (flashMode != null) {
                    parameters.setFlashMode(flashMode);
                }
            }
        });
        operator.addParameterOperator(new V1ParameterOperator(){

            @Override
            public void operate(Camera.Parameters parameters, CameraV1 cameraV1) {
                WeCameraLogger.d(V1OneByOneParameterOperator.TAG, "start config previewSize.", new Object[0]);
                Size previewSize = finalConfig.previewSize();
                if (previewSize != null) {
                    parameters.setPreviewSize(previewSize.getWidth(), previewSize.getHeight());
                }
            }
        });
        operator.addParameterOperator(new V1ParameterOperator(){

            @Override
            public void operate(Camera.Parameters parameters, CameraV1 cameraV1) {
                WeCameraLogger.d(V1OneByOneParameterOperator.TAG, "start config pictureSize.", new Object[0]);
                Size pictureSize = finalConfig.pictureSize();
                if (pictureSize != null) {
                    parameters.setPictureSize(pictureSize.getWidth(), pictureSize.getHeight());
                }
            }
        });
        operator.addParameterOperator(new V1ParameterOperator(){

            @Override
            public void operate(Camera.Parameters parameters, CameraV1 cameraV1) {
                WeCameraLogger.d(V1OneByOneParameterOperator.TAG, "start config fps.", new Object[0]);
                Fps fps = finalConfig.fps();
                if (fps != null) {
                    parameters.setPreviewFpsRange(fps.min(), fps.max());
                }
            }
        });
        List<ConfigOperate> configOperates = this.cameraConfigs.configOperates();
        if (configOperates != null && configOperates.size() > 0) {
            for (int i = configOperates.size() - 1; i >= 0; --i) {
                ConfigOperate configOperate = configOperates.get(i);
                if (!(configOperate instanceof V1ParameterOperator)) continue;
                operator.addParameterOperator((V1ParameterOperator)configOperate);
            }
        }
        operator.operate(cameraV1);
    }
}

