/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.log;

import android.util.Log;

public class WeCameraLogger {
    private static final String ROOT_TAT = "WeCamera";
    private static final String ROOT_TAG_PREFIX = "WeCamera-";
    private static ILog logger;
    private static int logLevel;
    private static ExceptionHandler exceptionHandler;
    private static Config config;

    public static Config config() {
        return config;
    }

    public static void setExceptionHandler(ExceptionHandler exceptionHandler) {
        WeCameraLogger.exceptionHandler = exceptionHandler;
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public static void closeLog() {
        logLevel = 10;
    }

    public static void setProxy(ILog log) {
        logger = log;
    }

    public static void setLogger(ILog log) {
        logger = log;
    }

    public static void setLogger(ILog2 log) {
        logger = log;
    }

    public static void throwException(Throwable t) {
        if (t == null) {
            return;
        }
        if (exceptionHandler != null) {
            exceptionHandler.handle(false, t);
        } else {
            t.printStackTrace();
        }
    }

    public static void v(String s, Object ... args) {
        WeCameraLogger.v(null, null, s, args);
    }

    public static void d(String s, Object ... args) {
        WeCameraLogger.d(null, null, s, args);
    }

    public static void i(String s, Object ... args) {
        WeCameraLogger.i(null, null, s, args);
    }

    public static void w(String s, Object ... args) {
        WeCameraLogger.w(null, null, s, args);
    }

    public static void e(String s, Object ... args) {
        WeCameraLogger.e(null, null, s, args);
    }

    public static void wtf(String s, Object ... args) {
        WeCameraLogger.wtf(null, null, s, args);
    }

    public static void v(String tag, String s, Object ... args) {
        WeCameraLogger.v(tag, null, s, args);
    }

    public static void d(String tag, String s, Object ... args) {
        WeCameraLogger.d(tag, null, s, args);
    }

    public static void i(String tag, String s, Object ... args) {
        WeCameraLogger.i(tag, null, s, args);
    }

    public static void w(String tag, String s, Object ... args) {
        WeCameraLogger.w(tag, null, s, args);
    }

    public static void e(String tag, String s, Object ... args) {
        WeCameraLogger.e(tag, null, s, args);
    }

    public static void wtf(String tag, String s, Object ... args) {
        WeCameraLogger.wtf(tag, null, s, args);
    }

    public static void v(String tag, Throwable t, String s, Object ... args) {
        tag = WeCameraLogger.getTag(tag);
        if (logger != null) {
            logger.log(2, tag, t, s, args);
        } else if (logLevel <= 2) {
            if (args.length > 0) {
                Log.v((String)tag, (String)String.format(s, args), (Throwable)t);
            } else {
                Log.v((String)tag, (String)s, (Throwable)t);
            }
            WeCameraLogger.handleException(true, t);
        }
    }

    public static void d(String tag, Throwable t, String s, Object ... args) {
        tag = WeCameraLogger.getTag(tag);
        if (logger != null) {
            logger.log(3, tag, t, s, args);
        } else if (logLevel <= 3) {
            if (args.length > 0) {
                Log.d((String)tag, (String)String.format(s, args), (Throwable)t);
            } else {
                Log.d((String)tag, (String)s, (Throwable)t);
            }
            WeCameraLogger.handleException(true, t);
        }
    }

    public static void i(String tag, Throwable t, String s, Object ... args) {
        tag = WeCameraLogger.getTag(tag);
        if (logger != null) {
            logger.log(4, tag, t, s, args);
        } else if (logLevel <= 4) {
            if (args.length > 0) {
                Log.i((String)tag, (String)String.format(s, args), (Throwable)t);
            } else {
                Log.i((String)tag, (String)s, (Throwable)t);
            }
            WeCameraLogger.handleException(true, t);
        }
    }

    public static void w(String tag, Throwable t, String s, Object ... args) {
        tag = WeCameraLogger.getTag(tag);
        if (logger != null) {
            logger.log(5, tag, t, s, args);
        } else if (logLevel <= 5) {
            if (args.length > 0) {
                Log.w((String)tag, (String)String.format(s, args), (Throwable)t);
            } else {
                Log.w((String)tag, (String)s, (Throwable)t);
            }
            WeCameraLogger.handleException(true, t);
        }
    }

    public static void e(String tag, Throwable t, String s, Object ... args) {
        tag = WeCameraLogger.getTag(tag);
        if (logger != null) {
            logger.log(6, tag, t, s, args);
        } else if (logLevel <= 6) {
            if (args.length > 0) {
                Log.e((String)tag, (String)String.format(s, args), (Throwable)t);
            } else {
                Log.e((String)tag, (String)s, (Throwable)t);
            }
            WeCameraLogger.handleException(true, t);
        }
    }

    public static void wtf(String tag, Throwable t, String s, Object ... args) {
        tag = WeCameraLogger.getTag(tag);
        if (logger != null) {
            logger.log(7, tag, t, s, args);
        } else if (logLevel <= 7) {
            if (args.length > 0) {
                Log.wtf((String)tag, (String)String.format(s, args), (Throwable)t);
            } else {
                Log.wtf((String)tag, (String)s, (Throwable)t);
            }
            WeCameraLogger.handleException(true, t);
        }
    }

    private static void handleException(boolean hasProcess, Throwable t) {
        if (exceptionHandler != null && t != null) {
            exceptionHandler.handle(hasProcess, t);
        }
    }

    private static String getTag(String tag) {
        if (tag == null) {
            return ROOT_TAT;
        }
        return ROOT_TAG_PREFIX + tag;
    }

    static {
        logLevel = 6;
        exceptionHandler = new ExceptionHandler(){

            @Override
            public void handle(boolean hasProcess, Throwable t) {
                if (t != null && !hasProcess) {
                    t.printStackTrace();
                }
            }
        };
        config = new Config();
        WeCameraLogger.closeLog();
    }

    public static interface ExceptionHandler {
        public void handle(boolean var1, Throwable var2);
    }

    public static abstract class ILog2
    extends ILog {
        @Override
        public void v(String tag, Throwable t, String msg, Object ... args) {
        }

        @Override
        public void d(String tag, Throwable t, String msg, Object ... args) {
        }

        @Override
        public void i(String tag, Throwable t, String msg, Object ... args) {
        }

        @Override
        public void w(String tag, Throwable t, String msg, Object ... args) {
        }

        @Override
        public void e(String tag, Throwable t, String msg, Object ... args) {
        }

        @Override
        public abstract void log(int var1, String var2, Throwable var3, String var4, Object ... var5);
    }

    public static abstract class ILog {
        public abstract void v(String var1, Throwable var2, String var3, Object ... var4);

        public abstract void d(String var1, Throwable var2, String var3, Object ... var4);

        public abstract void i(String var1, Throwable var2, String var3, Object ... var4);

        public abstract void w(String var1, Throwable var2, String var3, Object ... var4);

        public abstract void e(String var1, Throwable var2, String var3, Object ... var4);

        public void wtf(String tag, Throwable t, String msg, Object ... args) {
        }

        public void log(int level, String tag, Throwable t, String msg, Object ... args) {
            switch (level) {
                case 2: {
                    this.v(tag, t, msg, args);
                    break;
                }
                case 3: {
                    this.d(tag, t, msg, args);
                    break;
                }
                case 4: {
                    this.i(tag, t, msg, args);
                    break;
                }
                case 5: {
                    this.w(tag, t, msg, args);
                    break;
                }
                case 6: {
                    this.e(tag, t, msg, args);
                    break;
                }
                case 7: {
                    this.wtf(tag, t, msg, args);
                }
            }
        }
    }

    public static final class Config {
        private Config() {
        }

        public Config logLevel(int val) {
            logLevel = val;
            return this;
        }

        public Config exceptionHandler(ExceptionHandler val) {
            exceptionHandler = val;
            return this;
        }

        public Config proxy(ILog val) {
            logger = val;
            return this;
        }
    }
}

