/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.face.FaceDetector;
import com.webank.mbank.wecamera.face.FaceResult;
import com.webank.mbank.wecamera.face.WhenDetectFace;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import com.webank.mbank.wecamera.preview.PreviewParameter;

public class V1FaceDetector
implements FaceDetector {
    private static final String TAG = "V1FaceDetector";
    private Camera mCamera;
    private CameraDevice mCameraDevice;
    private boolean supportFaceDetect = false;
    private PreviewParameter cameraFeature;
    private WhenDetectFace mWhenDetectFace;

    public V1FaceDetector(CameraDevice cameraDevice, Camera camera) {
        this.mCameraDevice = cameraDevice;
        this.mCamera = camera;
        this.supportFaceDetect = this.supportFaceDetect();
        this.cameraFeature = this.mCameraDevice.getDisplayFeature();
    }

    @Override
    public FaceDetector startFaceDetect() {
        WeCameraLogger.i(TAG, "start face detect:current thread:" + Thread.currentThread().getName(), new Object[0]);
        if (this.supportFaceDetect) {
            this.mCamera.startFaceDetection();
        }
        return this;
    }

    @Override
    public FaceDetector stopFaceDetect() {
        WeCameraLogger.i(TAG, "stop face detect.", new Object[0]);
        if (this.supportFaceDetect) {
            this.mCamera.setFaceDetectionListener(null);
            this.mCamera.stopFaceDetection();
            if (this.mWhenDetectFace != null) {
                this.mWhenDetectFace.onGetFace(FaceResult.NONE);
            }
        }
        return this;
    }

    @Override
    public boolean supportFaceDetect() {
        return this.mCamera.getParameters().getMaxNumDetectedFaces() > 0;
    }

    @Override
    public FaceDetector whenDetect(WhenDetectFace callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback cannot be null.");
        }
        this.mWhenDetectFace = callback;
        if (this.supportFaceDetect) {
            this.mCamera.setFaceDetectionListener(new Camera.FaceDetectionListener(){

                public void onFaceDetection(Camera.Face[] faces, Camera camera) {
                    WeCameraLogger.d(V1FaceDetector.TAG, "on face detection:current thread:" + Thread.currentThread().getName(), new Object[0]);
                    FaceResult faceResult = new FaceResult();
                    faceResult.orientation(V1FaceDetector.this.cameraFeature.cameraOrientation()).previewSize(V1FaceDetector.this.cameraFeature.previewSize()).supportFaceSize(V1FaceDetector.this.mCamera.getParameters().getMaxNumDetectedFaces());
                    if (faces != null && faces.length > 0) {
                        for (int i = 0; i < faces.length; ++i) {
                            Camera.Face face = faces[i];
                            faceResult.addFace(face.rect, (float)face.score / 100.0f);
                        }
                    }
                    V1FaceDetector.this.mWhenDetectFace.onGetFace(faceResult);
                }
            });
        }
        return this;
    }
}

