/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.hardware.PreviewOperator;
import com.webank.mbank.wecamera.log.WeCameraLogger;

public class V1PreviewOperator
implements PreviewOperator {
    private static final String TAG = "V1PreviewOperator";
    private Camera mCamera;

    public V1PreviewOperator(Camera camera) {
        this.mCamera = camera;
    }

    @Override
    public void startPreview() {
        if (this.mCamera != null) {
            WeCameraLogger.d(TAG, "startPreview", new Object[0]);
            try {
                this.mCamera.startPreview();
            }
            catch (Throwable t) {
                CameraErrors.throwError(CameraException.ofDevice(3, "start preview failed", t));
            }
        }
    }

    @Override
    public void stopPreview() {
        if (this.mCamera != null) {
            try {
                WeCameraLogger.d(TAG, "stopPreview", new Object[0]);
                this.mCamera.stopPreview();
            }
            catch (Throwable t) {
                CameraErrors.throwError(CameraException.ofDevice(8, "stop preview failed", t));
            }
        }
    }
}

