/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.face;

import android.graphics.Matrix;
import android.graphics.Rect;
import com.webank.mbank.wecamera.config.feature.Size;
import java.util.ArrayList;
import java.util.List;

public class FaceResult {
    public static final FaceResult NONE = new FaceResult();
    int supportFaceSize;
    private int orientation;
    private Size previewSize;
    private List<Rect> faces;
    private List<Float> scores;

    public void addFace(Rect rect, float score) {
        if (this.faces == null) {
            this.faces = new ArrayList<Rect>();
        }
        if (this.scores == null) {
            this.scores = new ArrayList<Float>();
        }
        this.faces.add(rect);
        this.scores.add(Float.valueOf(score));
    }

    public List<Rect> faces() {
        return this.faces;
    }

    public List<Float> scores() {
        return this.scores;
    }

    public int supportFaceSize() {
        return this.supportFaceSize;
    }

    public FaceResult supportFaceSize(int supportFaceSize) {
        this.supportFaceSize = supportFaceSize;
        return this;
    }

    public int orientation() {
        return this.orientation;
    }

    public FaceResult orientation(int orientation) {
        this.orientation = orientation;
        return this;
    }

    public Size previewSize() {
        return this.previewSize;
    }

    public FaceResult previewSize(Size previewSize) {
        this.previewSize = previewSize;
        return this;
    }

    public static Matrix faceMatrix(int width, int height, boolean front, int displayOrientation) {
        Matrix matrix = new Matrix();
        boolean mirror = front;
        matrix.postScale(mirror ? -1.0f : 1.0f, 1.0f);
        matrix.postRotate((float)displayOrientation);
        matrix.postScale((float)width / 2000.0f, (float)height / 2000.0f);
        matrix.postTranslate((float)width / 2.0f, (float)height / 2.0f);
        return matrix;
    }
}

