/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.text.TextUtils;
import com.webank.mbank.wecamera.config.CameraConfigSelectors;
import com.webank.mbank.wecamera.config.ConfigOperate;
import com.webank.mbank.wecamera.config.feature.CameraFacing;
import com.webank.mbank.wecamera.config.feature.Size;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.hardware.v1.CameraV1;
import com.webank.mbank.wecamera.hardware.v1.V1RecordConfigOperator;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import com.webank.mbank.wecamera.utils.CameraUtils;
import com.webank.mbank.wecamera.video.CameraRecorder;
import com.webank.mbank.wecamera.video.RecordResult;
import com.webank.mbank.wecamera.video.Result;
import com.webank.mbank.wecamera.video.WeRecordResult;
import com.webank.mbank.wecamera.video.config.RecordConfig;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class V1CameraRecorder
implements CameraRecorder {
    private static final String TAG = "V1CameraRecorder";
    private final int mScreenOrientation;
    private CameraDevice mCameraDevice;
    private CameraV1 mCamera;
    private MediaRecorder mMediaRecorder;
    private RecordConfig mRecordConfig;
    private String mStorePath;
    private volatile boolean mRecordStarted = false;

    public V1CameraRecorder(CameraDevice cameraDevice, CameraV1 camera, int screenOrientation) {
        this.mCameraDevice = cameraDevice;
        this.mCamera = camera;
        this.mScreenOrientation = screenOrientation;
    }

    @Override
    public boolean isRecordStarted() {
        return this.mRecordStarted;
    }

    @Override
    public Result<RecordResult> startRecord(RecordConfig recordConfig, String path) {
        this.mRecordConfig = recordConfig;
        if (this.innerInitRecorder(recordConfig, path)) {
            this.mRecordStarted = this.innerStartRecorder();
            return WeRecordResult.ok(recordConfig, path);
        }
        return WeRecordResult.fail();
    }

    @Override
    public Result<RecordResult> stopRecord() {
        if (!this.mRecordStarted) {
            WeCameraLogger.w(TAG, "you must start record first,then stop record.", new Object[0]);
            return WeRecordResult.fail();
        }
        boolean result = this.innerStopRecorder();
        WeCameraLogger.i(TAG, "stop record:" + result, new Object[0]);
        return WeRecordResult.ok(this.mRecordConfig, this.mStorePath);
    }

    @Override
    public Result<RecordResult> cancelRecord() {
        WeCameraLogger.d(TAG, "cancel record.", new Object[0]);
        if (this.mRecordStarted) {
            this.stopRecord();
            this.clearOutput();
        }
        return WeRecordResult.ok(this.mRecordConfig, this.mStorePath);
    }

    private void clearOutput() {
        WeCameraLogger.d(TAG, "clear record output", new Object[0]);
        try {
            File file = new File(this.mRecordConfig.outDir());
            if (file.isFile() && file.exists()) {
                file.delete();
            }
        }
        catch (Exception e2) {
            WeCameraLogger.e(TAG, e2, "clear record file failed", new Object[0]);
        }
    }

    private boolean innerInitRecorder(RecordConfig recordConfig, String path) {
        try {
            String storePath;
            CamcorderProfile profile = this.initProfile(recordConfig);
            Camera.Parameters parameters = this.mCamera.camera().getParameters();
            this.setFocusMode(recordConfig);
            WeCameraLogger.d(TAG, "init recorder", new Object[0]);
            this.mMediaRecorder = new MediaRecorder();
            this.mCamera.camera().unlock();
            this.mMediaRecorder.reset();
            this.mMediaRecorder.setCamera(this.mCamera.camera());
            this.mMediaRecorder.setAudioSource(recordConfig != null ? recordConfig.audioSource() : 1);
            this.mMediaRecorder.setVideoSource(recordConfig != null ? recordConfig.videoSource() : 1);
            this.mMediaRecorder.setOrientationHint(this.getOrientationHint());
            this.mMediaRecorder.setProfile(profile);
            this.mStorePath = storePath = this.getStorePath(recordConfig, path);
            this.mMediaRecorder.setOutputFile(storePath);
            this.mMediaRecorder.setOnErrorListener(new MediaRecorder.OnErrorListener(){

                public void onError(MediaRecorder mr, int what, int extra) {
                    CameraErrors.throwError(CameraException.ofDevice(-2, "[" + what + "," + extra + "]"));
                    WeCameraLogger.e(V1CameraRecorder.TAG, "what=" + what + ",extra=" + extra, new Object[0]);
                }
            });
            List<ConfigOperate> configOperates = this.mRecordConfig.configOperates();
            if (configOperates != null && configOperates.size() > 0) {
                for (int i = configOperates.size() - 1; i >= 0; --i) {
                    ConfigOperate configOperate = configOperates.get(i);
                    if (!(configOperate instanceof V1RecordConfigOperator)) continue;
                    ((V1RecordConfigOperator)configOperate).operate(this.mMediaRecorder, this.mCamera, parameters);
                }
            }
            return true;
        }
        catch (Exception e2) {
            WeCameraLogger.e(TAG, e2, "init recorder failed", new Object[0]);
            this.innerLockCamera();
            return false;
        }
    }

    private void setFocusMode(RecordConfig recordConfig) {
        if (recordConfig.focusMode() != null) {
            this.mCameraDevice.updateConfig(new CameraConfigSelectors().focusMode(recordConfig.focusMode()));
        }
    }

    private String getStorePath(RecordConfig recordConfig, String path) {
        String resultPath = null;
        if (TextUtils.isEmpty((CharSequence)path)) {
            resultPath = recordConfig.outDir() + File.separator + recordConfig.videoNameGenerator().getName(recordConfig);
        } else if (new File(path).isAbsolute()) {
            resultPath = path;
        } else {
            if (TextUtils.isEmpty((CharSequence)recordConfig.outDir())) {
                throw new IllegalArgumentException("you use relative path ,so you must special RecordConfig.outDir ");
            }
            resultPath = recordConfig.outDir() + File.separator + path;
        }
        File file = new File(resultPath);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return resultPath;
    }

    private int getOrientationHint() {
        int correctRotation = CameraUtils.getCorrectRotation(this.mCamera.cameraFacing(), this.mScreenOrientation, this.mCamera.orientation());
        if (this.mCamera.cameraFacing() == CameraFacing.FRONT) {
            correctRotation = (360 - correctRotation) % 360;
        }
        return correctRotation;
    }

    private CamcorderProfile initProfile(RecordConfig recordConfig) {
        Size size;
        int audioSampleRate;
        CamcorderProfile profile = recordConfig.camcorderProfileSelector().select(null, this.mCamera);
        int videoBitRate = recordConfig.videoBitRate();
        if (videoBitRate >= 0) {
            profile.videoBitRate = videoBitRate;
        }
        if ((audioSampleRate = recordConfig.audioSampleRate()) >= 0) {
            profile.audioSampleRate = audioSampleRate;
        }
        if (recordConfig.videoCodec() >= 0) {
            profile.videoCodec = recordConfig.videoCodec();
        }
        if (recordConfig.fileFormat() >= 0) {
            profile.fileFormat = recordConfig.fileFormat();
        }
        boolean videoFrameSizeSet = false;
        if (recordConfig.videoFrameSize() != null && (size = recordConfig.videoFrameSize().select(this.mCamera.cameraSupportFeatures().supportVideoSizes(), this.mCamera)) != null) {
            profile.videoFrameWidth = size.width;
            profile.videoFrameHeight = size.height;
            videoFrameSizeSet = true;
        }
        if (!videoFrameSizeSet) {
            size = this.mCameraDevice.getDisplayFeature().previewSize();
            profile.videoFrameWidth = size.width;
            profile.videoFrameHeight = size.height;
        }
        return profile;
    }

    private boolean innerStartRecorder() {
        try {
            WeCameraLogger.d(TAG, "start recorder", new Object[0]);
            this.mMediaRecorder.prepare();
            this.mMediaRecorder.start();
            return true;
        }
        catch (IOException e2) {
            WeCameraLogger.e(TAG, e2, "start recorder failed", new Object[0]);
            this.innerReleaseRecorder();
            return false;
        }
    }

    private boolean innerStopRecorder() {
        try {
            WeCameraLogger.d(TAG, "stop recorder", new Object[0]);
            this.mMediaRecorder.stop();
            boolean bl = true;
            return bl;
        }
        catch (Exception e2) {
            WeCameraLogger.e(TAG, e2, "stop recorder failed", new Object[0]);
            boolean bl = false;
            return bl;
        }
        finally {
            this.mRecordStarted = false;
            this.innerReleaseRecorder();
        }
    }

    private void innerReleaseRecorder() {
        WeCameraLogger.d(TAG, "release recorder", new Object[0]);
        this.mMediaRecorder.reset();
        this.mMediaRecorder.release();
        this.innerLockCamera();
    }

    private void innerLockCamera() {
        this.mCamera.camera().lock();
    }
}

