/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import com.webank.mbank.wecamera.config.CameraConfig;
import com.webank.mbank.wecamera.config.CameraConfigSelector;
import com.webank.mbank.wecamera.config.CameraConfigSelectors;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.hardware.CameraV;
import com.webank.mbank.wecamera.log.WeCameraLogger;

public class V1ConfigSelector
implements CameraConfigSelector {
    private static final String TAG = "V1ConfigSelector";
    private CameraV mCameraV;

    public V1ConfigSelector(CameraV mCameraV) {
        this.mCameraV = mCameraV;
    }

    @Override
    public CameraConfig select(CameraConfigSelectors selectors) {
        if (selectors == null) {
            return null;
        }
        try {
            CameraConfig config = new CameraConfig();
            config.zoom(this.mCameraV.cameraSupportFeatures().zoomSupport() ? selectors.zoom() : -1.0f).flashMode(selectors.flashMode().select(this.mCameraV.cameraSupportFeatures().supportFlashModes(), this.mCameraV)).focusMode(selectors.focusMode().select(this.mCameraV.cameraSupportFeatures().supportFocusModes(), this.mCameraV)).pictureSize(selectors.pictureSize().select(this.mCameraV.cameraSupportFeatures().supportPictureSizes(), this.mCameraV)).videoSize(selectors.videoSize().select(this.mCameraV.cameraSupportFeatures().supportVideoSizes(), this.mCameraV)).previewSize(selectors.previewSize().select(this.mCameraV.cameraSupportFeatures().supportPreviewSizes(), this.mCameraV)).fps(selectors.fps().select(this.mCameraV.cameraSupportFeatures().fps(), this.mCameraV));
            WeCameraLogger.i(TAG, "get camera config:" + config.toString(), new Object[0]);
            return config;
        }
        catch (Exception e2) {
            CameraErrors.throwError(CameraException.ofDevice(21, "read parameter error", e2));
            return null;
        }
    }
}

