/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera;

import com.webank.mbank.wecamera.CameraAdapter;
import com.webank.mbank.wecamera.WeCamera;
import com.webank.mbank.wecamera.config.feature.CameraFacing;
import com.webank.mbank.wecamera.face.FaceDetector;
import com.webank.mbank.wecamera.face.WhenDetectFace;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.video.RecordController;
import com.webank.mbank.wecamera.video.config.RecordConfig;

public class WeCameraSwitcher {
    private CameraFacing mCameraFacing;
    private WeCamera mWeCamera;
    private FaceDetector mFaceDetector;
    private RecordController mRecordController;

    public WeCameraSwitcher(CameraFacing facing, WeCamera weCamera) {
        this.mCameraFacing = facing;
        this.mWeCamera = weCamera;
    }

    public void switchCamera(final WeCamera weCamera) {
        if (weCamera != null && this.mWeCamera != null) {
            this.mWeCamera.registerCameraListener(new CameraAdapter(){

                @Override
                public void previewBeforeStop(CameraDevice cameraDevice) {
                    WeCameraSwitcher.this.mFaceDetector = null;
                    WeCameraSwitcher.this.cancelRecord();
                }

                @Override
                public void cameraClosed() {
                    WeCameraSwitcher.this.mWeCamera = weCamera;
                    weCamera.start();
                }
            });
            this.mWeCamera.stop();
        }
    }

    public CameraFacing nextCamera() {
        CameraFacing cameraFacing;
        this.mCameraFacing = cameraFacing = this.mCameraFacing == CameraFacing.FRONT ? CameraFacing.BACK : CameraFacing.FRONT;
        return cameraFacing;
    }

    public void startFaceDetection(WhenDetectFace whenDetectFace) {
        this.mFaceDetector = this.mWeCamera.startFaceDetection(whenDetectFace);
    }

    public void stopFaceDetect() {
        if (this.mFaceDetector != null) {
            this.mFaceDetector.stopFaceDetect();
            this.mFaceDetector = null;
        }
    }

    public RecordController takeVideo() {
        this.mRecordController = this.mWeCamera.takeVideo(new String[0]);
        return this.mRecordController;
    }

    public RecordController takeVideo(RecordConfig recordConfig, String path) {
        this.mRecordController = this.mWeCamera.takeVideo(recordConfig, path);
        return this.mRecordController;
    }

    public boolean isRecording() {
        return this.mRecordController != null && this.mRecordController.isRecordStarted();
    }

    public void stopRecord() {
        if (this.mRecordController != null) {
            this.mRecordController.stopRecord();
            this.mRecordController = null;
        }
    }

    public void cancelRecord() {
        if (this.mRecordController != null) {
            this.mRecordController.cancelRecord();
            this.mRecordController = null;
        }
    }
}

