/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera;

import android.content.Context;
import android.text.TextUtils;
import com.webank.mbank.wecamera.CameraAdapter;
import com.webank.mbank.wecamera.CameraListener;
import com.webank.mbank.wecamera.WeCameraBuilder;
import com.webank.mbank.wecamera.WeCameraListener;
import com.webank.mbank.wecamera.config.CameraConfig;
import com.webank.mbank.wecamera.config.CameraConfigSelectors;
import com.webank.mbank.wecamera.config.CameraSupportFeatures;
import com.webank.mbank.wecamera.config.UpdateRequest;
import com.webank.mbank.wecamera.config.feature.CameraFacing;
import com.webank.mbank.wecamera.config.feature.ScaleType;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.face.FaceDetector;
import com.webank.mbank.wecamera.face.WhenDetectFace;
import com.webank.mbank.wecamera.focus.FocusCallback;
import com.webank.mbank.wecamera.hardware.CameraDevice;
import com.webank.mbank.wecamera.hardware.CameraProvider;
import com.webank.mbank.wecamera.hardware.CameraV;
import com.webank.mbank.wecamera.log.WeCameraLogger;
import com.webank.mbank.wecamera.picture.PictureResult;
import com.webank.mbank.wecamera.picture.TakePictureConfig;
import com.webank.mbank.wecamera.picture.TakePictureResult;
import com.webank.mbank.wecamera.preview.PreviewProcessor;
import com.webank.mbank.wecamera.preview.WePreviewCallback;
import com.webank.mbank.wecamera.utils.CameraUtils;
import com.webank.mbank.wecamera.utils.WeUI;
import com.webank.mbank.wecamera.video.CameraRecorder;
import com.webank.mbank.wecamera.video.RecordController;
import com.webank.mbank.wecamera.video.RecordResult;
import com.webank.mbank.wecamera.video.Result;
import com.webank.mbank.wecamera.video.WeAsyncCameraRecorder;
import com.webank.mbank.wecamera.video.WeRecordController;
import com.webank.mbank.wecamera.video.config.RecordConfig;
import com.webank.mbank.wecamera.view.CameraView;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;

public class WeCamera {
    private static final String TAG = "WeCamera";
    private volatile boolean mCameraStarted;
    private boolean previewCallbackStart = false;
    private static ExecutorService mCameraExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setName("WeCameraThread");
            return thread;
        }
    });
    private WeCameraListener mCameraListeners;
    private Context mContext;
    private CameraDevice mCameraDevice;
    private RecordConfig mRecordConfig;
    private CameraView mCameraView;
    private CameraFacing mCameraFacing = CameraFacing.BACK;
    private CameraConfigSelectors mCameraConfigSelectors;
    private ScaleType mScaleType;
    private CountDownLatch featureFetchLatch = new CountDownLatch(1);
    private CameraSupportFeatures mCameraSupportFeatures;
    private PreviewProcessor mPreviewProcessor;
    private List<WePreviewCallback> mWePreviewCallbacks;
    private CameraRecorder mCameraRecorder;
    private FaceDetector mFaceDetector;
    private CameraV mCameraV;

    public static WeCamera create(Context ctx, CameraFacing facing, CameraView cameraView) {
        return new WeCameraBuilder(ctx).facing(facing).into(cameraView).build();
    }

    WeCamera(Context ctx, CameraProvider cameraProvider, CameraView cameraView, CameraFacing facing, CameraConfigSelectors cameraConfigSelectors, ScaleType scaleType, CameraListener cameraListener, WePreviewCallback wePreviewCallback, RecordConfig recordConfig) {
        this.mContext = ctx;
        this.mCameraDevice = cameraProvider.get();
        this.mCameraView = cameraView;
        this.mCameraFacing = facing;
        this.mCameraConfigSelectors = cameraConfigSelectors;
        this.mScaleType = scaleType;
        this.mCameraListeners = new WeCameraListener();
        this.mCameraListeners.register(cameraListener);
        this.mWePreviewCallbacks = new ArrayList<WePreviewCallback>();
        if (wePreviewCallback != null) {
            this.mWePreviewCallbacks.add(wePreviewCallback);
        }
        this.mRecordConfig = recordConfig;
        this.registerCameraListener(new CameraAdapter(){

            @Override
            public void cameraOpened(CameraDevice cameraDevice, CameraV cameraV, CameraConfig cameraConfigResult) {
                WeCamera.this.mCameraSupportFeatures = cameraV.cameraSupportFeatures();
                WeCamera.this.featureFetchLatch.countDown();
            }
        });
    }

    public WeCamera registerCameraListener(CameraListener listener) {
        this.mCameraListeners.register(listener);
        return this;
    }

    public WeCamera unregisterCameraListener(CameraListener listener) {
        this.mCameraListeners.unregister(listener);
        return this;
    }

    public boolean canUse() {
        return this.mCameraStarted;
    }

    public CameraSupportFeatures getSupportFeatures() {
        try {
            this.featureFetchLatch.await();
        }
        catch (InterruptedException e2) {
            e2.printStackTrace();
        }
        return this.mCameraSupportFeatures;
    }

    public void autoFocus(final FocusCallback callback) {
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCameraLogger.d(WeCamera.TAG, "execute auto focus task.", new Object[0]);
                final boolean result = WeCamera.this.mCameraDevice.autoFocus();
                WeUI.post(new Runnable(){

                    @Override
                    public void run() {
                        if (result) {
                            callback.onFocusOk(WeCamera.this);
                        } else {
                            callback.onFocusFailed();
                        }
                    }
                });
            }
        });
    }

    public void takeZoom(final float zoom) {
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCameraLogger.d(WeCamera.TAG, "execute zoom task.", new Object[0]);
                WeCamera.this.mCameraDevice.takeZoom(zoom);
                WeCamera.this.mCameraListeners.cameraConfigChanged(WeCamera.this.mCameraDevice.getDisplayFeature(), WeCamera.this.mCameraV, WeCamera.this.mCameraDevice.updateConfig(null));
            }
        });
    }

    public void start() {
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCameraLogger.d(WeCamera.TAG, "execute start camera task.", new Object[0]);
                CameraV cameraV = WeCamera.this.mCameraDevice.open(WeCamera.this.mCameraFacing);
                if (cameraV == null) {
                    CameraErrors.throwError(CameraException.ofFatal(1, "get camera failed.", null));
                    return;
                }
                WeCamera.this.mCameraV = cameraV;
                WeCamera.this.mCameraStarted = true;
                CameraConfig cameraConfig = WeCamera.this.mCameraDevice.updateConfig(WeCamera.this.mCameraConfigSelectors);
                WeCamera.this.mCameraDevice.setDisplayOrientation(WeCamera.this.mCameraConfigSelectors.displayOrientationOperator(), CameraUtils.getScreenRealOrientation(WeCamera.this.mContext));
                WeCamera.this.mCameraListeners.cameraOpened(WeCamera.this.mCameraDevice, cameraV, cameraConfig);
                if (WeCamera.this.mCameraView != null) {
                    WeCamera.this.mCameraView.setScaleType(WeCamera.this.mScaleType);
                }
                WeCamera.this.mPreviewProcessor = WeCamera.this.mCameraDevice.getPreviewProcessor();
                if (WeCamera.this.mWePreviewCallbacks.size() > 0) {
                    for (int i = 0; i < WeCamera.this.mWePreviewCallbacks.size(); ++i) {
                        WeCamera.this.mPreviewProcessor.addPreviewFrameCallback((WePreviewCallback)WeCamera.this.mWePreviewCallbacks.get(i));
                    }
                    WeCamera.this.mPreviewProcessor.start();
                    WeCamera.this.previewCallbackStart = true;
                }
                if (WeCamera.this.mCameraView != null) {
                    WeCamera.this.mCameraView.attachCameraView(WeCamera.this.mCameraDevice);
                }
                WeCamera.this.mCameraListeners.previewBeforeStart(WeCamera.this.mCameraView, cameraConfig, WeCamera.this.mCameraDevice.getDisplayFeature(), WeCamera.this.mCameraV);
                WeCamera.this.mCameraDevice.startPreview();
                WeCamera.this.mCameraListeners.previewAfterStart(WeCamera.this.mCameraDevice);
            }
        });
    }

    public void stop() {
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCameraLogger.d(WeCamera.TAG, "execute stop camera task.", new Object[0]);
                WeCamera.this.mCameraListeners.previewBeforeStop(WeCamera.this.mCameraDevice);
                WeCamera.this.mCameraDevice.stopPreview();
                WeCamera.this.mCameraStarted = false;
                WeCamera.this.mCameraDevice.close();
                WeCamera.this.mCameraListeners.cameraClosed();
                if (WeCamera.this.mFaceDetector != null) {
                    WeCamera.this.mFaceDetector.stopFaceDetect();
                    WeCamera.this.mFaceDetector = null;
                }
            }
        });
    }

    public void updateConfig(final UpdateRequest updateRequest) {
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCameraLogger.d(WeCamera.TAG, "execute update parameter task.", new Object[0]);
                CameraConfig cameraConfig = WeCamera.this.mCameraDevice.updateConfig(updateRequest.selectors());
                WeCamera.this.mCameraListeners.cameraConfigChanged(WeCamera.this.mCameraDevice.getDisplayFeature(), WeCamera.this.mCameraV, cameraConfig);
            }
        });
    }

    public WeCamera previewCallback(WePreviewCallback wePreviewCallback) {
        if (wePreviewCallback != null) {
            this.mWePreviewCallbacks.add(wePreviewCallback);
            if (this.mPreviewProcessor != null) {
                this.mPreviewProcessor.addPreviewFrameCallback(wePreviewCallback);
            }
        }
        return this;
    }

    public WeCamera removePreviewCallback(WePreviewCallback wePreviewCallback) {
        if (wePreviewCallback != null) {
            this.mWePreviewCallbacks.remove(wePreviewCallback);
            if (this.mPreviewProcessor != null) {
                this.mPreviewProcessor.removePreviewFrameCallback(wePreviewCallback);
            }
        }
        return this;
    }

    public void startPreviewCallback() {
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCameraLogger.d(WeCamera.TAG, "execute start preview callback task.", new Object[0]);
                if (WeCamera.this.canUse() && !WeCamera.this.previewCallbackStart && WeCamera.this.mPreviewProcessor != null) {
                    WeCamera.this.previewCallbackStart = true;
                    WeCamera.this.mPreviewProcessor.start();
                }
            }
        });
    }

    public WeCamera runInCameraThread(Runnable runnable) {
        if (runnable != null) {
            mCameraExecutor.submit(runnable);
        }
        return this;
    }

    public void stopPreviewCallback() {
        mCameraExecutor.submit(new Runnable(){

            @Override
            public void run() {
                WeCameraLogger.d(WeCamera.TAG, "execute stop preview callback task.", new Object[0]);
                if (WeCamera.this.canUse() && WeCamera.this.previewCallbackStart && WeCamera.this.mPreviewProcessor != null) {
                    WeCamera.this.previewCallbackStart = false;
                    WeCamera.this.mPreviewProcessor.stop();
                }
            }
        });
    }

    public TakePictureResult takePicture() {
        return this.takePicture(null);
    }

    public TakePictureResult takePicture(TakePictureConfig config) {
        if (config == null) {
            config = new TakePictureConfig();
        }
        TakePictureResult takePictureResult = new TakePictureResult();
        final TakePictureConfig finalConfig = config;
        FutureTask<PictureResult> resultFutureTask = new FutureTask<PictureResult>(new Callable<PictureResult>(){

            @Override
            public PictureResult call() throws Exception {
                WeCameraLogger.d(WeCamera.TAG, "execute take picture task.", new Object[0]);
                if (finalConfig.autoFocusFirst()) {
                    for (int retryTimes = 0; retryTimes < finalConfig.focusRetryTimes(); ++retryTimes) {
                        WeCameraLogger.d(WeCamera.TAG, "auto focus (" + (retryTimes + 1) + ") times.", new Object[0]);
                        boolean focus = WeCamera.this.mCameraDevice.autoFocus();
                        if (focus) break;
                    }
                }
                PictureResult pictureResult = WeCamera.this.mCameraDevice.takePicture();
                WeCamera.this.mCameraDevice.startPreview();
                return pictureResult;
            }
        });
        mCameraExecutor.submit(resultFutureTask);
        return takePictureResult.takeFutureTask(resultFutureTask);
    }

    public FaceDetector startFaceDetection(WhenDetectFace callback) {
        this.mFaceDetector = this.mCameraDevice.getFaceDetector();
        this.mFaceDetector.whenDetect(callback);
        return this.mFaceDetector.startFaceDetect();
    }

    public RecordController takeVideo(RecordConfig recordConfig, String path) {
        RecordConfig config;
        if (TextUtils.isEmpty((CharSequence)path)) {
            boolean noFileConfig = true;
            if (recordConfig != null && !TextUtils.isEmpty((CharSequence)recordConfig.outDir())) {
                noFileConfig = false;
            } else if (this.mRecordConfig != null && !TextUtils.isEmpty((CharSequence)this.mRecordConfig.outDir())) {
                noFileConfig = false;
            }
            if (noFileConfig) {
                throw new IllegalArgumentException("you must config record store path");
            }
        }
        if ((config = recordConfig == null ? this.mRecordConfig : recordConfig) == null) {
            config = new RecordConfig();
        }
        CameraRecorder cameraRecorder = this.mCameraDevice.getCameraRecorder();
        this.mCameraRecorder = new WeAsyncCameraRecorder(cameraRecorder, mCameraExecutor);
        Result<RecordResult> startResult = this.mCameraRecorder.startRecord(config, path);
        return new WeRecordController(startResult, this.mCameraRecorder, mCameraExecutor);
    }

    public RecordController takeVideo(String ... path) {
        String resultPath = null;
        if (path != null && path.length > 0) {
            resultPath = TextUtils.join((CharSequence)File.separator, (Object[])path);
        }
        return this.takeVideo((RecordConfig)null, resultPath);
    }
}

