/*
 * Decompiled with CFR 0.152.
 */
package com.webank.mbank.wecamera.hardware.v1;

import android.hardware.Camera;
import com.webank.mbank.wecamera.config.feature.CameraFacing;
import com.webank.mbank.wecamera.error.CameraErrors;
import com.webank.mbank.wecamera.error.CameraException;
import com.webank.mbank.wecamera.hardware.CameraConnector;
import com.webank.mbank.wecamera.hardware.CameraV;
import com.webank.mbank.wecamera.hardware.v1.CameraV1;
import com.webank.mbank.wecamera.log.WeCameraLogger;

public class V1Connector
implements CameraConnector {
    private static final String TAG = "V1Connector";
    private Camera mCamera;
    private int mCameraId;
    private Camera.CameraInfo mCameraInfo;
    private CameraFacing mCameraFacing;

    @Override
    public CameraV open(CameraFacing type) {
        this.mCameraFacing = type;
        WeCameraLogger.d(TAG, "\u9700\u8981\u7684\u6444\u50cf\u5934:" + type.toString(), new Object[0]);
        int numberOfCameras = Camera.getNumberOfCameras();
        WeCameraLogger.d(TAG, "open camera:number of cameras=%d", numberOfCameras);
        if (numberOfCameras <= 0) {
            CameraErrors.throwError(CameraException.ofFatal(11, "no camera can use:numberOfCameras is 0", null));
            return null;
        }
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        if (numberOfCameras == 1) {
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)cameraInfo);
            this.mCameraFacing = this.getFacingType(cameraInfo.facing);
            return this.openCamera(cameraInfo, 0);
        }
        for (int i = 0; i < numberOfCameras; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            WeCameraLogger.d(TAG, "camera:" + i + ":face=" + cameraInfo.facing, new Object[0]);
            if (!V1Connector.isTargetV1Type(type, cameraInfo.facing)) continue;
            WeCameraLogger.i(TAG, "camera open:find dest camera:face=%s,camera id=%d", type.toString(), i);
            return this.openCamera(cameraInfo, i);
        }
        return null;
    }

    private CameraFacing getFacingType(int facing) {
        if (facing == 0) {
            return CameraFacing.BACK;
        }
        if (facing == 1) {
            return CameraFacing.FRONT;
        }
        return CameraFacing.BACK;
    }

    private CameraV openCamera(Camera.CameraInfo cameraInfo, int i) {
        this.mCamera = Camera.open((int)i);
        this.mCameraInfo = cameraInfo;
        this.mCameraId = i;
        return this.cameraV();
    }

    public static boolean isTargetV1Type(CameraFacing type, int facing) {
        if (facing == 0 && type == CameraFacing.BACK) {
            return true;
        }
        return facing == 1 && type == CameraFacing.FRONT;
    }

    @Override
    public void close() {
        if (this.mCamera != null) {
            WeCameraLogger.d(TAG, "close camera:" + this.mCamera, new Object[0]);
            this.mCamera.release();
            this.mCameraInfo = null;
            this.mCamera = null;
        }
    }

    public int cameraId() {
        return this.mCameraId;
    }

    public Camera.CameraInfo cameraInfo() {
        return this.mCameraInfo;
    }

    public CameraV1 cameraV() {
        return new CameraV1().camera(this.mCamera).orientation(this.mCameraInfo.orientation).cameraInfo(this.mCameraInfo).cameraFacing(this.mCameraFacing).cameraId(this.mCameraId);
    }
}

