/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.youtuface;

import android.text.TextUtils;
import java.io.BufferedWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;

public class HttpUtil {
    private static final int DEFAULT_TIMEOUT_MILLIS = 10000;
    private static final String CHARSET_UTF8 = "UTF-8";

    public static String post(String string, String string2, HttpResponseListener httpResponseListener) {
        HttpURLConnection httpURLConnection = HttpUtil.buildConnection(string, 10000);
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestMethod("POST");
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            OutputStream outputStream = httpURLConnection.getOutputStream();
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, CHARSET_UTF8));
            bufferedWriter.write(string2);
            bufferedWriter.flush();
            bufferedWriter.close();
            outputStream.close();
        }
        return HttpUtil.getResponse(httpURLConnection, httpResponseListener);
    }

    private static HttpURLConnection buildConnection(String string, int n) {
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setConnectTimeout(n);
        httpURLConnection.setReadTimeout(n);
        return httpURLConnection;
    }

    private static String getResponse(HttpURLConnection httpURLConnection, HttpResponseListener httpResponseListener) {
        int n = httpURLConnection.getResponseCode();
        if (n == 200) {
            int n2;
            InputStream inputStream = httpURLConnection.getInputStream();
            StringBuilder stringBuilder = new StringBuilder();
            byte[] byArray = new byte[1024];
            while ((n2 = inputStream.read(byArray)) != -1) {
                stringBuilder.append(new String(byArray, 0, n2));
            }
            inputStream.close();
            String string = stringBuilder.toString();
            if (httpResponseListener != null) {
                httpResponseListener.onSuccess(string);
            }
            return string;
        }
        if (httpResponseListener != null) {
            httpResponseListener.onFail(n);
        }
        return null;
    }

    public static interface HttpResponseListener {
        public void onSuccess(String var1);

        public void onFail(int var1);
    }
}

