/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.magnet.core.crossprocess;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.unionyy.mobile.magnet.core.MagnetCore;
import com.unionyy.mobile.magnet.core.init.UdbConfig;
import com.unionyy.mobile.magnet.core.log.Logger;
import com.unionyy.mobile.magnet.core.login.AuthCallback;
import com.unionyy.mobile.magnet.core.login.AuthClient;
import com.unionyy.mobile.magnet.core.state.LoginStateVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001c\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/unionyy/mobile/magnet/core/crossprocess/SouthPoleReceiver;", "Landroid/content/BroadcastReceiver;", "magnet", "Lcom/unionyy/mobile/magnet/core/MagnetCore;", "udbConfig", "Lcom/unionyy/mobile/magnet/core/init/UdbConfig;", "client", "Lcom/unionyy/mobile/magnet/core/login/AuthClient;", "loginState", "Lcom/unionyy/mobile/magnet/core/state/LoginStateVisitor;", "(Lcom/unionyy/mobile/magnet/core/MagnetCore;Lcom/unionyy/mobile/magnet/core/init/UdbConfig;Lcom/unionyy/mobile/magnet/core/login/AuthClient;Lcom/unionyy/mobile/magnet/core/state/LoginStateVisitor;)V", "onReceive", "", "context", "Landroid/content/Context;", "intent", "Landroid/content/Intent;", "Companion", "southpole_release"})
public final class SouthPoleReceiver
extends BroadcastReceiver {
    private final MagnetCore magnet;
    private final UdbConfig udbConfig;
    private final AuthClient client;
    private final LoginStateVisitor loginState;
    private static final String TAG = "Receiver";
    public static final Companion Companion = new Companion(null);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onReceive(@Nullable Context context, @Nullable Intent intent) {
        String string;
        if (context == null) {
            return;
        }
        if (intent == null) {
            return;
        }
        String appid = intent.getStringExtra("MAGNET_APP_ID");
        String appKey = intent.getStringExtra("MAGNET_APP_KEY");
        if (Intrinsics.areEqual((Object)appid, (Object)this.udbConfig.getAppid()) ^ true || Intrinsics.areEqual((Object)appKey, (Object)this.udbConfig.getAppKey()) ^ true) {
            Logger.INSTANCE.info(TAG, "receive NORTH_AUTH_ACTION, but the target " + "appid = " + appid + ", appKey = " + appKey + ", and our appid = " + this.udbConfig.getAppid() + ", " + "appKey = " + appKey);
            return;
        }
        String string2 = string = intent.getAction();
        if (string2 == null) return;
        switch (string2.hashCode()) {
            case 1700221525: {
                if (!string.equals("com.unionyy.mobile.magnet.action.NORTH_READY")) return;
                break;
            }
            case -1993998703: {
                if (!string.equals("com.unionyy.mobile.magnet.action.NORTH")) return;
                long uid = intent.getLongExtra("MAGNET_UID", 0L);
                if (this.magnet.getUid() == uid) {
                    Logger.INSTANCE.info(TAG, "receive NORTH_AUTH_ACTION, and the current state " + "is up-to-date. uid = " + uid + '.');
                    return;
                }
                String string3 = intent.getStringExtra("MAGNET_PACKAGE");
                if (string3 == null) {
                    string3 = "[unknown]";
                }
                String packageName = string3;
                Logger.INSTANCE.info(TAG, "receive NORTH_AUTH_ACTION from " + packageName + ", uid = " + uid);
                if (uid <= 0L) {
                    this.client.logout();
                    return;
                }
                Companion.sendPrepareLoginBroadcast(context, this.udbConfig, uid);
                return;
            }
        }
        long uid = intent.getLongExtra("MAGNET_UID", 0L);
        String credit = intent.getStringExtra("MAGNET_CREDIT");
        String thirdPartyInfo = intent.getStringExtra("MAGNET_THIRD_PARTY");
        String packageName = intent.getStringExtra("MAGNET_PACKAGE");
        Logger.INSTANCE.info(TAG, "receive NORTH_READY_ACTION to " + packageName + ", uid = " + uid);
        if (!Intrinsics.areEqual((Object)context.getPackageName(), (Object)packageName)) return;
        if (uid <= 0L) {
            this.client.logout();
            return;
        }
        if (credit == null) return;
        if (thirdPartyInfo != null) {
            this.loginState.setThirdPartyInfo(thirdPartyInfo);
        }
        this.client.creditLogin(uid, credit, new AuthCallback(){

            public void onSuccess(long yyUid, @NotNull String ticket, boolean isNewUser) {
                Intrinsics.checkParameterIsNotNull((Object)ticket, (String)"ticket");
                AuthCallback.DefaultImpls.onSuccess(this, yyUid, ticket, isNewUser);
            }

            public void onFail(@Nullable String reason) {
                AuthCallback.DefaultImpls.onFail(this, reason);
            }
        });
    }

    private SouthPoleReceiver(MagnetCore magnet, UdbConfig udbConfig2, AuthClient client, LoginStateVisitor loginState) {
        this.magnet = magnet;
        this.udbConfig = udbConfig2;
        this.client = client;
        this.loginState = loginState;
    }

    public /* synthetic */ SouthPoleReceiver(@NotNull MagnetCore magnet, @NotNull UdbConfig udbConfig2, @NotNull AuthClient client, @NotNull LoginStateVisitor loginState, DefaultConstructorMarker $constructor_marker) {
        this(magnet, udbConfig2, client, loginState);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0015\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0016\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/unionyy/mobile/magnet/core/crossprocess/SouthPoleReceiver$Companion;", "", "()V", "TAG", "", "register", "", "magnet", "Lcom/unionyy/mobile/magnet/core/MagnetCore;", "context", "Landroid/content/Context;", "udbConfig", "Lcom/unionyy/mobile/magnet/core/init/UdbConfig;", "client", "Lcom/unionyy/mobile/magnet/core/login/AuthClient;", "loginState", "Lcom/unionyy/mobile/magnet/core/state/LoginStateVisitor;", "sendLoginBroadcast", "uid", "", "sendLogoutBroadcast", "sendPrepareLoginBroadcast", "sendReadyBroadcast", "southpole_release"})
    public static final class Companion {
        public final void register(@NotNull MagnetCore magnet, @NotNull Context context, @NotNull UdbConfig udbConfig2, @NotNull AuthClient client, @NotNull LoginStateVisitor loginState) {
            IntentFilter intentFilter;
            Intrinsics.checkParameterIsNotNull((Object)magnet, (String)"magnet");
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)udbConfig2, (String)"udbConfig");
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)loginState, (String)"loginState");
            IntentFilter $receiver = intentFilter = new IntentFilter();
            $receiver.addAction("com.unionyy.mobile.magnet.action.NORTH");
            $receiver.addAction("com.unionyy.mobile.magnet.action.NORTH_READY");
            IntentFilter filter = intentFilter;
            context.registerReceiver((BroadcastReceiver)new SouthPoleReceiver(magnet, udbConfig2, client, loginState, null), filter);
        }

        public final void sendReadyBroadcast(@NotNull Context context, @NotNull UdbConfig udbConfig2) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)udbConfig2, (String)"udbConfig");
            Intent intent = new Intent("com.unionyy.mobile.magnet.action.SOUTH_READY").putExtra("MAGNET_APP_ID", udbConfig2.getAppid()).putExtra("MAGNET_APP_KEY", udbConfig2.getAppKey()).putExtra("MAGNET_PACKAGE", context.getPackageName());
            context.sendBroadcast(intent);
            Logger.INSTANCE.info(SouthPoleReceiver.TAG, "sendReadyBroadcast SOUTH_READY_ACTION");
        }

        public final void sendPrepareLoginBroadcast(@NotNull Context context, @NotNull UdbConfig udbConfig2, long uid) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)udbConfig2, (String)"udbConfig");
            Intent intent = new Intent("com.unionyy.mobile.magnet.action.SOUTH_PREPARE_LOGIN").putExtra("MAGNET_APP_ID", udbConfig2.getAppid()).putExtra("MAGNET_APP_KEY", udbConfig2.getAppKey()).putExtra("MAGNET_UID", uid).putExtra("MAGNET_PACKAGE", context.getPackageName());
            context.sendBroadcast(intent);
            Logger.INSTANCE.info(SouthPoleReceiver.TAG, "sendReadyBroadcast SOUTH_PREPARE_LOGIN_ACTION");
        }

        public final void sendLoginBroadcast(@NotNull Context context, @NotNull UdbConfig udbConfig2, long uid) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)udbConfig2, (String)"udbConfig");
            Intent intent = new Intent("com.unionyy.mobile.magnet.action.SOUTH_LOGIN").putExtra("MAGNET_APP_ID", udbConfig2.getAppid()).putExtra("MAGNET_APP_KEY", udbConfig2.getAppKey()).putExtra("MAGNET_UID", uid).putExtra("MAGNET_PACKAGE", context.getPackageName());
            context.sendBroadcast(intent);
            Logger.INSTANCE.info(SouthPoleReceiver.TAG, "sendLoginBroadcast SOUTH_LOGIN_ACTION");
        }

        public final void sendLogoutBroadcast(@NotNull Context context, @NotNull UdbConfig udbConfig2) {
            Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)udbConfig2, (String)"udbConfig");
            Intent intent = new Intent("com.unionyy.mobile.magnet.action.SOUTH_LOGOUT").putExtra("MAGNET_APP_ID", udbConfig2.getAppid()).putExtra("MAGNET_APP_KEY", udbConfig2.getAppKey()).putExtra("MAGNET_PACKAGE", context.getPackageName());
            context.sendBroadcast(intent);
            Logger.INSTANCE.info(SouthPoleReceiver.TAG, "sendLogoutBroadcast SOUTH_LOGOUT_ACTION");
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

