/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.magnet.core.crossprocess;

import android.content.Context;
import com.unionyy.mobile.magnet.core.MagnetCore;
import com.unionyy.mobile.magnet.core.crossprocess.NorthCrossProcessLoginListener;
import com.unionyy.mobile.magnet.core.crossprocess.NorthPoleReceiver;
import com.unionyy.mobile.magnet.core.crossprocess.SouthCrossProcessLoginListener;
import com.unionyy.mobile.magnet.core.crossprocess.SouthPoleReceiver;
import com.unionyy.mobile.magnet.core.init.CrossProcessMode;
import com.unionyy.mobile.magnet.core.init.UdbConfig;
import com.unionyy.mobile.magnet.core.log.Logger;
import com.unionyy.mobile.magnet.core.login.AuthCallback;
import com.unionyy.mobile.magnet.core.login.AuthClient;
import com.unionyy.mobile.magnet.core.login.AuthStateListener;
import com.unionyy.mobile.magnet.core.login.GlobalLoginAnnouncer;
import com.unionyy.mobile.magnet.core.repo.MagnetRepository;
import com.unionyy.mobile.magnet.core.state.LoginStateVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\\\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/unionyy/mobile/magnet/core/crossprocess/CrossProcessModeRunner;", "", "()V", "TAG", "", "execute", "", "crossProcessMode", "Lcom/unionyy/mobile/magnet/core/init/CrossProcessMode;", "magnet", "Lcom/unionyy/mobile/magnet/core/MagnetCore;", "application", "Landroid/content/Context;", "udbConfig", "Lcom/unionyy/mobile/magnet/core/init/UdbConfig;", "client", "Lcom/unionyy/mobile/magnet/core/login/AuthClient;", "loginState", "Lcom/unionyy/mobile/magnet/core/state/LoginStateVisitor;", "stateListeners", "", "Lcom/unionyy/mobile/magnet/core/login/AuthStateListener;", "loginAnnouncer", "Lcom/unionyy/mobile/magnet/core/login/GlobalLoginAnnouncer;", "loginRepo", "Lcom/unionyy/mobile/magnet/core/repo/MagnetRepository;", "enableAutoLogin", "", "southpole_release"})
public final class CrossProcessModeRunner {
    private static final String TAG = "CP";
    public static final CrossProcessModeRunner INSTANCE;

    public final void execute(@NotNull CrossProcessMode crossProcessMode, @NotNull MagnetCore magnet, @NotNull Context application, @NotNull UdbConfig udbConfig2, @NotNull AuthClient client, @NotNull LoginStateVisitor loginState, @NotNull List<AuthStateListener> stateListeners, @NotNull GlobalLoginAnnouncer loginAnnouncer, @NotNull MagnetRepository loginRepo, boolean enableAutoLogin) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)crossProcessMode), (String)"crossProcessMode");
        Intrinsics.checkParameterIsNotNull((Object)magnet, (String)"magnet");
        Intrinsics.checkParameterIsNotNull((Object)application, (String)"application");
        Intrinsics.checkParameterIsNotNull((Object)udbConfig2, (String)"udbConfig");
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)loginState, (String)"loginState");
        Intrinsics.checkParameterIsNotNull(stateListeners, (String)"stateListeners");
        Intrinsics.checkParameterIsNotNull((Object)loginAnnouncer, (String)"loginAnnouncer");
        Intrinsics.checkParameterIsNotNull((Object)loginRepo, (String)"loginRepo");
        if (Intrinsics.areEqual((Object)((Object)crossProcessMode), (Object)((Object)CrossProcessMode.South))) {
            SouthPoleReceiver.Companion.register(magnet, application, udbConfig2, client, loginState);
            stateListeners.add(new SouthCrossProcessLoginListener(application, udbConfig2));
        } else if (Intrinsics.areEqual((Object)((Object)crossProcessMode), (Object)((Object)CrossProcessMode.North))) {
            NorthPoleReceiver.Companion.register(magnet, application, udbConfig2, loginState, loginAnnouncer, loginRepo);
            stateListeners.add(new NorthCrossProcessLoginListener(application, udbConfig2, loginState));
        }
        if (Intrinsics.areEqual((Object)((Object)crossProcessMode), (Object)((Object)CrossProcessMode.South))) {
            SouthPoleReceiver.Companion.sendReadyBroadcast(application, udbConfig2);
        } else if (enableAutoLogin) {
            Logger.INSTANCE.info(TAG, "auto login");
            client.creditLogin(new AuthCallback(){

                public void onSuccess(long yyUid, @NotNull String ticket, boolean isNewUser) {
                    Intrinsics.checkParameterIsNotNull((Object)ticket, (String)"ticket");
                    AuthCallback.DefaultImpls.onSuccess(this, yyUid, ticket, isNewUser);
                }

                public void onFail(@Nullable String reason) {
                    AuthCallback.DefaultImpls.onFail(this, reason);
                }
            });
        }
    }

    private CrossProcessModeRunner() {
    }

    static {
        CrossProcessModeRunner crossProcessModeRunner;
        INSTANCE = crossProcessModeRunner = new CrossProcessModeRunner();
    }
}

