/*
 * Decompiled with CFR 0.152.
 */
package com.unionyy.mobile.magnet.core.login;

import android.support.annotation.MainThread;
import com.unionyy.mobile.magnet.core.log.Logger;
import com.unionyy.mobile.magnet.core.login.AuthStateListener;
import com.unionyy.mobile.magnet.core.repo.KickOffCode;
import com.unionyy.mobile.magnet.core.repo.LoginException;
import com.unionyy.mobile.magnet.core.repo.LoginSuccessEvent;
import com.unionyy.mobile.magnet.core.repo.SelfInfo;
import com.unionyy.mobile.magnet.core.repo.ThirdPartyInfo;
import com.unionyy.mobile.magnet.core.state.CrossProcessLoginState;
import com.unionyy.mobile.magnet.core.state.InterruptState;
import com.unionyy.mobile.magnet.core.state.LoginState;
import com.unionyy.mobile.magnet.core.state.LoginStateVisitor;
import com.unionyy.mobile.magnet.core.state.LogoutState;
import io.reactivex.Scheduler;
import io.reactivex.android.schedulers.AndroidSchedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\u001f\u0010\u000f\u001a\u00020\u00102\u0014\b\u0004\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u0012H\u0082\bJ\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0017J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0015H\u0007J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0017J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\b\u0010\u001f\u001a\u00020\u0010H\u0017J\u0010\u0010 \u001a\u00020\u00102\u0006\u0010\u000e\u001a\u00020\rH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/unionyy/mobile/magnet/core/login/GlobalLoginAnnouncer;", "Lcom/unionyy/mobile/magnet/core/login/AuthStateListener;", "TAG", "", "state", "Lcom/unionyy/mobile/magnet/core/state/LoginStateVisitor;", "listeners", "", "(Ljava/lang/String;Lcom/unionyy/mobile/magnet/core/state/LoginStateVisitor;Ljava/util/List;)V", "scheduler", "Lio/reactivex/Scheduler;", "kotlin.jvm.PlatformType", "addThirdPartyInfo", "Lcom/unionyy/mobile/magnet/core/repo/LoginSuccessEvent;", "info", "notify", "", "doSomething", "Lkotlin/Function1;", "onAnonymousLogin", "anonymousUid", "", "onCrossProcessLogin", "uid", "onKickOff", "code", "Lcom/unionyy/mobile/magnet/core/repo/KickOffCode;", "reason", "onLoginInterrupt", "error", "Lcom/unionyy/mobile/magnet/core/repo/LoginException;", "onLogout", "onNamedLogin", "southpole_release"})
public class GlobalLoginAnnouncer
implements AuthStateListener {
    private final Scheduler scheduler;
    private final String TAG;
    private final LoginStateVisitor state;
    private final List<AuthStateListener> listeners;

    @Override
    @MainThread
    public void onAnonymousLogin(long anonymousUid) {
        this.state.moveToState(new InterruptState(anonymousUid));
        Logger.INSTANCE.info(this.TAG, "\u533f\u540d\u767b\u5f55: uid = " + anonymousUid);
        GlobalLoginAnnouncer this_$iv = this;
        this_$iv.scheduler.scheduleDirect(new Runnable(this_$iv, anonymousUid){
            final /* synthetic */ GlobalLoginAnnouncer this$0;
            final /* synthetic */ long $anonymousUid$inlined;
            {
                this.this$0 = globalLoginAnnouncer;
                this.$anonymousUid$inlined = l;
            }

            public final void run() {
                Iterable $receiver$iv = GlobalLoginAnnouncer.access$getListeners$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    AuthStateListener it;
                    AuthStateListener it2 = it = (AuthStateListener)element$iv;
                    it2.onAnonymousLogin(this.$anonymousUid$inlined);
                }
            }
        });
    }

    @Override
    @MainThread
    public void onNamedLogin(@NotNull LoginSuccessEvent info) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        LoginSuccessEvent successEvent = this.addThirdPartyInfo(info);
        this.state.moveToState(new LoginState(successEvent));
        Logger.INSTANCE.info(this.TAG, "\u767b\u5f55\u6210\u529f: " + successEvent);
        GlobalLoginAnnouncer this_$iv = this;
        this_$iv.scheduler.scheduleDirect(new Runnable(this_$iv, successEvent){
            final /* synthetic */ GlobalLoginAnnouncer this$0;
            final /* synthetic */ LoginSuccessEvent $successEvent$inlined;
            {
                this.this$0 = globalLoginAnnouncer;
                this.$successEvent$inlined = loginSuccessEvent;
            }

            public final void run() {
                Iterable $receiver$iv = GlobalLoginAnnouncer.access$getListeners$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    AuthStateListener it;
                    AuthStateListener it2 = it = (AuthStateListener)element$iv;
                    it2.onNamedLogin(this.$successEvent$inlined);
                }
            }
        });
    }

    private final LoginSuccessEvent addThirdPartyInfo(LoginSuccessEvent info) {
        LoginSuccessEvent loginSuccessEvent;
        if (info.getThirdPartyInfo() != null) {
            loginSuccessEvent = info;
        } else {
            ThirdPartyInfo thirdParty = ThirdPartyInfo.Companion.fromJson(this.state.getThirdPartyInfo());
            if (thirdParty != null && Intrinsics.areEqual((Object)thirdParty.getYyUid(), (Object)String.valueOf(info.getSelfInfo().getUid()))) {
                loginSuccessEvent = new LoginSuccessEvent(info.getSelfInfo(), info.isNewUser(), info.getCredit(), thirdParty);
            } else {
                this.state.setThirdPartyInfo("");
                loginSuccessEvent = info;
            }
        }
        return loginSuccessEvent;
    }

    @MainThread
    public final void onCrossProcessLogin(long uid) {
        this.state.moveToState(new CrossProcessLoginState(uid));
        Logger.INSTANCE.info(this.TAG, "\u5728\u522b\u7684\u8fdb\u7a0b\u767b\u5f55\u6210\u529f: " + uid);
        LoginSuccessEvent info = new LoginSuccessEvent(new SelfInfo(uid, null, null, null, null, null, null, null, null, 510, null), false, "", null, 8, null);
        GlobalLoginAnnouncer this_$iv = this;
        this_$iv.scheduler.scheduleDirect(new Runnable(this_$iv, info){
            final /* synthetic */ GlobalLoginAnnouncer this$0;
            final /* synthetic */ LoginSuccessEvent $info$inlined;
            {
                this.this$0 = globalLoginAnnouncer;
                this.$info$inlined = loginSuccessEvent;
            }

            public final void run() {
                Iterable $receiver$iv = GlobalLoginAnnouncer.access$getListeners$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    AuthStateListener it;
                    AuthStateListener it2 = it = (AuthStateListener)element$iv;
                    it2.onNamedLogin(this.$info$inlined);
                }
            }
        });
    }

    @Override
    @MainThread
    public void onKickOff(@NotNull KickOffCode code, @NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        this.state.moveToState(new LogoutState());
        Logger.INSTANCE.info(this.TAG, "\u88ab\u8e22\u4e0b\u7ebf: " + reason);
        GlobalLoginAnnouncer this_$iv = this;
        this_$iv.scheduler.scheduleDirect(new Runnable(this_$iv, code, reason){
            final /* synthetic */ GlobalLoginAnnouncer this$0;
            final /* synthetic */ KickOffCode $code$inlined;
            final /* synthetic */ String $reason$inlined;
            {
                this.this$0 = globalLoginAnnouncer;
                this.$code$inlined = kickOffCode;
                this.$reason$inlined = string;
            }

            public final void run() {
                Iterable $receiver$iv = GlobalLoginAnnouncer.access$getListeners$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    AuthStateListener it;
                    AuthStateListener it2 = it = (AuthStateListener)element$iv;
                    it2.onKickOff(this.$code$inlined, this.$reason$inlined);
                }
            }
        });
    }

    @Override
    @MainThread
    public void onLogout() {
        this.state.moveToState(new LogoutState());
        Logger.INSTANCE.info(this.TAG, "\u9000\u51fa\u767b\u5f55\u6210\u529f");
        GlobalLoginAnnouncer this_$iv = this;
        this_$iv.scheduler.scheduleDirect(new Runnable(this_$iv){
            final /* synthetic */ GlobalLoginAnnouncer this$0;
            {
                this.this$0 = globalLoginAnnouncer;
            }

            public final void run() {
                Iterable $receiver$iv = GlobalLoginAnnouncer.access$getListeners$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    AuthStateListener it;
                    AuthStateListener it2 = it = (AuthStateListener)element$iv;
                    it2.onLogout();
                }
            }
        });
    }

    @Override
    @MainThread
    public void onLoginInterrupt(@NotNull LoginException error) {
        Intrinsics.checkParameterIsNotNull((Object)error, (String)"error");
        this.state.moveToState(new InterruptState(error));
        Logger.INSTANCE.error(this.TAG, "\u767b\u5f55\u65ad\u5f00: " + error.getMessage());
        GlobalLoginAnnouncer this_$iv = this;
        this_$iv.scheduler.scheduleDirect(new Runnable(this_$iv, error){
            final /* synthetic */ GlobalLoginAnnouncer this$0;
            final /* synthetic */ LoginException $error$inlined;
            {
                this.this$0 = globalLoginAnnouncer;
                this.$error$inlined = loginException;
            }

            public final void run() {
                Iterable $receiver$iv = GlobalLoginAnnouncer.access$getListeners$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    AuthStateListener it;
                    AuthStateListener it2 = it = (AuthStateListener)element$iv;
                    it2.onLoginInterrupt(this.$error$inlined);
                }
            }
        });
    }

    private final void notify(Function1<? super AuthStateListener, Unit> doSomething) {
        this.scheduler.scheduleDirect(new Runnable(this, doSomething){
            final /* synthetic */ GlobalLoginAnnouncer this$0;
            final /* synthetic */ Function1 $doSomething;

            public final void run() {
                Iterable $receiver$iv = GlobalLoginAnnouncer.access$getListeners$p(this.this$0);
                for (T element$iv : $receiver$iv) {
                    AuthStateListener it = (AuthStateListener)element$iv;
                    this.$doSomething.invoke((Object)it);
                }
            }
            {
                this.this$0 = globalLoginAnnouncer;
                this.$doSomething = function1;
            }
        });
    }

    public GlobalLoginAnnouncer(@NotNull String TAG, @NotNull LoginStateVisitor state, @NotNull List<? extends AuthStateListener> listeners) {
        Intrinsics.checkParameterIsNotNull((Object)TAG, (String)"TAG");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull(listeners, (String)"listeners");
        this.TAG = TAG;
        this.state = state;
        this.listeners = listeners;
        this.scheduler = AndroidSchedulers.mainThread();
    }

    @NotNull
    public static final /* synthetic */ List access$getListeners$p(GlobalLoginAnnouncer $this) {
        return $this.listeners;
    }
}

