/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdOptionsView;
import com.facebook.ads.AdSettings;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeBannerAd;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.mobileads.CustomEventAdView;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import java.util.ArrayList;
import java.util.Map;

public class FacebookNativeBanner
extends CustomEventAdView {
    private String _pid;
    private CustomEventAdView.CustomEventAdViewListener _customEvnetAdViewListener;
    private NativeBannerAd mNativeBannerAd;
    private Context mCxt;
    private String TAG = "FacebookNativeBanner";
    private String _layoutName;
    private Integer mWidth;
    private Integer mHeight;
    NativeAdListener nativeAdListener = new NativeAdListener(){

        public void onMediaDownloaded(Ad ad) {
            Log.i((String)FacebookNativeBanner.this.TAG, (String)"onMediaDownloaded: ");
        }

        public void onError(Ad ad, AdError adError) {
            Log.i((String)FacebookNativeBanner.this.TAG, (String)("onError: " + adError.getErrorMessage() + ":errorCode:" + adError.getErrorCode()));
            if (FacebookNativeBanner.this._customEvnetAdViewListener != null) {
                FacebookNativeBanner.this._customEvnetAdViewListener.onAdViewFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
            }
        }

        public void onAdLoaded(Ad ad) {
            Log.i((String)FacebookNativeBanner.this.TAG, (String)"onAdLoaded: ");
            if (FacebookNativeBanner.this.mNativeBannerAd == null || FacebookNativeBanner.this.mNativeBannerAd != ad) {
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)FacebookNativeBanner.this._layoutName)) {
                LinearLayout view = FacebookNativeBanner.this.inflateAd(FacebookNativeBanner.this.mNativeBannerAd);
                if (FacebookNativeBanner.this._customEvnetAdViewListener != null) {
                    FacebookNativeBanner.this._customEvnetAdViewListener.onAdViewLoaded((View)view);
                }
            } else if (FacebookNativeBanner.this._customEvnetAdViewListener != null) {
                FacebookNativeBanner.this._customEvnetAdViewListener.onAdViewLoaded(new View(FacebookNativeBanner.this.mCxt));
            }
            if (FacebookNativeBanner.this._customEvnetAdViewListener != null) {
                FacebookNativeBanner.this._customEvnetAdViewListener.onAdsSourceLoaded((Object)FacebookNativeBanner.this.mNativeBannerAd);
            }
        }

        public void onAdClicked(Ad ad) {
            Log.i((String)FacebookNativeBanner.this.TAG, (String)"onAdClicked: ");
            if (FacebookNativeBanner.this._customEvnetAdViewListener != null) {
                FacebookNativeBanner.this._customEvnetAdViewListener.onAdViewClicked();
            }
        }

        public void onLoggingImpression(Ad ad) {
            Log.i((String)FacebookNativeBanner.this.TAG, (String)"onLoggingImpression: ");
            if (FacebookNativeBanner.this._customEvnetAdViewListener != null) {
                FacebookNativeBanner.this._customEvnetAdViewListener.onAdViewExpanded();
            }
        }
    };

    protected void loadAdView(Context context, CustomEventAdView.CustomEventAdViewListener customEventBannerListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        Log.i((String)this.TAG, (String)"loadAdView: ");
        this.mCxt = context;
        if (serverExtras != null && serverExtras.size() > 0 && serverExtras.containsKey("placementId")) {
            this._pid = serverExtras.get("placementId");
        }
        if (localExtras != null && localExtras.size() > 0) {
            this._layoutName = (String)localExtras.get("com_ad_layout_banner_name");
            this.mWidth = (Integer)localExtras.get("com_tp_ad_width");
            this.mHeight = (Integer)localExtras.get("com_tp_ad_height");
        }
        if (this.mWidth <= 0 && this.mHeight <= 0) {
            this.mWidth = 320;
            this.mHeight = 50;
        }
        this._customEvnetAdViewListener = customEventBannerListener;
        if (localExtras.size() > 0) {
            boolean coppa;
            Log.i((String)"FacebookNativeBanner", (String)("suportGDPR ccpa: " + localExtras.get("CCPA") + ":COPPA:" + localExtras.get("COPPA")));
            if (localExtras.containsKey("CCPA")) {
                boolean cppa = (Boolean)localExtras.get("CCPA");
                if (cppa) {
                    AdSettings.setDataProcessingOptions((String[])new String[0]);
                } else {
                    AdSettings.setDataProcessingOptions((String[])new String[]{"LDU"}, (int)1, (int)1000);
                }
            }
            if (localExtras.containsKey("COPPA") && (coppa = ((Boolean)localExtras.get("COPPA")).booleanValue())) {
                this._customEvnetAdViewListener.onAdViewFailed(TradPlusErrorCode.NETWORK_NO_FILL);
                return;
            }
        }
        FacebookInitializeHelper.initialize(context);
        AdSettings.setTestMode((boolean)TestDeviceUtil.getInstance().isNeedTestDevice());
        this.mNativeBannerAd = new NativeBannerAd(context, this._pid);
        this.mNativeBannerAd.loadAd(this.mNativeBannerAd.buildLoadAdConfig().withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withAdListener(this.nativeAdListener).build());
    }

    private LinearLayout inflateAd(NativeBannerAd nativeBannerAd) {
        Log.d((String)this.TAG, (String)("inflateAd nativeBannerAd: " + nativeBannerAd.getAdvertiserName() + ":title:" + nativeBannerAd.getAdSocialContext() + "::" + nativeBannerAd.getAdCallToAction() + ";;;;" + nativeBannerAd.getSponsoredTranslation()));
        nativeBannerAd.unregisterView();
        Log.i((String)this.TAG, (String)("inflateAd _layoutName: " + this._layoutName));
        int layoutId = this.mCxt.getResources().getIdentifier(this._layoutName, "layout", this.mCxt.getPackageName());
        LinearLayout adView = (LinearLayout)LayoutInflater.from((Context)this.mCxt).inflate(layoutId, null, false);
        float density = this.mCxt.getResources().getDisplayMetrics().density;
        int v = (int)((float)this.mWidth.intValue() * density + 0.5f);
        adView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(v, -2));
        int native_ad_title = this.mCxt.getResources().getIdentifier("native_ad_title", "id", this.mCxt.getPackageName());
        int native_ad_social_context = this.mCxt.getResources().getIdentifier("native_ad_social_context", "id", this.mCxt.getPackageName());
        int native_ad_sponsored_label = this.mCxt.getResources().getIdentifier("native_ad_sponsored_label", "id", this.mCxt.getPackageName());
        int native_ad_call_to_action = this.mCxt.getResources().getIdentifier("native_ad_call_to_action", "id", this.mCxt.getPackageName());
        TextView nativeAdTitle = (TextView)adView.findViewById(native_ad_title);
        TextView nativeAdSocialContext = (TextView)adView.findViewById(native_ad_social_context);
        TextView sponsoredLabel = (TextView)adView.findViewById(native_ad_sponsored_label);
        Button nativeAdCallToAction = (Button)adView.findViewById(native_ad_call_to_action);
        nativeAdCallToAction.setVisibility(nativeBannerAd.hasCallToAction() ? 0 : 4);
        nativeAdCallToAction.setText((CharSequence)nativeBannerAd.getAdCallToAction());
        nativeAdTitle.setText((CharSequence)nativeBannerAd.getAdvertiserName());
        Log.i((String)this.TAG, (String)("inflateAd nativeAdTitle: " + nativeAdTitle.getText().toString()));
        nativeAdSocialContext.setText((CharSequence)nativeBannerAd.getAdSocialContext());
        int native_icon_view = this.mCxt.getResources().getIdentifier("native_icon_view", "id", this.mCxt.getPackageName());
        int image_view_icon_view = this.mCxt.getResources().getIdentifier("image_view_icon_view", "id", this.mCxt.getPackageName());
        int ad_choices_container = this.mCxt.getResources().getIdentifier("ad_choices_container", "id", this.mCxt.getPackageName());
        MediaView nativeAdIconView = (MediaView)adView.findViewById(native_icon_view);
        nativeAdIconView.setVisibility(0);
        ImageView nativeImageViewAdIconView = (ImageView)adView.findViewById(image_view_icon_view);
        FrameLayout adChoicesContainer = (FrameLayout)adView.findViewById(ad_choices_container);
        AdOptionsView adOptionsView = new AdOptionsView(this.mCxt, (NativeAdBase)this.mNativeBannerAd, null, AdOptionsView.Orientation.HORIZONTAL, 20);
        adChoicesContainer.removeAllViews();
        adChoicesContainer.addView((View)adOptionsView);
        sponsoredLabel.setText((CharSequence)nativeBannerAd.getSponsoredTranslation());
        ArrayList<Object> clickableViews = new ArrayList<Object>();
        clickableViews.add(nativeAdTitle);
        clickableViews.add(nativeAdCallToAction);
        nativeBannerAd.registerViewForInteraction((View)adView, nativeAdIconView, clickableViews);
        return adView;
    }

    protected void onInvalidate() {
        Log.i((String)this.TAG, (String)"onInvalidate: ");
        if (this.mNativeBannerAd != null) {
            this.mNativeBannerAd.unregisterView();
            this.mNativeBannerAd = null;
        }
    }
}

