/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.MediaView;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.tradplus.ads.common.util.Views;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.mobileads.CustomEventAdView;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;

public class FacebookNativeAdvanced
extends CustomEventAdView {
    private NativeAd mFacebookNative;
    private CustomEventAdView.CustomEventAdViewListener mNativeListener;
    private WeakReference<Context> mContextWeakReference;
    private long mAdLoadTimeStamp;
    private String mAdUnitId;
    private String mAdLayoutName;
    private String mParams;
    private RelativeLayout mNativeAdView;
    private int mAdWidth;
    private int mAdHeight;
    private float density;
    private boolean onlyCtaBtnAvailable;

    protected void loadAdView(Context context, CustomEventAdView.CustomEventAdViewListener customEventNativeListener, Map<String, Object> localExtras, Map<String, String> serverExtras) {
        this.mNativeListener = customEventNativeListener;
        this.mContextWeakReference = new WeakReference<Context>(context);
        if (!this.serverExtrasAreValid(serverExtras)) {
            this.mNativeListener.onAdViewFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        String placementId = serverExtras.get("placementId");
        if (localExtras.size() > 0) {
            boolean coppa;
            Log.i((String)"FacebookNative", (String)("suportGDPR ccpa: " + localExtras.get("CCPA") + ":COPPA:" + localExtras.get("COPPA")));
            if (localExtras.containsKey("CCPA")) {
                boolean cppa = (Boolean)localExtras.get("CCPA");
                if (cppa) {
                    AdSettings.setDataProcessingOptions((String[])new String[0]);
                } else {
                    AdSettings.setDataProcessingOptions((String[])new String[]{"LDU"}, (int)1, (int)1000);
                }
            }
            if (localExtras.containsKey("COPPA") && (coppa = ((Boolean)localExtras.get("COPPA")).booleanValue())) {
                this.mNativeListener.onAdViewFailed(TradPlusErrorCode.NETWORK_NO_FILL);
                return;
            }
        }
        FacebookInitializeHelper.initialize(context);
        this.mAdUnitId = (String)localExtras.get("com_tp_ad_unit_id");
        this.mAdLayoutName = (String)localExtras.get("com_tp_ad_layout_name");
        this.mParams = serverExtras.toString();
        this.mAdLoadTimeStamp = System.currentTimeMillis();
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)context.getApplicationContext().getSystemService("window");
        windowManager.getDefaultDisplay().getMetrics(dm);
        this.density = context.getResources().getDisplayMetrics().density;
        if (!this.localExtrasAreValid(localExtras)) {
            this.mNativeListener.onAdViewFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        this.mAdWidth = (Integer)localExtras.get("com_tp_ad_width");
        this.mAdHeight = (Integer)localExtras.get("com_tp_ad_height");
        if (this.mAdLayoutName == null || this.mAdLayoutName.length() <= 0) {
            this.mNativeListener.onAdViewFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        int layoutId = context.getResources().getIdentifier(this.mAdLayoutName, "layout", context.getPackageName());
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mNativeAdView = (RelativeLayout)inflater.inflate(layoutId, null);
        AdSettings.setTestMode((boolean)TestDeviceUtil.getInstance().isNeedTestDevice());
        this.mFacebookNative = new NativeAd(context, placementId);
        NativeAdListener nativeAdListener = new NativeAdListener(){

            public void onError(Ad ad, AdError adError) {
                Log.d((String)"TradPlus", (String)("Facebook Native ad load failed\uff0cerror  ,ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                if (FacebookNativeAdvanced.this.mNativeListener != null) {
                    FacebookNativeAdvanced.this.mNativeListener.onAdViewFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                }
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)"TradPlus", (String)"Facebook native ad loaded successfully. Showing ad...");
                if (FacebookNativeAdvanced.this.mFacebookNative != null) {
                    Context ct;
                    FacebookNativeAdvanced.this.mFacebookNative.unregisterView();
                    if (!TextUtils.isEmpty((CharSequence)FacebookNativeAdvanced.this.mAdLayoutName)) {
                        FacebookNativeAdvanced.this.setFaceBookAdContent(FacebookNativeAdvanced.this.mFacebookNative);
                        FacebookNativeAdvanced.this.mNativeListener.onAdViewLoaded((View)FacebookNativeAdvanced.this.mNativeAdView);
                    } else if (FacebookNativeAdvanced.this.mNativeListener != null && (ct = (Context)FacebookNativeAdvanced.this.mContextWeakReference.get()) != null) {
                        FacebookNativeAdvanced.this.mNativeListener.onAdViewLoaded(new View(ct));
                    }
                    FacebookNativeAdvanced.this.mNativeListener.onAdsSourceLoaded((Object)FacebookNativeAdvanced.this.mFacebookNative);
                } else {
                    FacebookNativeAdvanced.this.mNativeListener.onAdViewFailed(TradPlusErrorCode.UNSPECIFIED);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)"TradPlus", (String)"Facebook native ad clicked.");
                if (FacebookNativeAdvanced.this.mNativeListener != null) {
                    FacebookNativeAdvanced.this.mNativeListener.onAdViewClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
                Log.d((String)"TradPlus", (String)"Facebook native ad onLoggingImpression.");
                if (FacebookNativeAdvanced.this.mNativeListener != null) {
                    FacebookNativeAdvanced.this.mNativeListener.onAdViewExpanded();
                }
            }

            public void onMediaDownloaded(Ad ad) {
            }
        };
        this.mFacebookNative.loadAd(this.mFacebookNative.buildLoadAdConfig().withAdListener(nativeAdListener).build());
    }

    protected void onInvalidate() {
        AdSettings.clearTestDevices();
        if (this.mNativeAdView != null) {
            this.mNativeAdView.removeAllViews();
            Views.removeFromParent((View)this.mNativeAdView);
            this.mNativeAdView = null;
        }
        if (this.mFacebookNative != null) {
            this.mFacebookNative.unregisterView();
            this.mFacebookNative.destroy();
            this.mFacebookNative = null;
        }
    }

    private boolean serverExtrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    private void setFaceBookAdContent(NativeAd nativeAd) {
        if (this.mContextWeakReference.get() == null) {
            return;
        }
        Context context = (Context)this.mContextWeakReference.get();
        int native_title_id = context.getResources().getIdentifier("native_title", "id", context.getPackageName());
        TextView nativeAdTitle = (TextView)this.mNativeAdView.findViewById(native_title_id);
        int native_text_id = context.getResources().getIdentifier("native_text", "id", context.getPackageName());
        TextView nativeAdBody = (TextView)this.mNativeAdView.findViewById(native_text_id);
        int native_cta_btn_id = context.getResources().getIdentifier("native_cta_btn", "id", context.getPackageName());
        Button nativeAdCallToAction = (Button)this.mNativeAdView.findViewById(native_cta_btn_id);
        int native_cta_text_id = context.getResources().getIdentifier("native_cta_text", "id", context.getPackageName());
        TextView nativeAdSocialContext = (TextView)this.mNativeAdView.findViewById(native_cta_text_id);
        int native_icon_image_id = context.getResources().getIdentifier("native_icon_image", "id", context.getPackageName());
        ImageView nativeAdIcon = (ImageView)this.mNativeAdView.findViewById(native_icon_image_id);
        int native_main_image_id = context.getResources().getIdentifier("native_main_image", "id", context.getPackageName());
        RelativeLayout nativeAdImage = (RelativeLayout)this.mNativeAdView.findViewById(native_main_image_id);
        MediaView nativeAdMedia = new MediaView(context);
        RelativeLayout.LayoutParams media_lp = new RelativeLayout.LayoutParams(-1, -1);
        nativeAdImage.addView((View)nativeAdMedia, (ViewGroup.LayoutParams)media_lp);
        nativeAdCallToAction.setText((CharSequence)nativeAd.getAdCallToAction());
        nativeAdSocialContext.setText((CharSequence)nativeAd.getAdCallToAction());
        nativeAdSocialContext.setVisibility(nativeAd.hasCallToAction() ? 0 : 4);
        nativeAdTitle.setText((CharSequence)nativeAd.getAdvertiserName());
        nativeAdBody.setText((CharSequence)nativeAd.getAdBodyText());
        NativeAdBase.Image adIcon = nativeAd.getAdIcon();
        ArrayList<Object> clickableViews = new ArrayList<Object>();
        clickableViews.add(nativeAdIcon);
        clickableViews.add(nativeAdMedia);
        clickableViews.add(nativeAdCallToAction);
        nativeAd.registerViewForInteraction((View)this.mNativeAdView, nativeAdMedia, nativeAdIcon, clickableViews);
    }

    private boolean localExtrasAreValid(Map<String, Object> localExtras) {
        return localExtras.get("com_tp_ad_width") instanceof Integer && localExtras.get("com_tp_ad_height") instanceof Integer;
    }
}

