/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.facebook;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdSettings;
import com.facebook.ads.BidderTokenProvider;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeBannerAd;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.nativead.TPNativeAdapter;
import com.tradplus.ads.base.bean.TPBaseAd;
import com.tradplus.ads.facebook.FacebookErrorUtil;
import com.tradplus.ads.facebook.FacebookInitializeHelper;
import com.tradplus.ads.facebook.FacebookNativeAd;
import com.tradplus.ads.mobileads.TradPlusErrorCode;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.lang.ref.WeakReference;
import java.util.Map;

public class FacebookNative
extends TPNativeAdapter {
    private NativeAd mFacebookNative;
    private FacebookNativeAd mFacebookNativeAd;
    private WeakReference<Context> mContextWeakReference;
    private String payload;
    private String mAdSize;
    private static final String TAG = "FacebookNative";

    public void loadCustomAd(Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        String placementId;
        this.mContextWeakReference = new WeakReference<Context>(context);
        if (this.serverExtrasAreValid(tpParams)) {
            placementId = tpParams.get("placementId");
            Log.d((String)"TradPlus Native size", (String)("adsize == " + tpParams.get("ad_size" + placementId)));
            this.mAdSize = tpParams.get("ad_size" + placementId) != null && !tpParams.get("ad_size" + placementId).equals("0") ? tpParams.get("ad_size" + placementId) : "1";
        } else {
            this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.ADAPTER_CONFIGURATION_ERROR);
            return;
        }
        this.payload = tpParams.get("Bidding-Payload");
        if (userParams.size() > 0) {
            boolean coppa;
            Log.i((String)TAG, (String)("suportGDPR ccpa: " + userParams.get("CCPA") + ":COPPA:" + userParams.get("COPPA")));
            if (userParams.containsKey("CCPA")) {
                boolean cppa = (Boolean)userParams.get("CCPA");
                if (cppa) {
                    AdSettings.setDataProcessingOptions((String[])new String[0]);
                } else {
                    AdSettings.setDataProcessingOptions((String[])new String[]{"LDU"}, (int)1, (int)1000);
                }
            }
            if (userParams.containsKey("COPPA") && (coppa = ((Boolean)userParams.get("COPPA")).booleanValue())) {
                this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.NETWORK_NO_FILL);
                return;
            }
        }
        FacebookInitializeHelper.initialize(context);
        AdSettings.setTestMode((boolean)TestDeviceUtil.getInstance().isNeedTestDevice());
        String secType = tpParams.get("sec_ad_type");
        if (secType == null || !secType.equals("2")) {
            this.loadNativeAd(context, placementId);
        } else {
            this.loadNativeBannerAd(context, placementId);
        }
    }

    private void loadNativeBannerAd(final Context context, String placementId) {
        final NativeBannerAd mNativeBannerAd = new NativeBannerAd(context, placementId);
        mNativeBannerAd.loadAd(mNativeBannerAd.buildLoadAdConfig().withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withAdListener(new NativeAdListener(){

            public void onMediaDownloaded(Ad ad) {
            }

            public void onError(Ad ad, AdError adError) {
                Log.d((String)FacebookNative.TAG, (String)("Facebook Native banner ad load failed\uff0cerror  ,ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                if (FacebookNative.this.mLoadAdapterListener != null) {
                    FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                }
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)FacebookNative.TAG, (String)"Facebook native banner ad loaded successfully. Showing ad...");
                if (mNativeBannerAd != null && FacebookNative.this.mContextWeakReference.get() != null) {
                    mNativeBannerAd.unregisterView();
                    FacebookNative.this.mFacebookNativeAd = new FacebookNativeAd(context, mNativeBannerAd, FacebookNative.this.mAdSize);
                    if (FacebookNative.this.mLoadAdapterListener != null) {
                        FacebookNative.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)FacebookNative.this.mFacebookNativeAd);
                    }
                } else if (FacebookNative.this.mLoadAdapterListener != null) {
                    FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.UNSPECIFIED);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)FacebookNative.TAG, (String)"Facebook native banner ad clicked.");
                if (FacebookNative.this.mFacebookNativeAd != null) {
                    FacebookNative.this.mFacebookNativeAd.onAdViewClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
                Log.d((String)FacebookNative.TAG, (String)"Facebook native banner ad onLoggingImpression.");
                if (FacebookNative.this.mFacebookNativeAd != null) {
                    FacebookNative.this.mFacebookNativeAd.onAdViewExpanded();
                }
            }
        }).build());
    }

    private void loadNativeAd(Context context, String placementId) {
        this.mFacebookNative = new NativeAd(context, placementId);
        NativeAdListener nativeAdListener = new NativeAdListener(){

            public void onError(Ad ad, AdError adError) {
                Log.d((String)FacebookNative.TAG, (String)("Facebook Native ad load failed\uff0cerror  ,ErrorCode : " + adError.getErrorCode() + ", ErrorMessage : " + adError.getErrorMessage()));
                if (FacebookNative.this.mLoadAdapterListener != null) {
                    FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(FacebookErrorUtil.getTradPlusErrorCode(adError));
                }
            }

            public void onAdLoaded(Ad ad) {
                Log.d((String)FacebookNative.TAG, (String)"Facebook native ad loaded successfully. Showing ad...");
                if (FacebookNative.this.mFacebookNative != null && FacebookNative.this.mContextWeakReference.get() != null) {
                    FacebookNative.this.mFacebookNative.unregisterView();
                    FacebookNative.this.mFacebookNativeAd = new FacebookNativeAd((Context)FacebookNative.this.mContextWeakReference.get(), FacebookNative.this.mFacebookNative);
                    if (FacebookNative.this.mLoadAdapterListener != null) {
                        FacebookNative.this.mLoadAdapterListener.loadAdapterLoaded((TPBaseAd)FacebookNative.this.mFacebookNativeAd);
                    }
                } else if (FacebookNative.this.mLoadAdapterListener != null) {
                    FacebookNative.this.mLoadAdapterListener.loadAdapterLoadFailed(TradPlusErrorCode.UNSPECIFIED);
                }
            }

            public void onAdClicked(Ad ad) {
                Log.d((String)FacebookNative.TAG, (String)"Facebook native ad clicked.");
                if (FacebookNative.this.mFacebookNativeAd != null) {
                    FacebookNative.this.mFacebookNativeAd.onAdViewClicked();
                }
            }

            public void onLoggingImpression(Ad ad) {
                Log.d((String)FacebookNative.TAG, (String)"Facebook native ad onLoggingImpression.");
                if (FacebookNative.this.mFacebookNativeAd != null) {
                    FacebookNative.this.mFacebookNativeAd.onAdViewExpanded();
                }
            }

            public void onMediaDownloaded(Ad ad) {
            }
        };
        this.mFacebookNative.loadAd(this.mFacebookNative.buildLoadAdConfig().withBid(TextUtils.isEmpty((CharSequence)this.payload) ? "" : this.payload).withAdListener(nativeAdListener).build());
    }

    public void clean() {
        AdSettings.clearTestDevices();
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("1");
    }

    public String getNetworkVersion() {
        return "6.4.0";
    }

    private boolean serverExtrasAreValid(Map<String, String> serverExtras) {
        String placementId = serverExtras.get("placementId");
        return placementId != null && placementId.length() > 0;
    }

    public String getBiddingToken() {
        try {
            return BidderTokenProvider.getBidderToken((Context)GlobalTradPlus.getInstance().getContext());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

