/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.applovin.carouselui.adapter;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.applovin.adview.AppLovinInterstitialAd;
import com.applovin.adview.AppLovinInterstitialAdDialog;
import com.applovin.sdk.AppLovinAd;
import com.applovin.sdk.AppLovinAdClickListener;
import com.applovin.sdk.AppLovinAdDisplayListener;
import com.applovin.sdk.AppLovinAdLoadListener;
import com.applovin.sdk.AppLovinAdVideoPlaybackListener;
import com.applovin.sdk.AppLovinSdk;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinErrorUtil;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinInitManager;
import com.tradplus.ads.applovin.carouselui.adapter.AppLovinInterstitialCallbackRouter;
import com.tradplus.ads.base.adapter.TPInitMediation;
import com.tradplus.ads.base.adapter.interstitial.TPInterstitialAdapter;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.pushcenter.utils.RequestUtils;
import java.util.Map;

public class AppLovinInterstitial
extends TPInterstitialAdapter
implements AppLovinAdLoadListener,
AppLovinAdDisplayListener,
AppLovinAdClickListener,
AppLovinAdVideoPlaybackListener {
    public static final String TAG = "AppLovinInterstitial";
    private AppLovinSdk mAppLovinSdk;
    private AppLovinAd mAppLovinAd;
    private AppLovinInterstitialAdDialog mAppLovinInterstitialAdDialog;
    private String zoneId;
    private String payload;
    private AppLovinInterstitialCallbackRouter mAppLovinICBR;

    public void loadCustomAd(final Context context, Map<String, Object> userParams, Map<String, String> tpParams) {
        if (this.mLoadAdapterListener == null) {
            return;
        }
        if (!this.extrasAreValid(tpParams)) {
            this.mLoadAdapterListener.loadAdapterLoadFailed(new TPError("Native Network or Custom Event adapter was configured incorrectly."));
            return;
        }
        this.zoneId = tpParams.get("placementId");
        this.payload = (String)userParams.get("Bidding-Payload");
        this.mAppLovinICBR = AppLovinInterstitialCallbackRouter.getInstance();
        this.mAppLovinICBR.addListener(this.zoneId, this.mLoadAdapterListener);
        AppLovinInitManager.getInstance().initSDK(context, userParams, tpParams, new TPInitMediation.InitCallback(){

            public void onSuccess() {
                AppLovinInterstitial.this.mAppLovinSdk = AppLovinInitManager.getInstance().getAppLovinSdk();
                AppLovinInterstitial.this.loadWithSdkInitialized(context);
            }

            public void onFailed(String code, String msg) {
            }
        });
    }

    protected void loadWithSdkInitialized(Context context) {
        this.mAppLovinInterstitialAdDialog = AppLovinInterstitialAd.create((AppLovinSdk)this.mAppLovinSdk, (Context)context);
        this.mAppLovinInterstitialAdDialog.setAdDisplayListener((AppLovinAdDisplayListener)this);
        this.mAppLovinInterstitialAdDialog.setAdClickListener((AppLovinAdClickListener)this);
        this.mAppLovinInterstitialAdDialog.setAdVideoPlaybackListener((AppLovinAdVideoPlaybackListener)this);
        if (TextUtils.isEmpty((CharSequence)this.payload)) {
            this.mAppLovinSdk.getAdService().loadNextAdForZoneId(this.zoneId, (AppLovinAdLoadListener)this);
        } else {
            this.mAppLovinSdk.getAdService().loadNextAdForAdToken(this.payload, (AppLovinAdLoadListener)this);
        }
    }

    public void showAd() {
        if (this.mShowListener != null) {
            this.mAppLovinICBR.addShowListener(this.zoneId, this.mShowListener);
        }
        if (this.mAppLovinAd != null && this.mAppLovinInterstitialAdDialog != null) {
            this.mAppLovinInterstitialAdDialog.showAndRender(this.mAppLovinAd);
        } else if (this.zoneId != null && this.zoneId.length() > 0 && this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoError(new TPError("Didn't find valid adv.Show Failed"));
        }
    }

    public boolean isReady() {
        return !this.isAdsTimeOut();
    }

    public void clean() {
        super.clean();
        if (this.mAppLovinInterstitialAdDialog != null) {
            this.mAppLovinInterstitialAdDialog.setAdDisplayListener(null);
            this.mAppLovinInterstitialAdDialog.setAdClickListener(null);
            this.mAppLovinInterstitialAdDialog.setAdVideoPlaybackListener(null);
            this.mAppLovinInterstitialAdDialog = null;
        }
        if (this.zoneId != null) {
            this.mAppLovinICBR.removeListeners(this.zoneId);
        }
    }

    public String getNetworkName() {
        return RequestUtils.getInstance().getCustomAs("9");
    }

    public String getNetworkVersion() {
        return AppLovinSdk.VERSION;
    }

    private boolean extrasAreValid(Map<String, String> serverExtras) {
        return serverExtras.containsKey("placementId");
    }

    public void adReceived(AppLovinAd appLovinAd) {
        if (this.mAppLovinInterstitialAdDialog == null) {
            return;
        }
        Log.i((String)TAG, (String)("adReceived:ZoneId:" + appLovinAd.getZoneId()));
        this.mAppLovinAd = appLovinAd;
        if (this.mAppLovinICBR.getListener(appLovinAd.getZoneId()) != null) {
            this.mAppLovinICBR.getListener(appLovinAd.getZoneId()).loadAdapterLoaded(null);
        }
    }

    public void failedToReceiveAd(int errorCode) {
        Log.i((String)TAG, (String)("failedToReceiveAd: AppLovin interstitial ad failed to load with error code " + errorCode));
        if (this.mAppLovinICBR.getListener(this.zoneId) != null) {
            this.mAppLovinICBR.getListener(this.zoneId).loadAdapterLoadFailed(AppLovinErrorUtil.getTradPlusErrorCode(errorCode));
        }
    }

    public void adDisplayed(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)("adDisplayed:ZoneId:" + appLovinAd.getZoneId()));
        if (this.mAppLovinICBR.getShowListener(appLovinAd.getZoneId()) != null) {
            this.mAppLovinICBR.getShowListener(appLovinAd.getZoneId()).onAdVideoStart();
        }
    }

    public void adHidden(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)("adHidden:ZoneId:" + appLovinAd.getZoneId()));
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoEnd();
        }
    }

    public void adClicked(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)("adClicked:ZoneId:" + appLovinAd.getZoneId()));
        if (this.mAppLovinICBR.getShowListener(this.zoneId) != null) {
            this.mAppLovinICBR.getShowListener(this.zoneId).onAdVideoClicked();
        }
    }

    public void videoPlaybackBegan(AppLovinAd appLovinAd) {
        Log.i((String)TAG, (String)"videoPlaybackBegan: ");
    }

    public void videoPlaybackEnded(AppLovinAd appLovinAd, double v, boolean b) {
        Log.i((String)TAG, (String)"videoPlaybackEnded: ");
    }
}

