/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.honor;

import android.util.Log;
import java.util.IllegalFormatException;
import java.util.Locale;
import java.util.regex.PatternSyntaxException;

public class HonorLogUtils {
    public static final int LOG_LEVEL = 6;
    public static final int ERROR = 1;
    public static final int WARN = 2;
    public static final int INFO = 3;
    public static final int DEBUG = 4;
    public static final int VERBOSE = 5;
    private static final String ERROR_MESSAGE = "log message error : ";

    private HonorLogUtils() {
    }

    public static void error(String tag, String msg) {
        Log.e((String)tag, (String)msg);
    }

    public static <T> void error(String tag, String msg, T ... args) {
        if (msg != null) {
            Log.e((String)tag, (String)HonorLogUtils.getMessageString(msg, args));
        }
    }

    public static void warn(String tag, String msg) {
        Log.w((String)tag, (String)msg);
    }

    public static void info(String tag, String msg) {
        Log.i((String)tag, (String)msg);
    }

    public static <T> void info(String tag, String msg, T ... args) {
        if (msg != null) {
            Log.i((String)tag, (String)HonorLogUtils.getMessageString(msg, args));
        }
    }

    public static void debug(String tag, String msg) {
        Log.d((String)tag, (String)msg);
    }

    public static <T> void debug(String tag, String msg, T ... args) {
        if (msg != null) {
            Log.d((String)tag, (String)HonorLogUtils.getMessageString(msg, args));
        }
    }

    public static void verbose(String tag, String msg) {
        Log.v((String)tag, (String)msg);
    }

    private static <T> String getMessageString(String msg, T[] args) {
        try {
            return String.format(Locale.ENGLISH, msg.replaceAll("\\{\\}", "%s"), (Object[])args);
        }
        catch (IllegalFormatException | PatternSyntaxException illegalArgumentException) {
            return ERROR_MESSAGE + illegalArgumentException.getMessage();
        }
    }
}

