/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.daisy;

import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyAudioFeaturesKit;
import com.tencent.trtc.hardwareearmonitor.daisy.DaisyAudioKaraokeFeatureKit;
import com.tencent.trtc.hardwareearmonitor.daisy.IDaisyAudioKitCallback;

public class DaisyFeatureKitManager {
    private static final String TAG = "DaisyAudioKit.DaisyFeatureKitManager";
    private static final Object SET_CALL_BACK_LOCK = new Object();
    private static final Object NEW_FEATUREMANAGER_LOCK = new Object();
    private static final Object BIND_SERVICE_LOCK = new Object();
    private static final Object UNBIND_SERVICE_LOCK = new Object();
    private static final String ENGINE_PACKAGE_NAME = "com.huawei.multimedia.audioengine";
    private static final int PACKAGE_INFO_FLAG = 0;
    private static DaisyFeatureKitManager sInstance = null;
    private IDaisyAudioKitCallback mCallBack = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DaisyFeatureKitManager getInstance() {
        Object object = NEW_FEATUREMANAGER_LOCK;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = new DaisyFeatureKitManager();
            }
            return sInstance;
        }
    }

    protected <T extends DaisyAudioFeaturesKit> T createFeatureKit(int type, Context context) {
        if (context == null) {
            return null;
        }
        switch (type) {
            case 1: {
                DaisyAudioKaraokeFeatureKit daisyAudioKaraokeFeatureKit = new DaisyAudioKaraokeFeatureKit(context);
                daisyAudioKaraokeFeatureKit.initialize(context);
                return (T)daisyAudioKaraokeFeatureKit;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void bindService(Context context, ServiceConnection connection, String classeName) {
        Object object = BIND_SERVICE_LOCK;
        synchronized (object) {
            if (context == null) {
                return;
            }
            Intent intent = new Intent();
            intent.setClassName(ENGINE_PACKAGE_NAME, classeName);
            try {
                context.bindService(intent, connection, 1);
            }
            catch (SecurityException securityException) {
                LiteavLog.e(TAG, "bindService, SecurityException, %s", securityException.getMessage());
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unbindService(Context context, ServiceConnection connectionService) {
        Object object = UNBIND_SERVICE_LOCK;
        synchronized (object) {
            if (context != null) {
                context.unbindService(connectionService);
            }
            return;
        }
    }

    public static boolean isAudioKitSupport(Context context) {
        if (context == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        try {
            if (packageManager != null && packageManager.getPackageInfo(ENGINE_PACKAGE_NAME, 0) == null) {
                return false;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            LiteavLog.e(TAG, "isAudioKitSupport ,NameNotFoundException");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onCallBack(int result) {
        Object object = SET_CALL_BACK_LOCK;
        synchronized (object) {
            if (this.getCallBack() != null) {
                this.getCallBack().onResult(result);
            }
            return;
        }
    }

    protected void setCallBack(IDaisyAudioKitCallback callBack) {
        this.mCallBack = callBack;
    }

    protected IDaisyAudioKitCallback getCallBack() {
        return this.mCallBack;
    }
}

