/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor;

import android.media.AudioTrack;
import com.tencent.liteav.base.annotations.JNINamespace;

@JNINamespace(value="liteav::extensions")
public class HardwareEarMonitorSilentTrack {
    private static final int DEFAULT_SAMPLE_RATE = 48000;
    private PlaybackThread mPlaybackThread;
    private int mChannelConfig = 12;
    private int mAudioFormat = 2;
    private boolean mIsPlaying = false;

    public static HardwareEarMonitorSilentTrack create() {
        return new HardwareEarMonitorSilentTrack();
    }

    public void StartAudioTrack() {
        if (!this.mIsPlaying && this.mPlaybackThread == null) {
            this.mIsPlaying = true;
            this.mPlaybackThread = new PlaybackThread();
            this.mPlaybackThread.start();
        }
    }

    public void StopAudioTrack() {
        if (this.mPlaybackThread != null) {
            this.mIsPlaying = false;
            this.mPlaybackThread.closeThread();
            try {
                this.mPlaybackThread.join();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.mPlaybackThread = null;
        }
    }

    public class PlaybackThread
    extends Thread {
        private boolean isStop = false;

        PlaybackThread() {
        }

        public synchronized void closeThread() {
            this.isStop = true;
        }

        @Override
        public void run() {
            int n2 = AudioTrack.getMinBufferSize((int)48000, (int)HardwareEarMonitorSilentTrack.this.mChannelConfig, (int)HardwareEarMonitorSilentTrack.this.mAudioFormat);
            AudioTrack audioTrack = new AudioTrack(3, 48000, HardwareEarMonitorSilentTrack.this.mChannelConfig, HardwareEarMonitorSilentTrack.this.mAudioFormat, n2, 1);
            if (audioTrack.getState() == 1) {
                audioTrack.play();
                byte[] byArray = new byte[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    byArray[i2] = 0;
                }
                while (!this.isStop && !this.isInterrupted()) {
                    try {
                        audioTrack.write(byArray, 0, n2);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                audioTrack.stop();
                audioTrack.flush();
            }
            audioTrack.release();
        }
    }
}

