/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;

@JNINamespace(value="liteav::video")
public class CameraAbilityProvider {
    public static int getCamera2SupportLevel() {
        int n2 = -1;
        CameraManager cameraManager = (CameraManager)ContextUtils.getApplicationContext().getSystemService("camera");
        try {
            String[] stringArray = cameraManager.getCameraIdList();
            if (stringArray.length > 0) {
                n2 = CameraAbilityProvider.getSystemHardwareLevel(cameraManager, stringArray);
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e("CameraAbilityProvider", "getCamera2SupportLevel exception:".concat(String.valueOf(throwable)));
        }
        return n2;
    }

    private static int getSystemHardwareLevel(CameraManager manager, String[] cameraIds) throws Throwable {
        int n2 = -1;
        String[] stringArray = cameraIds;
        int n3 = cameraIds.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = stringArray[i2];
            CameraCharacteristics cameraCharacteristics = manager.getCameraCharacteristics(string);
            Integer n4 = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
            if (n4 != null && n4 != 0 && n4 != 1) continue;
            Integer n5 = (Integer)cameraCharacteristics.get(CameraCharacteristics.INFO_SUPPORTED_HARDWARE_LEVEL);
            if (n5 == null) {
                n2 = -1;
                break;
            }
            n2 = n5;
        }
        return n2;
    }
}

