/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.videobase;

import android.view.TextureView;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.rtmp.ui.AndroidViewEventListener;
import com.tencent.rtmp.ui.TXCloudVideoView;
import java.lang.reflect.Method;

@JNINamespace(value="liteav::video")
public class TXCCloudVideoViewMethodInvoker {
    private static final String TAG = "TXCCloudVideoViewMethodInvoker";

    public static void setTouchToFocusEnabled(TXCloudVideoView view, boolean enable) {
        Class[] classArray = new Class[]{Boolean.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setTouchToFocusEnabled", classArray, enable);
    }

    public static void setZoomEnabled(TXCloudVideoView view, boolean enable) {
        Class[] classArray = new Class[]{Boolean.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setZoomEnabled", classArray, enable);
    }

    public static void setAndroidViewEventListener(TXCloudVideoView view, AndroidViewEventListener listener) {
        Class[] classArray = new Class[]{AndroidViewEventListener.class};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setAndroidViewEventListener", classArray, listener);
    }

    public static void setBackgroundColorForInternalView(TXCloudVideoView view, int color) {
        Class[] classArray = new Class[]{Integer.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "setBackgroundColorForInternalView", classArray, color);
    }

    public static void showFocusView(TXCloudVideoView view, int x, int y, int width, int height) {
        Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "showFocusView", classArray, x, y, width, height);
    }

    public static void addView(TXCloudVideoView view, TextureView textureView) {
        Class[] classArray = new Class[]{TextureView.class};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "addViewInternal", classArray, textureView);
    }

    public static void removeView(TXCloudVideoView view, TextureView textureView, boolean clearLastImage) {
        Class[] classArray = new Class[]{TextureView.class, Boolean.TYPE};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "removeViewInternal", classArray, textureView, clearLastImage);
    }

    public static void removeDeprecatedViews(TXCloudVideoView view, TextureView excludeView) {
        Class[] classArray = new Class[]{TextureView.class};
        TXCCloudVideoViewMethodInvoker.callMethod(view, "removeDeprecatedViews", classArray, excludeView);
    }

    public static TextureView getTextureViewSetByUser(TXCloudVideoView view) {
        Object object = TXCCloudVideoViewMethodInvoker.callMethod(view, "getTextureViewSetByUser", null, new Object[0]);
        if (object instanceof TextureView) {
            return (TextureView)object;
        }
        return null;
    }

    public static Object getGLContextFromView(DisplayTarget target) {
        if (target == null || target.getTXCloudVideoView() == null) {
            return null;
        }
        return target.getTXCloudVideoView().getOpenGLContext();
    }

    private static Object callMethod(TXCloudVideoView view, String name, Class<?>[] argsTypes, Object ... args) {
        if (view == null) {
            LiteavLog.w(TAG, name + ",TXCloudVideoView is null.");
            return null;
        }
        try {
            Method method = TXCloudVideoView.class.getDeclaredMethod(name, argsTypes);
            method.setAccessible(true);
            return method.invoke((Object)view, args);
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, name + ",Exception:", throwable);
            return null;
        }
    }
}

