/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.live;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Environment;
import android.text.TextUtils;
import android.view.Surface;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.live.a;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.rtmp.ITXLivePlayListener;
import com.tencent.rtmp.TXLivePlayConfig;
import com.tencent.rtmp.TXLivePlayer;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.TXRecordCommon;
import java.io.File;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

@JNINamespace(value="liteav")
public class TXLivePlayerJni
implements com.tencent.rtmp.a,
TXCloudVideoView.b {
    private static final String TAG = "TXLivePlayerJni";
    protected long mNativeTXLivePlayerJni = 0L;
    private ITXLivePlayListener mListener;
    private TXLivePlayer.ITXAudioVolumeEvaluationListener mAudioVolumeEvaluationListener;
    private TXLivePlayer.ITXAudioRawDataListener mAudioRawDataListener;
    private TXLivePlayer.ITXSnapshotListener mSnapshotListener;
    private TXRecordCommon.ITXVideoRecordListener mVideoRecordListener;
    private TXLivePlayer.ITXVideoRawDataListener mVideoRawDataListener;
    private TXLivePlayer.ITXLivePlayVideoRenderListener mVideoRenderListener;
    private Object mGLContext = null;

    public TXLivePlayerJni(Context context) {
        ContextUtils.initApplicationContext(context.getApplicationContext());
        ContextUtils.setDataDirectorySuffix("liteav");
        this.mNativeTXLivePlayerJni = TXLivePlayerJni.nativeCreate(new WeakReference<TXLivePlayerJni>(this));
    }

    protected void finalize() {
        TXLivePlayerJni.nativeDestroy(this.mNativeTXLivePlayerJni);
    }

    public static String[] getMapKeys(Map<String, String> map) {
        String[] stringArray = new String[map.size()];
        int n2 = 0;
        for (String string : map.keySet()) {
            stringArray[n2++] = string;
        }
        return stringArray;
    }

    public static String[] getMapValues(Map<String, String> map, String[] keys) {
        String[] stringArray = new String[map.size()];
        int n2 = 0;
        String[] stringArray2 = keys;
        int n3 = keys.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = stringArray2[i2];
            stringArray[n2++] = map.get(string);
        }
        return stringArray;
    }

    public static TXLivePlayerJni weakToStrongReference(WeakReference<TXLivePlayerJni> weakReference) {
        return (TXLivePlayerJni)weakReference.get();
    }

    private static native long nativeCreate(WeakReference<TXLivePlayerJni> var0);

    private static native void nativeDestroy(long var0);

    private static native void nativeSetConfig(long var0, float var2, float var3, float var4, int var5, int var6, int var7, boolean var8, boolean var9, boolean var10, String var11, Map var12);

    private static native void nativeSetPlayerView(long var0, DisplayTarget var2);

    private static native int nativeStartPlay(long var0, String var2, int var3);

    private static native void nativeStopPlay(long var0, boolean var2);

    private static native boolean nativeIsPlaying(long var0);

    private static native void nativePause(long var0);

    private static native void nativeResume(long var0);

    private static native long nativeGetCurrentRenderPts(long var0);

    private static native void nativeSetRenderMode(long var0, int var2);

    private static native void nativeSetRenderRotation(long var0, int var2);

    private static native void nativeEnableHardwareDecode(long var0, boolean var2);

    private static native void nativeSetMute(long var0, boolean var2);

    private static native void nativeSetVolume(long var0, int var2);

    private static native void nativeSetAudioRoute(long var0, int var2);

    private static native int nativeSwitchStream(long var0, String var2);

    private static native void nativeEnableAudioVolumeEvaluation(long var0, int var2);

    private static native void nativeSnapshot(long var0);

    private static native void nativeEnableCustomRenderTexture(long var0, boolean var2, Object var3);

    private static native void nativeEnableCustomRenderI420(long var0, boolean var2);

    private static native void nativeEnableCustomAudioProcess(long var0, boolean var2);

    private static native void nativeShowDebugView(long var0, boolean var2);

    private static native void nativeStartRecord(long var0, int var2, String var3);

    private static native void nativeStopRecord(long var0);

    private static native void nativeCallExperimentalAPI(long var0, String var2);

    private static String genFilePath(Context context, String suffix) {
        if (context == null) {
            return null;
        }
        try {
            String string = String.valueOf(System.currentTimeMillis() / 1000L);
            String string2 = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date(Long.valueOf(string + "000")));
            String string3 = TXLivePlayerJni.getDiskFileDir(context);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                return null;
            }
            String string4 = String.format("TXUGC_%s".concat(String.valueOf(suffix)), string2);
            return new File(string3, string4).getAbsolutePath();
        }
        catch (Exception exception) {
            LiteavLog.e(TAG, "create file path failed.", exception);
            return null;
        }
    }

    private static String getDiskFileDir(Context context) {
        if (context == null) {
            return null;
        }
        String string = null;
        if ("mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable()) {
            File file = context.getExternalFilesDir(Environment.DIRECTORY_MOVIES);
            if (file != null) {
                string = file.getPath();
            }
        } else {
            string = context.getFilesDir().getPath();
        }
        return string;
    }

    @Override
    public void setPlayListener(ITXLivePlayListener listener) {
        this.mListener = listener;
    }

    @Override
    public void setAudioVolumeEvaluationListener(TXLivePlayer.ITXAudioVolumeEvaluationListener listener) {
        this.mAudioVolumeEvaluationListener = listener;
    }

    @Override
    public void setVideoRecordListener(TXRecordCommon.ITXVideoRecordListener listener) {
        this.mVideoRecordListener = listener;
    }

    @Override
    public int startRecord(int recordType) {
        String string = TXLivePlayerJni.genFilePath(ContextUtils.getApplicationContext(), ".mp4");
        if (TextUtils.isEmpty((CharSequence)string)) {
            return -1;
        }
        TXLivePlayerJni.nativeStartRecord(this.mNativeTXLivePlayerJni, recordType, string);
        return 0;
    }

    @Override
    public int stopRecord() {
        TXLivePlayerJni.nativeStopRecord(this.mNativeTXLivePlayerJni);
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setVideoRawDataListener(TXLivePlayer.ITXVideoRawDataListener listener) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.mVideoRenderListener != null) {
                this.mVideoRenderListener = null;
                this.mGLContext = null;
                TXLivePlayerJni.nativeEnableCustomRenderTexture(this.mNativeTXLivePlayerJni, false, null);
            }
            this.mVideoRawDataListener = listener;
            TXLivePlayerJni.nativeEnableCustomRenderI420(this.mNativeTXLivePlayerJni, listener != null);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int setVideoRenderListener(TXLivePlayer.ITXLivePlayVideoRenderListener listener, Object glContext) {
        TXLivePlayerJni tXLivePlayerJni = this;
        synchronized (tXLivePlayerJni) {
            if (this.mVideoRawDataListener != null) {
                this.mVideoRawDataListener = null;
                TXLivePlayerJni.nativeEnableCustomRenderI420(this.mNativeTXLivePlayerJni, false);
            }
            this.mVideoRenderListener = listener;
            this.mGLContext = listener != null ? glContext : null;
            TXLivePlayerJni.nativeEnableCustomRenderTexture(this.mNativeTXLivePlayerJni, listener != null, this.mGLContext);
        }
        return 0;
    }

    @Override
    public void setAudioRawDataListener(TXLivePlayer.ITXAudioRawDataListener listener) {
        this.mAudioRawDataListener = listener;
        TXLivePlayerJni.nativeEnableCustomAudioProcess(this.mNativeTXLivePlayerJni, listener != null);
    }

    @Override
    public void showDebugView(boolean isShow) {
        TXLivePlayerJni.nativeShowDebugView(this.mNativeTXLivePlayerJni, isShow);
    }

    @Override
    public void setPlayerView(TXCloudVideoView view) {
        if (view != null) {
            a.a(view, new WeakReference<TXCloudVideoView.b>(this));
            this.showDebugView(a.a(view));
        }
        TXLivePlayerJni.nativeSetPlayerView(this.mNativeTXLivePlayerJni, view != null ? new DisplayTarget(view) : null);
    }

    @Override
    public void setSurface(Surface surface) {
        TXLivePlayerJni.nativeSetPlayerView(this.mNativeTXLivePlayerJni, surface != null ? new DisplayTarget(surface) : null);
    }

    @Override
    public void setSurfaceSize(int width, int height) {
    }

    @Override
    public void setConfig(TXLivePlayConfig config) {
        if (config == null) {
            return;
        }
        TXLivePlayerJni.nativeSetConfig(this.mNativeTXLivePlayerJni, config.getCacheTime(), config.getMaxAutoAdjustCacheTime(), config.getMinAutoAdjustCacheTime(), config.getVideoBlockThreshold(), config.getConnectRetryCount(), config.getConnectRetryInterval(), config.isAutoAdjustCacheTime(), config.isEnableMessage(), config.isEnableMetaData(), config.getFlvSessionKey(), config.getHeaders());
    }

    @Override
    public int startLivePlay(String playUrl, int playType) {
        return TXLivePlayerJni.nativeStartPlay(this.mNativeTXLivePlayerJni, playUrl, playType);
    }

    @Override
    public int stopPlay(boolean clearLastImage) {
        TXLivePlayerJni.nativeStopPlay(this.mNativeTXLivePlayerJni, clearLastImage);
        return 0;
    }

    @Override
    public boolean isPlaying() {
        return TXLivePlayerJni.nativeIsPlaying(this.mNativeTXLivePlayerJni);
    }

    @Override
    public void pause() {
        TXLivePlayerJni.nativePause(this.mNativeTXLivePlayerJni);
    }

    @Override
    public void resume() {
        TXLivePlayerJni.nativeResume(this.mNativeTXLivePlayerJni);
    }

    @Override
    public long getCurrentRenderPts() {
        return TXLivePlayerJni.nativeGetCurrentRenderPts(this.mNativeTXLivePlayerJni);
    }

    @Override
    public void setRenderMode(int mode) {
        TXLivePlayerJni.nativeSetRenderMode(this.mNativeTXLivePlayerJni, mode);
    }

    @Override
    public void setRenderRotation(int rotation) {
        TXLivePlayerJni.nativeSetRenderRotation(this.mNativeTXLivePlayerJni, rotation);
    }

    @Override
    public boolean enableHardwareDecode(boolean enable) {
        TXLivePlayerJni.nativeEnableHardwareDecode(this.mNativeTXLivePlayerJni, enable);
        return true;
    }

    @Override
    public void setMute(boolean mute) {
        TXLivePlayerJni.nativeSetMute(this.mNativeTXLivePlayerJni, mute);
    }

    @Override
    public void setVolume(int volume) {
        TXLivePlayerJni.nativeSetVolume(this.mNativeTXLivePlayerJni, volume);
    }

    @Override
    public void setAudioRoute(int audioRoute) {
        TXLivePlayerJni.nativeSetAudioRoute(this.mNativeTXLivePlayerJni, audioRoute);
    }

    @Override
    public int switchStream(String playUrl) {
        if (TextUtils.isEmpty((CharSequence)playUrl)) {
            LiteavLog.e(TAG, "Invalid params.");
            return -1;
        }
        return TXLivePlayerJni.nativeSwitchStream(this.mNativeTXLivePlayerJni, playUrl);
    }

    @Override
    public void enableAudioVolumeEvaluation(int intervalMs) {
        TXLivePlayerJni.nativeEnableAudioVolumeEvaluation(this.mNativeTXLivePlayerJni, intervalMs);
    }

    @Override
    public void callExperimentalAPI(String jsonStr) {
        TXLivePlayerJni.nativeCallExperimentalAPI(this.mNativeTXLivePlayerJni, jsonStr);
    }

    @Override
    public void snapshot(TXLivePlayer.ITXSnapshotListener listener) {
        this.mSnapshotListener = listener;
        TXLivePlayerJni.nativeSnapshot(this.mNativeTXLivePlayerJni);
    }

    public boolean addVideoRawData(byte[] yuvBuffer) {
        return false;
    }

    public void onPlayEvent(int code, Bundle params) {
        ITXLivePlayListener iTXLivePlayListener = this.mListener;
        if (iTXLivePlayListener != null) {
            iTXLivePlayListener.onPlayEvent(code, params);
        }
    }

    public void onNetStatus(Bundle params) {
        ITXLivePlayListener iTXLivePlayListener = this.mListener;
        if (iTXLivePlayListener != null) {
            iTXLivePlayListener.onNetStatus(params);
        }
    }

    public void onRenderVideoFrame(int format, int bufferType, Object eglContext, int textureId, int width, int height, int rotation, long pts, byte[] data, ByteBuffer buffer) {
        Object object;
        TXLivePlayer.ITXLivePlayVideoRenderListener iTXLivePlayVideoRenderListener = this.mVideoRenderListener;
        if (iTXLivePlayVideoRenderListener != null) {
            object = new TXLivePlayer.TXLiteAVTexture();
            new TXLivePlayer.TXLiteAVTexture().textureId = textureId;
            ((TXLivePlayer.TXLiteAVTexture)object).width = width;
            ((TXLivePlayer.TXLiteAVTexture)object).height = height;
            ((TXLivePlayer.TXLiteAVTexture)object).eglContext = eglContext;
            iTXLivePlayVideoRenderListener.onRenderVideoFrame((TXLivePlayer.TXLiteAVTexture)object);
        }
        if ((object = this.mVideoRawDataListener) != null) {
            object.onVideoRawDataAvailable(data, width, height, (int)pts);
        }
    }

    public void onAudioInfoChanged(int sampleRate, int channels, int bitsperchannel) {
        TXLivePlayer.ITXAudioRawDataListener iTXAudioRawDataListener = this.mAudioRawDataListener;
        if (iTXAudioRawDataListener != null) {
            iTXAudioRawDataListener.onAudioInfoChanged(sampleRate, channels, bitsperchannel);
        }
    }

    public void onPcmDataAvailable(byte[] pcmData, long timestamp) {
        TXLivePlayer.ITXAudioRawDataListener iTXAudioRawDataListener = this.mAudioRawDataListener;
        if (iTXAudioRawDataListener != null) {
            iTXAudioRawDataListener.onPcmDataAvailable(pcmData, timestamp);
        }
    }

    public void onAudioVolumeEvaluationNotify(int volume) {
        TXLivePlayer.ITXAudioVolumeEvaluationListener iTXAudioVolumeEvaluationListener = this.mAudioVolumeEvaluationListener;
        if (iTXAudioVolumeEvaluationListener != null) {
            iTXAudioVolumeEvaluationListener.onAudioVolumeEvaluationNotify(volume);
        }
    }

    public void onSnapshot(Bitmap image) {
        TXLivePlayer.ITXSnapshotListener iTXSnapshotListener = this.mSnapshotListener;
        if (iTXSnapshotListener != null) {
            iTXSnapshotListener.onSnapshot(image);
        }
    }

    @Override
    public void onShowLog(boolean enable) {
        this.showDebugView(enable);
    }

    public void onRecordComplete(int errCode, String errMessage, String outputFilePath, String coverImagePath) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            TXRecordCommon.TXRecordResult tXRecordResult = new TXRecordCommon.TXRecordResult();
            tXRecordResult.retCode = errCode == 0 ? 0 : -1;
            tXRecordResult.descMsg = errMessage;
            tXRecordResult.videoPath = outputFilePath;
            tXRecordResult.coverPath = coverImagePath;
            iTXVideoRecordListener.onRecordComplete(tXRecordResult);
        }
    }

    public void onRecordProgress(long milliSeconds) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            iTXVideoRecordListener.onRecordProgress(milliSeconds);
        }
    }

    public void onRecordEvent(int event, Bundle param) {
        TXRecordCommon.ITXVideoRecordListener iTXVideoRecordListener = this.mVideoRecordListener;
        if (iTXVideoRecordListener != null) {
            iTXVideoRecordListener.onRecordEvent(event, param);
        }
    }
}

