/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.base;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.os.Process;
import android.preference.PreferenceManager;
import com.tencent.liteav.base.PathUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import java.lang.reflect.Method;

@JNINamespace(value="base::android")
public class ContextUtils {
    private static final String TAG = "ContextUtils";
    private static Context sApplicationContext;

    public static Context getApplicationContext() {
        return sApplicationContext;
    }

    public static void initApplicationContext(Context appContext) {
        assert (sApplicationContext == null || sApplicationContext == appContext || ((ContextWrapper)sApplicationContext).getBaseContext() == appContext);
        ContextUtils.initJavaSideApplicationContext(appContext);
    }

    private static SharedPreferences fetchAppSharedPreferences() {
        return PreferenceManager.getDefaultSharedPreferences((Context)sApplicationContext);
    }

    public static SharedPreferences getAppSharedPreferences() {
        return a.a;
    }

    public static void initApplicationContextForTests(Context appContext) {
        ContextUtils.initJavaSideApplicationContext(appContext);
        a.a = ContextUtils.fetchAppSharedPreferences();
    }

    private static void initJavaSideApplicationContext(Context appContext) {
        assert (appContext != null);
        sApplicationContext = appContext;
    }

    public static AssetManager getApplicationAssets() {
        Context context = ContextUtils.getApplicationContext();
        while (context instanceof ContextWrapper) {
            context = ((ContextWrapper)context).getBaseContext();
        }
        return context.getAssets();
    }

    public static boolean isIsolatedProcess() {
        return Process.isIsolated();
    }

    public static Activity activityFromContext(Context context) {
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        return null;
    }

    public static void setDataDirectorySuffix(String suffix) {
        PathUtils.setPrivateDataDirectorySuffix(suffix, null);
    }

    public static void initContextFromNative(String suffix) {
        try {
            Method method = Class.forName("android.app.ActivityThread").getMethod("currentActivityThread", new Class[0]);
            method.setAccessible(true);
            Object object = method.invoke(null, new Object[0]);
            Object object2 = object.getClass().getMethod("getApplication", new Class[0]).invoke(object, new Object[0]);
            if (object2 instanceof Context) {
                ContextUtils.initApplicationContext((Context)object2);
                ContextUtils.setDataDirectorySuffix(suffix);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    static /* synthetic */ SharedPreferences access$000() {
        return ContextUtils.fetchAppSharedPreferences();
    }

    static final class a {
        private static SharedPreferences a = ContextUtils.access$000();
    }
}

