/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import android.text.TextUtils;
import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.group.GroupInfo;
import com.tencent.imsdk.group.GroupMemberInfo;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class V2TIMGroupInfo
implements Serializable {
    private final String TAG = "V2TIMGroupInfo";
    public static final int V2TIM_GROUP_ADD_FORBID = 0;
    public static final int V2TIM_GROUP_ADD_AUTH = 1;
    public static final int V2TIM_GROUP_ADD_ANY = 2;
    static final String GROUP_TYPE_INTERNAL_PRIVATE = "Private";
    static final String GROUP_TYPE_INTERNAL_CHATROOM = "ChatRoom";
    private GroupInfo groupInfo = new GroupInfo();
    private int modifyFlag = 0;

    public String getGroupID() {
        return this.groupInfo.getGroupID();
    }

    public void setGroupID(String groupID) {
        this.groupInfo.setGroupID(groupID);
    }

    public String getGroupType() {
        String groupType = this.groupInfo.getGroupType();
        if (groupType.equals(GROUP_TYPE_INTERNAL_PRIVATE)) {
            return "Work";
        }
        if (groupType.equals(GROUP_TYPE_INTERNAL_CHATROOM)) {
            return "Meeting";
        }
        return groupType;
    }

    public void setGroupType(String groupType) {
        if (TextUtils.isEmpty((CharSequence)groupType)) {
            IMLog.e("V2TIMGroupInfo", "setGroupType error type is null");
            return;
        }
        if (groupType.equalsIgnoreCase("Work")) {
            groupType = GROUP_TYPE_INTERNAL_PRIVATE;
        } else if (groupType.equalsIgnoreCase("Meeting")) {
            groupType = GROUP_TYPE_INTERNAL_CHATROOM;
        } else if (groupType.equalsIgnoreCase(GROUP_TYPE_INTERNAL_PRIVATE)) {
            groupType = GROUP_TYPE_INTERNAL_PRIVATE;
        } else if (groupType.equalsIgnoreCase(GROUP_TYPE_INTERNAL_CHATROOM)) {
            groupType = GROUP_TYPE_INTERNAL_CHATROOM;
        } else if (groupType.equalsIgnoreCase("Public")) {
            groupType = "Public";
        } else if (groupType.equalsIgnoreCase("AVChatRoom")) {
            groupType = "AVChatRoom";
        }
        this.groupInfo.setGroupType(groupType);
    }

    public void setSupportTopic(boolean supportTopic) {
        this.groupInfo.setSupportTopic(supportTopic);
    }

    public boolean isSupportTopic() {
        return this.groupInfo.isSupportTopic();
    }

    public String getGroupName() {
        return this.groupInfo.getGroupName();
    }

    public void setGroupName(String groupName) {
        this.groupInfo.setGroupName(groupName);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_NAME);
    }

    public String getNotification() {
        return this.groupInfo.getNotification();
    }

    public void setNotification(String notification) {
        this.groupInfo.setNotification(notification);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_NOTIFICATION);
    }

    public String getIntroduction() {
        return this.groupInfo.getIntroduction();
    }

    public void setIntroduction(String introduction) {
        this.groupInfo.setIntroduction(introduction);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_INTRODUCTION);
    }

    public String getFaceUrl() {
        return this.groupInfo.getFaceUrl();
    }

    public void setFaceUrl(String faceUrl) {
        this.groupInfo.setFaceUrl(faceUrl);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_FACE_URL);
    }

    public boolean isAllMuted() {
        return this.groupInfo.isAllShutUp();
    }

    public void setAllMuted(boolean isAllMuted) {
        this.groupInfo.setAllShutUp(isAllMuted);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_SHUTUP_ALL);
    }

    public String getOwner() {
        return this.groupInfo.getOwnerUserID();
    }

    public long getCreateTime() {
        return this.groupInfo.getCreateTime();
    }

    public int getGroupAddOpt() {
        int addOption = this.groupInfo.getApplyApproveOption();
        if (addOption == GroupInfo.GROUP_ADD_OPTION_ALLOW_ANY) {
            return 2;
        }
        if (addOption == GroupInfo.GROUP_ADD_OPTION_FORBID_ANY) {
            return 0;
        }
        if (addOption == GroupInfo.GROUP_ADD_OPTION_NEED_AUTHENTICATION) {
            return 1;
        }
        return 2;
    }

    public void setGroupAddOpt(int addOpt) {
        if (2 == addOpt) {
            this.groupInfo.setApplyApproveOption(GroupInfo.GROUP_ADD_OPTION_ALLOW_ANY);
        } else if (0 == addOpt) {
            this.groupInfo.setApplyApproveOption(GroupInfo.GROUP_ADD_OPTION_FORBID_ANY);
        } else if (1 == addOpt) {
            this.groupInfo.setApplyApproveOption(GroupInfo.GROUP_ADD_OPTION_NEED_AUTHENTICATION);
        }
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_APPLY_APPROVE_OPTION);
    }

    public int getGroupApproveOpt() {
        int approveOption = this.groupInfo.getInviteApproveOption();
        if (approveOption == GroupInfo.GROUP_ADD_OPTION_ALLOW_ANY) {
            return 2;
        }
        if (approveOption == GroupInfo.GROUP_ADD_OPTION_FORBID_ANY) {
            return 0;
        }
        if (approveOption == GroupInfo.GROUP_ADD_OPTION_NEED_AUTHENTICATION) {
            return 1;
        }
        return 2;
    }

    public void setGroupApproveOpt(int approveOpt) {
        if (2 == approveOpt) {
            this.groupInfo.setInviteApproveOption(GroupInfo.GROUP_ADD_OPTION_ALLOW_ANY);
        } else if (0 == approveOpt) {
            this.groupInfo.setInviteApproveOption(GroupInfo.GROUP_ADD_OPTION_FORBID_ANY);
        } else if (1 == approveOpt) {
            this.groupInfo.setInviteApproveOption(GroupInfo.GROUP_ADD_OPTION_NEED_AUTHENTICATION);
        }
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_INVITE_APPROVE_OPTION);
    }

    public void setCustomInfo(Map<String, byte[]> customInfoMap) {
        if (customInfoMap == null) {
            return;
        }
        if (!(customInfoMap instanceof HashMap)) {
            IMLog.e("V2TIMGroupInfo", "customInfoMap must be HashMap");
            return;
        }
        this.groupInfo.setCustomInfo(customInfoMap);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_CUSTOM_INFO);
    }

    public Map<String, byte[]> getCustomInfo() {
        return this.groupInfo.getCustomInfo();
    }

    public long getLastInfoTime() {
        return this.groupInfo.getGroupInfoTimestamp();
    }

    public long getLastMessageTime() {
        return this.groupInfo.getLastMessageTimestamp();
    }

    public int getMemberCount() {
        return (int)this.groupInfo.getMemberCount();
    }

    @Deprecated
    public int getOnlineCount() {
        return (int)this.groupInfo.getMemberOnlineCount();
    }

    public long getMemberMaxCount() {
        return this.groupInfo.getMemberMaxCount();
    }

    public int getRole() {
        int role = this.groupInfo.getGroupSelfInfo().getRole();
        if (role == GroupMemberInfo.MEMBER_ROLE_MEMBER) {
            return 200;
        }
        if (role == GroupMemberInfo.MEMBER_ROLE_ADMINISTRATOR) {
            return 300;
        }
        if (role == GroupMemberInfo.MEMBER_ROLE_OWNER) {
            return 400;
        }
        return 0;
    }

    public int getRecvOpt() {
        int recvOpt = this.groupInfo.getGroupSelfInfo().getMessageReceiveOption();
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_AUTO_RECEIVE) {
            return 0;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_NOT_RECEIVE) {
            return 1;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_RECEIVE_WITH_NO_OFFLINE_PUSH) {
            return 2;
        }
        if (recvOpt == GroupMemberInfo.MESSAGE_RECEIVE_OPTION_RECEIVE_WITH_NO_OFFLINE_PUSH_EXCEPT_AT) {
            return 3;
        }
        return 0;
    }

    public long getJoinTime() {
        return this.groupInfo.getGroupSelfInfo().getJoinTime();
    }

    public boolean isEnablePermissionGroup() {
        return this.groupInfo.isEnablePermissionGroup();
    }

    public void setEnablePermissionGroup(boolean enablePermissionGroup) {
        this.groupInfo.setEnablePermissionGroup(enablePermissionGroup);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_ENABLE_PERMISSION_GROUP);
    }

    public long getDefaultPermissions() {
        return this.groupInfo.getDefaultPermissions();
    }

    public void setDefaultPermissions(long defaultPermissions) {
        this.groupInfo.setDefaultPermissions(defaultPermissions);
        this.modifyFlag = (int)((long)this.modifyFlag | GroupInfo.GROUP_INFO_MODIFY_FLAG_DEFAULT_PERMISSIONS);
    }

    GroupInfo getGroupInfo() {
        return this.groupInfo;
    }

    void setGroupInfo(GroupInfo groupInfo) {
        this.groupInfo = groupInfo;
    }

    int getModifyFlag() {
        return this.modifyFlag;
    }

    void setModifyFlag(int modifyFlag) {
        this.modifyFlag = modifyFlag;
    }
}

