/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.imsdk.v2;

import com.tencent.imsdk.common.IMLog;
import com.tencent.imsdk.message.CustomElement;
import com.tencent.imsdk.message.FaceElement;
import com.tencent.imsdk.message.FileElement;
import com.tencent.imsdk.message.GroupTipsElement;
import com.tencent.imsdk.message.ImageElement;
import com.tencent.imsdk.message.LocationElement;
import com.tencent.imsdk.message.MergerElement;
import com.tencent.imsdk.message.Message;
import com.tencent.imsdk.message.MessageBaseElement;
import com.tencent.imsdk.message.SoundElement;
import com.tencent.imsdk.message.TextElement;
import com.tencent.imsdk.message.VideoElement;
import com.tencent.imsdk.v2.V2TIMCustomElem;
import com.tencent.imsdk.v2.V2TIMFaceElem;
import com.tencent.imsdk.v2.V2TIMFileElem;
import com.tencent.imsdk.v2.V2TIMGroupTipsElem;
import com.tencent.imsdk.v2.V2TIMImageElem;
import com.tencent.imsdk.v2.V2TIMLocationElem;
import com.tencent.imsdk.v2.V2TIMMergerElem;
import com.tencent.imsdk.v2.V2TIMSoundElem;
import com.tencent.imsdk.v2.V2TIMTextElem;
import com.tencent.imsdk.v2.V2TIMVideoElem;
import java.io.Serializable;
import java.util.List;

public class V2TIMElem
implements Serializable {
    private final String TAG = "V2TIMElem";
    private Message message;
    private int elemIndex;

    void setMessage(Message timMessage) {
        this.message = timMessage;
    }

    Message getMessage() {
        return this.message;
    }

    MessageBaseElement getElement() {
        if (this.message == null) {
            return null;
        }
        List<MessageBaseElement> messageBaseElementList = this.message.getMessageBaseElements();
        if (this.elemIndex < 0 || messageBaseElementList.size() <= this.elemIndex) {
            return null;
        }
        return messageBaseElementList.get(this.elemIndex);
    }

    void setElemIndex(int index) {
        this.elemIndex = index;
    }

    public V2TIMElem getNextElem() {
        if (this.message == null) {
            return null;
        }
        int nextElemIndex = this.elemIndex + 1;
        List<MessageBaseElement> messageBaseElementList = this.message.getMessageBaseElements();
        if (nextElemIndex >= messageBaseElementList.size()) {
            return null;
        }
        V2TIMElem v2TIMElem = new V2TIMElem();
        MessageBaseElement messageBaseElement = messageBaseElementList.get(nextElemIndex);
        if (messageBaseElement instanceof TextElement) {
            v2TIMElem = new V2TIMTextElem();
        } else if (messageBaseElement instanceof ImageElement) {
            v2TIMElem = new V2TIMImageElem();
        } else if (messageBaseElement instanceof VideoElement) {
            v2TIMElem = new V2TIMVideoElem();
        } else if (messageBaseElement instanceof SoundElement) {
            v2TIMElem = new V2TIMSoundElem();
        } else if (messageBaseElement instanceof FaceElement) {
            v2TIMElem = new V2TIMFaceElem();
        } else if (messageBaseElement instanceof FileElement) {
            v2TIMElem = new V2TIMFileElem();
        } else if (messageBaseElement instanceof CustomElement) {
            v2TIMElem = new V2TIMCustomElem();
        } else if (messageBaseElement instanceof LocationElement) {
            v2TIMElem = new V2TIMLocationElem();
        } else if (messageBaseElement instanceof MergerElement) {
            v2TIMElem = new V2TIMMergerElem();
        } else if (messageBaseElement instanceof GroupTipsElement) {
            v2TIMElem = new V2TIMGroupTipsElem();
        }
        v2TIMElem.setMessage(this.message);
        v2TIMElem.setElemIndex(nextElemIndex);
        return v2TIMElem;
    }

    public void appendElem(V2TIMElem v2TIMElem) {
        if (this.message == null) {
            IMLog.e("V2TIMElem", "appendElem error, must be first elem from message");
            return;
        }
        if (v2TIMElem instanceof V2TIMTextElem) {
            TextElement textElem = new TextElement();
            textElem.setTextContent(((V2TIMTextElem)v2TIMElem).getText());
            this.message.addElement(textElem);
        } else if (v2TIMElem instanceof V2TIMCustomElem) {
            CustomElement customElem = new CustomElement();
            customElem.setData(((V2TIMCustomElem)v2TIMElem).getData());
            customElem.setDescription(((V2TIMCustomElem)v2TIMElem).getDescription());
            customElem.setExtension(((V2TIMCustomElem)v2TIMElem).getExtension());
            this.message.addElement(customElem);
        } else if (v2TIMElem instanceof V2TIMFaceElem) {
            FaceElement faceElem = new FaceElement();
            faceElem.setFaceIndex(((V2TIMFaceElem)v2TIMElem).getIndex());
            faceElem.setFaceData(((V2TIMFaceElem)v2TIMElem).getData());
            this.message.addElement(faceElem);
        } else if (v2TIMElem instanceof V2TIMLocationElem) {
            LocationElement locationElem = new LocationElement();
            locationElem.setLatitude(((V2TIMLocationElem)v2TIMElem).getLatitude());
            locationElem.setLongitude(((V2TIMLocationElem)v2TIMElem).getLongitude());
            locationElem.setDescription(((V2TIMLocationElem)v2TIMElem).getDesc());
            this.message.addElement(locationElem);
        } else {
            IMLog.e("V2TIMElem", "appendElem error, not support this elem type");
            return;
        }
        v2TIMElem.setMessage(this.message);
        v2TIMElem.setElemIndex(this.message.getMessageBaseElements().size() - 1);
    }

    public class V2ProgressInfo {
        private long currentSize;
        private long totalSize;

        public V2ProgressInfo(long curr, long total) {
            this.currentSize = curr;
            this.totalSize = total;
        }

        public long getCurrentSize() {
            return this.currentSize;
        }

        public long getTotalSize() {
            return this.totalSize;
        }
    }
}

