package com.tencent.imsdk.offlinepush;

import com.tencent.imsdk.BaseConstants;
import com.tencent.imsdk.common.IMCallback;
import com.tencent.imsdk.manager.BaseManager;

import java.util.List;

public class OfflinePushManager {
    private static class OfflinePushManagerHolder {
        private static final OfflinePushManager offlinePushManager = new OfflinePushManager();
    }

    public static OfflinePushManager getInstance() {
        return OfflinePushManager.OfflinePushManagerHolder.offlinePushManager;
    }

    public void setOfflinePushInfo(String timPushVersion, int notificationBarStatus) {
        nativeSetOfflinePushInfo(timPushVersion, notificationBarStatus);
    }

    public void setOfflinePushToken(OfflinePushToken offlinePushToken, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetOfflinePushToken(offlinePushToken, callback);
    }

    public void setOfflinePushConfig(OfflinePushConfig offlinePushConfig, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeSetOfflinePushConfig(offlinePushConfig, callback);
    }

    public void getOfflinePushConfig(IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeGetOfflinePushConfig(callback);
    }

    public void doEnterBackground(EnterBackgroundParam enterBackgroundParam, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDoEnterBackground(enterBackgroundParam, callback);
    }

    public void doEnterForeground(EnterForegroundParam enterForegroundParam, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeDoEnterForeground(enterForegroundParam, callback);
    }

    public void reportOfflinePushEvent(List<OfflinePushEventItem> eventItemList, IMCallback callback) {
        if (!BaseManager.getInstance().isInited()) {
            if (callback != null) {
                callback.fail(BaseConstants.ERR_SDK_NOT_INITIALIZED, "sdk not init");
            }
            return;
        }

        nativeReportOfflinePushEvent(eventItemList, callback);
    }

    protected native void nativeSetOfflinePushInfo(String timPushVersion, int notificationBarStatus);

    protected native void nativeSetOfflinePushToken(OfflinePushToken token, IMCallback callback);

    protected native void nativeSetOfflinePushConfig(OfflinePushConfig config, IMCallback callback);

    protected native void nativeGetOfflinePushConfig(IMCallback callback);

    protected native void nativeDoEnterBackground(EnterBackgroundParam enterBackgroundParam, IMCallback callback);

    protected native void nativeDoEnterForeground(EnterForegroundParam enterForegroundParam, IMCallback callback);

    protected native void nativeReportOfflinePushEvent(List<OfflinePushEventItem> eventItemList, IMCallback callback);
}
