package com.tencent.imsdk.group;

import android.text.TextUtils;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class GroupInfo implements Serializable {
    public static int GROUP_ADD_OPTION_FORBID_ANY = 1;
    public static int GROUP_ADD_OPTION_NEED_AUTHENTICATION = 2;
    public static int GROUP_ADD_OPTION_ALLOW_ANY = 3;

    public static long GROUP_INFO_MODIFY_FLAG_NONE = 0;
    public static long GROUP_INFO_MODIFY_FLAG_NAME = 0x1;
    public static long GROUP_INFO_MODIFY_FLAG_NOTIFICATION = (0x1 << 1);
    public static long GROUP_INFO_MODIFY_FLAG_INTRODUCTION = (0x1 << 2);
    public static long GROUP_INFO_MODIFY_FLAG_FACE_URL = (0x1 << 3);
    public static long GROUP_INFO_MODIFY_FLAG_APPLY_APPROVE_OPTION = (0x1 << 4);
    public static long GROUP_INFO_MODIFY_FLAG_MAX_MEMBER_NUM = (0x1 << 5);
    public static long GROUP_INFO_MODIFY_FLAG_MEMBER_VISIBLE = (0x1 << 6);
    public static long GROUP_INFO_MODIFY_FLAG_GROUP_SEARCHABLE = (0x1 << 7);
    public static long GROUP_INFO_MODIFY_FLAG_SHUTUP_ALL = (0x1 << 8);
    public static long GROUP_INFO_MODIFY_FLAG_CUSTOM_INFO = (0x1 << 9);
    public static long TOPIC_INFO_MODIFY_FLAG_CUSTOM_STRING = (0x1 << 11);
    public static long GROUP_INFO_MODIFY_FLAG_INVITE_APPROVE_OPTION = (0x1 << 12);
    public static long GROUP_INFO_MODIFY_FLAG_ENABLE_PERMISSION_GROUP = (0x1 << 13);
    public static long GROUP_INFO_MODIFY_FLAG_DEFAULT_PERMISSIONS = (0x1 << 14);

    private String groupID;
    private byte[] groupNameBytes;
    private String groupType;
    // 当 groupType 为社群 Community 时，可以指定是否支持在社群下面创建话题
    // When the groupType is Community, you can specify whether to support creating topics under the community
    private boolean supportTopic;
    private String faceUrl;
    private byte[] introductionBytes;
    private byte[] notificationBytes;

    // 话题所属社群 ID
    // community ID
    private String communityID;
    // 话题自定义字符串
    // topic custom string
    private String customString;

    private long createTime;
    private String ownerUserID;
    private long memberCount;
    private long memberOnlineCount;
    private long memberMaxCount;
    private int applyApproveOption;
    private int inviteApproveOption;
    private boolean isAllShutUp;
    private boolean isGroupSearchable;
    private boolean isGroupMemberVisible;
    private long groupInfoTimestamp;
    private long lastMessageTimestamp;
    private Map<String, byte[]> customInfo = new HashMap<>();
    private long defaultPermissions;
    private boolean enablePermissionGroup;
    private GroupMemberInfo groupSelfInfo = new GroupMemberInfo();

    public String getGroupID() {
        return groupID;
    }

    public void setGroupID(String groupID) {
        this.groupID = groupID;
    }

    public String getGroupName() {
        String groupName = "";
        if (groupNameBytes != null && groupNameBytes.length > 0) {
            try {
                groupName = new String(groupNameBytes, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return groupName;
    }

    public void setGroupName(String groupName) {
        if (!TextUtils.isEmpty(groupName)) {
            try {
                this.groupNameBytes = groupName.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String getGroupType() {
        return groupType;
    }

    public void setGroupType(String groupType) {
        this.groupType = groupType;
    }

    public boolean isSupportTopic() {
        return supportTopic;
    }

    public void setSupportTopic(boolean supportTopic) {
        this.supportTopic = supportTopic;
    }

    public String getFaceUrl() {
        return faceUrl;
    }

    public void setFaceUrl(String faceUrl) {
        this.faceUrl = faceUrl;
    }

    public String getIntroduction() {
        String introduction = "";
        if (introductionBytes != null && introductionBytes.length > 0) {
            try {
                introduction = new String(introductionBytes, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return introduction;
    }

    public void setIntroduction(String introduction) {
        if (!TextUtils.isEmpty(introduction)) {
            try {
                this.introductionBytes = introduction.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public String getNotification() {
        String notification = "";
        if (notificationBytes != null && notificationBytes.length > 0) {
            try {
                notification = new String(notificationBytes, "UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return notification;
    }

    public void setNotification(String notification) {
        if (!TextUtils.isEmpty(notification)) {
            try {
                this.notificationBytes = notification.getBytes("UTF-8");
            } catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public long getCreateTime() {
        return createTime;
    }

    public void setCreateTime(long createTime) {
        this.createTime = createTime;
    }

    public String getOwnerUserID() {
        return ownerUserID;
    }

    public void setOwnerUserID(String ownerUserID) {
        this.ownerUserID = ownerUserID;
    }

    public long getMemberCount() {
        return memberCount;
    }

    public void setMemberCount(long memberCount) {
        this.memberCount = memberCount;
    }

    public long getMemberOnlineCount() {
        return memberOnlineCount;
    }

    public void setMemberOnlineCount(long memberOnlineCount) {
        this.memberOnlineCount = memberOnlineCount;
    }

    public long getMemberMaxCount() {
        return memberMaxCount;
    }

    public void setMemberMaxCount(long memberMaxCount) {
        this.memberMaxCount = memberMaxCount;
    }

    public int getApplyApproveOption() {
        return applyApproveOption;
    }

    public void setApplyApproveOption(int applyApproveOption) {
        this.applyApproveOption = applyApproveOption;
    }

    public int getInviteApproveOption() {
        return inviteApproveOption;
    }

    public void setInviteApproveOption(int inviteApproveOption) {
        this.inviteApproveOption = inviteApproveOption;
    }

    public boolean isAllShutUp() {
        return isAllShutUp;
    }

    public void setAllShutUp(boolean allShutUp) {
        isAllShutUp = allShutUp;
    }

    public boolean isGroupSearchable() {
        return isGroupSearchable;
    }

    public void setGroupSearchable(boolean groupSearchable) {
        isGroupSearchable = groupSearchable;
    }

    public boolean isGroupMemberVisible() {
        return isGroupMemberVisible;
    }

    public void setGroupMemberVisible(boolean groupMemberVisible) {
        isGroupMemberVisible = groupMemberVisible;
    }

    public long getGroupInfoTimestamp() {
        return groupInfoTimestamp;
    }

    public void setGroupInfoTimestamp(long groupInfoTimestamp) {
        this.groupInfoTimestamp = groupInfoTimestamp;
    }

    public long getLastMessageTimestamp() {
        return lastMessageTimestamp;
    }

    public void setLastMessageTimestamp(long lastMessageTimestamp) {
        this.lastMessageTimestamp = lastMessageTimestamp;
    }

    public Map<String, byte[]> getCustomInfo() {
        return customInfo;
    }

    public void setCustomInfo(Map<String, byte[]> customInfo) {
        this.customInfo = customInfo;
    }

    public long getDefaultPermissions() {
        return defaultPermissions;
    }

    public void setDefaultPermissions(long defaultPermissions) {
        this.defaultPermissions = defaultPermissions;
    }

    public boolean isEnablePermissionGroup() {
        return enablePermissionGroup;
    }

    public void setEnablePermissionGroup(boolean enablePermissionGroup) {
        this.enablePermissionGroup = enablePermissionGroup;
    }

    public GroupMemberInfo getGroupSelfInfo() {
        return groupSelfInfo;
    }

    public void setGroupSelfInfo(GroupMemberInfo groupSelfInfo) {
        this.groupSelfInfo = groupSelfInfo;
    }

    public String getCommunityID() {
        return communityID;
    }

    public void setCommunityID(String communityID) {
        this.communityID = communityID;
    }

    public String getCustomString() {
        return customString;
    }

    public void setCustomString(String customString) {
        this.customString = customString;
    }
}
