/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.annotation.TargetApi;
import android.media.AudioDeviceInfo;
import android.media.AudioRouting;
import org.webrtc.audioengine.AudioManagerAndroid;

@TargetApi(value=24)
public class AudioRoutingChangedListener
implements AudioRouting.OnRoutingChangedListener {
    private static final String TAG = "[AudioRoutingChangedListener]";

    private String getDeviceTypeStr(int type) {
        String typeStr = "";
        switch (type) {
            case 1: {
                typeStr = "BUILTIN_EARPIECE";
                break;
            }
            case 2: {
                typeStr = "BUILTIN_SPEAKER";
                break;
            }
            case 3: {
                typeStr = "WIRED_HEADSET";
                break;
            }
            case 4: {
                typeStr = "WIRED_HEADPHONES";
                break;
            }
            case 5: {
                typeStr = "LINE_ANALOG";
                break;
            }
            case 6: {
                typeStr = "LINE_DIGITAL";
                break;
            }
            case 7: {
                typeStr = "BLUETOOTH_SCO";
                break;
            }
            case 8: {
                typeStr = "BLUETOOTH_A2DP";
                break;
            }
            case 9: {
                typeStr = "HDMI";
                break;
            }
            case 10: {
                typeStr = "HDMI_ARC";
                break;
            }
            case 11: {
                typeStr = "USB_DEVICE";
                break;
            }
            case 12: {
                typeStr = "USB_ACCESSORY";
                break;
            }
            case 13: {
                typeStr = "DOCK";
                break;
            }
            case 14: {
                typeStr = "FM";
                break;
            }
            case 15: {
                typeStr = "BUILTIN_MIC";
                break;
            }
            case 16: {
                typeStr = "FM_TUNER";
                break;
            }
            case 17: {
                typeStr = "TV_TUNER";
                break;
            }
            case 18: {
                typeStr = "TELEPHONY";
                break;
            }
            case 19: {
                typeStr = "AUX_LINE";
                break;
            }
            case 20: {
                typeStr = "IP";
                break;
            }
            case 21: {
                typeStr = "BUS";
                break;
            }
            case 22: {
                typeStr = "USB_HEADSET";
                break;
            }
            default: {
                typeStr = "UNKNOWN";
            }
        }
        return typeStr;
    }

    public void onRoutingChanged(AudioRouting audioRouting) {
        AudioDeviceInfo audioDeviceInfo;
        if (audioRouting != null && (audioDeviceInfo = audioRouting.getRoutedDevice()) != null) {
            AudioManagerAndroid.doLog("[AudioRoutingChangedListener] on routing changed, routed device type: " + audioDeviceInfo.getType() + "(" + this.getDeviceTypeStr(audioDeviceInfo.getType()) + ")");
        }
    }
}

