/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc.audioengine;

import android.annotation.SuppressLint;
import android.content.Context;
import android.media.AudioManager;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Looper;
import android.os.Process;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.webrtc.audioengine.AppBackgroundMonitor;
import org.webrtc.audioengine.AppBackgroundMonitorListener;
import org.webrtc.audioengine.AudioRoutingController;
import org.webrtc.audioengine.AudioRoutingListener;
import org.webrtc.audioengine.VolumeChangeListener;
import org.webrtc.audioengine.VolumeChangeReceiver;

class AudioManagerAndroid
implements AudioRoutingListener,
VolumeChangeListener,
AppBackgroundMonitorListener {
    private static final int DEFAULT_SAMPLING_RATE = 44100;
    private static final int DEFAULT_FRAMES_PER_BUFFER = 256;
    private int mNativeOutputSampleRate;
    private boolean mAudioLowLatencySupported;
    private int mAudioLowLatencyOutputFrameSize;
    private static final String TAG = "[AudioManagerAndroid]";
    private final Context mContext;
    private final AudioManager mAudioManager;
    private boolean initialized = false;
    private static String mAppCachePath = "";
    private AudioRoutingController mAudioRoutingController;
    private VolumeChangeReceiver mVolumeBroadcastReceiver;
    private AppBackgroundMonitor mNotifyAppBackground;
    private Boolean mShouldNotify = false;

    private AudioManagerAndroid(Context context) {
        AudioManager audioManager;
        this.mContext = context;
        this.mAudioManager = audioManager = (AudioManager)context.getSystemService("audio");
        this.mNativeOutputSampleRate = 44100;
        this.mAudioLowLatencyOutputFrameSize = 256;
        if (Build.VERSION.SDK_INT >= 17) {
            String framesPerBuffer;
            String sampleRateString = audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
            if (sampleRateString != null) {
                int sampleRate = Integer.parseInt(sampleRateString);
                if (sampleRate == 8000 || sampleRate == 16000 || sampleRate == 32000 || sampleRate == 44100 || sampleRate == 48000) {
                    this.mNativeOutputSampleRate = sampleRate;
                    AudioManagerAndroid.doLog("[AudioManagerAndroid]Android native sample rate: " + sampleRate);
                } else {
                    AudioManagerAndroid.doLog("[AudioManagerAndroid]Unsupported sample rate: " + sampleRate);
                }
            }
            if ((framesPerBuffer = audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER")) != null) {
                this.mAudioLowLatencyOutputFrameSize = Integer.parseInt(framesPerBuffer);
            }
        }
        try {
            this.mAudioLowLatencySupported = context.getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
        }
        catch (RuntimeException e) {
            this.mAudioLowLatencySupported = false;
        }
        try {
            mAppCachePath = this.mContext.getExternalCacheDir().getPath();
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[AudioManagerAndroid]getExternalCacheDir failed. exception: " + e.getMessage());
        }
        this.mAudioRoutingController = new AudioRoutingController(this.mContext, this);
        this.mVolumeBroadcastReceiver = new VolumeChangeReceiver(this.mContext, this);
        this.mNotifyAppBackground = new AppBackgroundMonitor(this.mContext, this);
    }

    private void init(Context context) {
        if (this.initialized) {
            return;
        }
        AudioManagerAndroid.doLog("[AudioManagerAndroid]audio mode is: " + this.mAudioManager.getMode());
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setNotify(int notify) {
        if (notify == 1) {
            Boolean bl = this.mShouldNotify;
            synchronized (bl) {
                this.mShouldNotify = true;
            }
            this.mAudioRoutingController.init();
            this.mVolumeBroadcastReceiver.init();
            this.mNotifyAppBackground.init();
        } else {
            this.mAudioRoutingController.uninit();
            this.mVolumeBroadcastReceiver.uninit();
            this.mNotifyAppBackground.uninit();
            Boolean bl = this.mShouldNotify;
            synchronized (bl) {
                this.mShouldNotify = false;
            }
        }
    }

    private int getNativeOutputSampleRate() {
        return this.mNativeOutputSampleRate;
    }

    private boolean isAudioLowLatencySupported() {
        return this.mAudioLowLatencySupported;
    }

    private int getAudioLowLatencyOutputFrameSize() {
        return this.mAudioLowLatencyOutputFrameSize;
    }

    private static int getMode(Context context) {
        int result = 0;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            result = audioManager.getMode();
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("AudioManagerAndroid getMode error");
        }
        return result;
    }

    private static int getMaxDeviceVolume(Context context, int mode) {
        int result = 0;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            result = audioManager.getStreamMaxVolume(mode);
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("AudioManagerAndroid getMode error");
        }
        return result;
    }

    private static int getCurDeviceVolume(Context context, int mode) {
        int result = 0;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            result = audioManager.getStreamVolume(mode);
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("AudioManagerAndroid getMode error");
        }
        return result;
    }

    private void setSpeakerphoneOn(Context context, boolean on) {
        if (this.mAudioRoutingController != null) {
            this.mAudioRoutingController.setSpeakerphoneOn(on);
        }
    }

    private int queryAudioOutputRouting() {
        int ret = -1;
        if (this.mAudioRoutingController != null) {
            ret = this.mAudioRoutingController.queryAudioOutputRouting();
        }
        AudioManagerAndroid.doLog("[AudioManagerAndroid]queryAudioOutputRouting: " + ret);
        return ret;
    }

    private static int isSpeakerphoneOn(Context context) {
        int result = 0;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            result = audioManager.isSpeakerphoneOn() ? 1 : 0;
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[AudioManagerAndroid]isSpeakerphoneOn error, exception: " + e.getMessage());
        }
        return result;
    }

    private static int isHeadsetPlugin(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return audioManager.isWiredHeadsetOn() ? 1 : 0;
    }

    private static void setMode(final Context context, final int mode) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            AsyncTask.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    AudioManagerAndroid.setModeInner(context, mode);
                }
            });
        } else {
            AudioManagerAndroid.setModeInner(context, mode);
        }
    }

    private static void setModeInner(Context context, int mode) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        try {
            audioManager.setMode(mode);
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[AudioManagerAndroid]setMode failed: " + e.getMessage().toString());
            return;
        }
    }

    private void startOrStopBluetoothSco(Context context, boolean start) {
        if (this.mAudioRoutingController != null) {
            this.mAudioRoutingController.startOrStopBluetoothSco(start);
        }
    }

    public static void doLog(String msg) {
        AudioManagerAndroid.nativeLogDebugInfo(msg);
    }

    private static boolean isMultiAudioTrackFile(String filePath) {
        boolean result = false;
        try {
            MediaExtractor mediaExtractor = new MediaExtractor();
            mediaExtractor.setDataSource(filePath);
            int nTracks = mediaExtractor.getTrackCount();
            int nAudioTracks = 0;
            for (int i = 0; i < nTracks; ++i) {
                MediaFormat trackFormat = mediaExtractor.getTrackFormat(i);
                String mimeType = trackFormat.getString("mime");
                if (!mimeType.contains("audio/")) continue;
                ++nAudioTracks;
            }
            if (nAudioTracks > 1) {
                result = true;
            }
            mediaExtractor.release();
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[AudioManagerAndroid]isMultiAudioTrackFile exception: " + e.getMessage());
        }
        return result;
    }

    private static boolean isSupportHuaWeiSystemKaraoke() {
        boolean result = false;
        try {
            String emuiStr = AudioManagerAndroid.getEMUI();
            if (emuiStr == null) {
                result = false;
            } else {
                AudioManagerAndroid.doLog("[AudioManagerAndroid]emuiStr: " + emuiStr);
                String verStr = emuiStr.substring(10, emuiStr.indexOf("."));
                int value = Integer.parseInt(verStr);
                result = value >= 10;
            }
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[AudioManagerAndroid]isSupportHuaWeiSystemKaraoke exception: " + e.getMessage());
        }
        AudioManagerAndroid.doLog("[AudioManagerAndroid]isSupportHuaWeiSystemKaraoke: " + result);
        return result;
    }

    @SuppressLint(value={"PrivateApi"})
    private static String getEMUI() {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        Class<?> classType = null;
        String buildVersion = null;
        try {
            classType = Class.forName("android.os.SystemProperties");
            Method getMethod = classType.getDeclaredMethod("get", String.class);
            buildVersion = (String)getMethod.invoke(classType, "ro.build.version.emui");
        }
        catch (Exception e) {
            AudioManagerAndroid.doLog("[AudioManagerAndroid]getEMUI exception: " + e.getMessage());
        }
        return buildVersion;
    }

    private static boolean isSupportVivoSystemKaraoke(Context context) {
        boolean result = false;
        try {
            AudioManager audioManager = (AudioManager)context.getSystemService("audio");
            String micType = audioManager.getParameters("vivo_ktv_mic_type");
            StringTokenizer st = new StringTokenizer(micType, "=");
            int tokens = st.countTokens();
            if (tokens != 2) {
                result = false;
            } else {
                String value;
                int state;
                String tag = st.nextToken();
                if (tag.equals("vivo_ktv_mic_type") && ((state = Integer.parseInt(value = st.nextToken())) == 1 || state == 0)) {
                    result = true;
                }
            }
        }
        catch (Exception ex) {
            AudioManagerAndroid.doLog("[AudioManagerAndroid]isSupportVivoSystemKaraoke exception: " + ex.getMessage());
        }
        AudioManagerAndroid.doLog("[AudioManagerAndroid]isSupportVivoSystemKaraoke: " + result);
        return result;
    }

    public static boolean setThreadPriorityAudio(int tid) {
        String module;
        if (Build.VERSION.SDK_INT == 16 && (module = Build.BRAND.toLowerCase() + "-" + Build.MODEL.toLowerCase()).equals("samsung-gt-s6818")) {
            AudioManagerAndroid.doLog("setThreadPriorityAudio " + tid);
            Process.setThreadPriority((int)tid, (int)-16);
            return true;
        }
        return false;
    }

    private static int getAndroidOSVersion() {
        return Build.VERSION.SDK_INT;
    }

    private static byte[] getSystemProperty(byte[] name) {
        try {
            String propertyName = new String(name);
            if (propertyName.equals("ro.product.cpu.abilist")) {
                if (Build.VERSION.SDK_INT >= 21) {
                    return Build.SUPPORTED_ABIS[0].getBytes();
                }
                return Build.CPU_ABI.getBytes();
            }
            String p = System.getProperty(new String(name));
            if (p == null) {
                AudioManagerAndroid.doLog("[AudioManagerAndroid]getSystemProperty " + name + " failed.");
                return " ".getBytes();
            }
            return p.getBytes();
        }
        catch (Exception ex) {
            AudioManagerAndroid.doLog("[AudioManagerAndroid]getSystemProperty error, ex: " + ex.getMessage());
            return "".getBytes();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getAssetsFileData(Context context, String filename) {
        int readLength;
        if (context == null || filename.isEmpty()) {
            return null;
        }
        InputStream inputStream = null;
        BufferedInputStream bufferedInputStream = null;
        ByteBuffer outBuffer = null;
        int bufferLength = 0;
        try {
            int len;
            inputStream = context.getAssets().open(filename);
            bufferedInputStream = new BufferedInputStream(inputStream);
            bufferLength = inputStream.available();
            outBuffer = ByteBuffer.allocateDirect(bufferLength);
            outBuffer.rewind();
            byte[] tmpBytes = new byte[1024000];
            for (readLength = 0; bufferLength > readLength; readLength += len) {
                len = bufferedInputStream.read(tmpBytes);
                outBuffer.put(tmpBytes, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException e) {
                AudioManagerAndroid.doLog("GetAssetsFile: bufferedInputStream close failed");
            }
        }
        if (bufferLength != readLength) {
            return null;
        }
        byte[] outBytes = new byte[bufferLength];
        outBuffer.rewind();
        outBuffer.get(outBytes);
        return outBytes;
    }

    private static byte[] getExternalCacheDir() {
        return mAppCachePath.getBytes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onAudioRoutingChanged(int routing) {
        Boolean bl = this.mShouldNotify;
        synchronized (bl) {
            if (this.mShouldNotify.booleanValue()) {
                this.nativeNotifyAudioRouteChanged(routing);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBluetoothState(int state) {
        Boolean bl = this.mShouldNotify;
        synchronized (bl) {
            if (this.mShouldNotify.booleanValue()) {
                this.nativeNotifyBluetoothPlug(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onBluetoothScoState(int state) {
        Boolean bl = this.mShouldNotify;
        synchronized (bl) {
            if (this.mShouldNotify.booleanValue()) {
                this.nativeNotifyBluetoothScoInterrupt(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onHeadsetState(int state) {
        Boolean bl = this.mShouldNotify;
        synchronized (bl) {
            if (this.mShouldNotify.booleanValue()) {
                this.nativeNotifyBluetoothScoInterrupt(state);
                this.nativeNotifyHeadsetPlug(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onPhoneCallState(int state) {
        Boolean bl = this.mShouldNotify;
        synchronized (bl) {
            if (this.mShouldNotify.booleanValue()) {
                this.nativeNotifyPhoneCallReceive(state);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSystemVolumeChange(int volume) {
        Boolean bl = this.mShouldNotify;
        synchronized (bl) {
            if (this.mShouldNotify.booleanValue()) {
                this.nativeNotifySystemVolumeChange(volume);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyAppBackground(boolean isbg) {
        Boolean bl = this.mShouldNotify;
        synchronized (bl) {
            if (this.mShouldNotify.booleanValue()) {
                this.nativeNotifyAppBackground(isbg);
            }
        }
    }

    private native void nativeNotifyHeadsetPlug(int var1);

    private native void nativeNotifyBluetoothPlug(int var1);

    private native void nativeNotifyBluetoothScoInterrupt(int var1);

    private native void nativeNotifyPhoneCallReceive(int var1);

    private native void nativeNotifySystemVolumeChange(int var1);

    private native void nativeNotifyAppBackground(boolean var1);

    private native void nativeNotifyAudioRouteChanged(int var1);

    private static native void nativeLogDebugInfo(String var0);
}

