/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import com.yy.videoplayer.IVideoInfoCallback;
import com.yy.videoplayer.decoder.HardDecodeWay;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoDecoderCenterExt;
import com.yy.videoplayer.decoder.YLightweightVideoViewExt;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.utils.YMFLog;
import java.lang.ref.WeakReference;

public class YMFSurfaceView
extends SurfaceView
implements SurfaceHolder.Callback2,
YLightweightVideoViewExt {
    private static final String TAG = "YMFSurfaceView";
    private WeakReference<HardDecodeWay> mWeakHard;
    private SurfaceHolder mSurfaceHolder;
    private int mWidth = 64;
    private int mHeight = 64;
    private int mParentWidth = 64;
    private int mParentHeight = 64;
    private VideoConstant.ScaleMode mScaleMode = VideoConstant.ScaleMode.AspectFit;
    private VideoConstant.OrientationType mOrientationType = VideoConstant.OrientationType.Normal;
    private int mRotateAngle = 0;
    private long mStreamId;
    private boolean mIsReleased = false;
    private IVideoInfoCallback mVideoInfoCallback = null;
    private Object mLockObject = new Object();
    private int mViewState = 1;

    public YMFSurfaceView(Context context) {
        super(context.getApplicationContext());
        this.init();
    }

    public YMFSurfaceView(Context context, AttributeSet attrs) {
        super(context.getApplicationContext(), attrs);
        this.init();
    }

    public YMFSurfaceView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context.getApplicationContext(), attrs, defStyleAttr);
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySurfaceToDecoderStaff(boolean fromSurfaceChange) {
        YMFSurfaceView yMFSurfaceView = this;
        synchronized (yMFSurfaceView) {
            if (this.mWeakHard == null || this.mSurfaceHolder == null) {
                return;
            }
            HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
            if (hardDecodeWay == null) {
                return;
            }
            try {
                SurfaceHolder tmpSurfaceHolder = this.mSurfaceHolder;
                if (tmpSurfaceHolder == null) {
                    return;
                }
                hardDecodeWay.OnSurfaceCreated();
                hardDecodeWay.OnSurfaceChanged((View)this, tmpSurfaceHolder.getSurface(), this.mWidth, this.mHeight, this.mWidth, this.mHeight, this.mRotateAngle, this.mOrientationType, this.mScaleMode);
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[Render  ]", "notifySurfaceToDecoderStaff exception:" + YMFLog.stackTraceOf(e));
            }
        }
    }

    private void notifySurfaceCreatedToDecoderStaff() {
        if (this.mWeakHard == null) {
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return;
        }
        hardDecodeWay.OnSurfaceCreated();
    }

    private void notifySurfaceRedrawToDecoderStaff() {
        if (this.mWeakHard == null) {
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            return;
        }
        hardDecodeWay.OnSurfaceRedraw();
    }

    private void notifyDecoderStaffToReleaseSurface() {
        if (this.mWeakHard == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mWeakHard == null");
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface hardDecodeWay == null");
            return;
        }
        hardDecodeWay.SetPlayNotify(null);
        if (this.mSurfaceHolder != null) {
            hardDecodeWay.OnSurfaceDestroyed(this.mSurfaceHolder.getSurface());
            hardDecodeWay.setVideoInfoCallback(null);
        } else {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mSurfaceHolder == null");
        }
    }

    @Override
    public void HoldDecoderStaff() {
        HardDecodeWay hardDecodeWay = VideoDecoderCenterExt.getDecoderStaff(this.mStreamId);
        YMFLog.info(this, "[Render  ]", "HoldDecoderStaff mStreamId:" + this.mStreamId + " hardDecodeWay:" + (hardDecodeWay != null));
        if (hardDecodeWay != null) {
            this.mWeakHard = new WeakReference<HardDecodeWay>(hardDecodeWay);
            this.notifySurfaceToDecoderStaff(false);
            hardDecodeWay.setVideoInfoCallback(this.mVideoInfoCallback);
        }
    }

    public void surfaceRedrawNeeded(SurfaceHolder holder) {
        this.notifySurfaceRedrawToDecoderStaff();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        this.mSurfaceHolder = holder;
        this.notifySurfaceCreatedToDecoderStaff();
        this.notifyViewStateChange(0);
        YMFLog.info(this, "[Render  ]", "surfaceCreated streamId:" + this.mStreamId);
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        YMFLog.info(this, "[Render  ]", "surfaceChanged streamId:" + this.mStreamId + " width:" + width + " height:" + height);
        this.mSurfaceHolder = holder;
        this.mWidth = width;
        this.mHeight = height;
        this.notifyViewStateChange(0);
        this.notifySurfaceToDecoderStaff(true);
        this.notifySurfaceRedrawToDecoderStaff();
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info(this, "[Render  ]", "surfaceDestroyed streamId:" + this.mStreamId);
        this.notifyViewStateChange(1);
        this.mSurfaceHolder = holder;
        this.notifyDecoderStaffToReleaseSurface();
        this.mSurfaceHolder = null;
    }

    public VideoConstant.ViewType getViewType() {
        return VideoConstant.ViewType.SURFACE_VIDEO_VIEW;
    }

    private void notifyViewStateChange(int viewState) {
        if (this.mViewState == viewState) {
            return;
        }
        this.mViewState = viewState;
        YYVideoLibMgr.instance().onViewStateNotify(this.mStreamId, this.mViewState);
    }

    public boolean setScaleMode(VideoConstant.ScaleMode scaleMode) {
        YMFLog.info(this, "[Render  ]", "setScaleMode:" + (Object)((Object)scaleMode));
        this.mScaleMode = scaleMode;
        this.notifySurfaceToDecoderStaff(false);
        return true;
    }

    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void linkToStream(long streamId) {
        YMFLog.info(this, "[Render  ]", "linkToStream streamId:" + streamId);
        Object object = this.mLockObject;
        synchronized (object) {
            this.mStreamId = streamId;
            VideoDecoderCenterExt.Link(streamId, this);
            this.HoldDecoderStaff();
        }
        StateMonitor.instance().NotifyAddView(this.mStreamId, 0, VideoConstant.ViewType.SURFACE_VIDEO_VIEW, TAG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLinkFromStream() {
        YMFLog.info(this, "[Render  ]", "unlinktostream no param, mStreamId:" + this.mStreamId);
        Object object = this.mLockObject;
        synchronized (object) {
            this.notifyDecoderStaffToReleaseSurface();
            VideoDecoderCenterExt.Unlink(this.mStreamId);
            this.mWeakHard = null;
            StateMonitor.instance().NotifyRemoveView(this.mStreamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unLinkFromStream(long streamId) {
        YMFLog.info(this, "[Render  ]", "unlinktostream streamId:" + streamId);
        Object object = this.mLockObject;
        synchronized (object) {
            this.notifyDecoderStaffToReleaseSurface();
            VideoDecoderCenterExt.Unlink(streamId);
            this.mWeakHard = null;
            StateMonitor.instance().NotifyRemoveView(this.mStreamId);
        }
    }

    public void init() {
        try {
            YMFLog.info(this, "[Render  ]", "YSurfaceVideoView init");
            this.setFocusable(true);
            this.getHolder().addCallback((SurfaceHolder.Callback)this);
            this.setBackgroundColor(0);
            this.mIsReleased = false;
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[Render  ]", "YSurfaceVideoView failed init, exception:" + e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        YMFLog.info(this, "[Render  ]", "YSurfaceVideoView release");
        Object object = this.mLockObject;
        synchronized (object) {
            this.mIsReleased = true;
        }
    }

    public void setOrientation(VideoConstant.OrientationType orientationType, int rotateAngle) {
        YMFLog.info(this, "[Render  ]", "setOrientation orientationType:" + (Object)((Object)orientationType) + " rotateAngle:" + rotateAngle);
        this.mOrientationType = orientationType;
        this.mRotateAngle = rotateAngle;
        this.notifySurfaceToDecoderStaff(false);
    }

    public void onParentSizeChanged(int w, int h) {
        YMFLog.info(this, "[Render  ]", "onParentSizeChanged width:" + w + " height:" + h);
        this.mParentWidth = w;
        this.mParentHeight = h;
        this.notifySurfaceToDecoderStaff(false);
    }

    public boolean isReleased() {
        return this.mIsReleased;
    }

    public void setVideoInfoCallback(IVideoInfoCallback iVideoInfoCallback) {
        this.mVideoInfoCallback = iVideoInfoCallback;
        if (this.mWeakHard == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface mWeakHard == null");
            return;
        }
        HardDecodeWay hardDecodeWay = (HardDecodeWay)this.mWeakHard.get();
        if (hardDecodeWay == null) {
            YMFLog.error((Object)this, "[Render  ]", "notifyDecoderStaffToReleaseSurface hardDecodeWay == null");
            return;
        }
        hardDecodeWay.setVideoInfoCallback(iVideoInfoCallback);
    }
}

