/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import android.util.AttributeSet;
import android.view.Choreographer;
import android.view.SurfaceHolder;
import com.yy.videoplayer.YMFEventManager;
import com.yy.videoplayer.YMFStreamManager;
import com.yy.videoplayer.decoder.HardDecodeWayBuffer;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.IRender;
import com.yy.videoplayer.render.YMFRender;
import com.yy.videoplayer.stat.YMFPlayerStatisticManager;
import com.yy.videoplayer.stat.YMFPlayerUsrBehaviorStat;
import com.yy.videoplayer.utils.GLUtil;
import com.yy.videoplayer.utils.TimeUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.view.YMFPlayerController;
import com.yy.videoplayer.view.YMFRenderImage;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.opengles.GL10;

public class YMFPlayerView
extends GLSurfaceView
implements GLSurfaceView.Renderer,
SurfaceHolder.Callback,
Choreographer.FrameCallback {
    private String hash = Integer.toHexString(System.identityHashCode((Object)this));
    private static final String TAG = "YMFPlayerView:";
    private static final String THREAD = "YMFPlView_GLThread";
    private static final int RENDER_DURATION_LIMIT_5 = 200;
    private static final int RENDER_DURATION_LIMIT_10 = 100;
    private static final int RENDER_DURATION_LIMIT_15 = 66;
    private static final int RENDER_DURATION_LIMIT_20 = 50;
    private static final int RENDER_DURATION_LIMIT_24 = 41;
    private int mTargetRenderDuration = 66;
    private IRender mVideoRender = null;
    private IRender mBackgroundRender = null;
    private boolean mSurfaceCreated = false;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private AtomicBoolean mRenderReady = new AtomicBoolean(false);
    private AtomicBoolean mGlThreadReady = new AtomicBoolean(false);
    private AtomicBoolean mDrawBlackScreen = new AtomicBoolean(false);
    private WeakReference<YMFPlayerController.YMFPlayerControlProxy> mPlayerViewControllerProxy = null;
    private Bitmap mBackgroundBitmap = null;
    private boolean mFirstFrameRendered = false;
    private int mDrawTime = 0;
    private HashMap<Long, Boolean> mStreamFirstFrameRenderedMap = new HashMap();
    private boolean mCurrentDrawBlack = true;
    private int mCurrentDrawBlackTime = 0;
    private int mNoRenderFrameNum = 0;
    private int mViewState = 1;
    private long minDeltaPts = 0L;
    private HashMap<Long, Boolean> mIgnoreStatistic = new HashMap();
    private HashMap<Long, Long> mIgnoreStatisticPtsMap = new HashMap();
    private int mRenderMode = 0;
    private Choreographer mChoreographer;
    private boolean mHasRegisterVsync = false;
    private long mLastRenderRequestTime = 0L;
    private long mVsyncT = 0L;
    private long mVsyncCnt = 0L;

    public YMFPlayerView(Context context) {
        super(context);
        this.initEgl();
    }

    public YMFPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initEgl();
    }

    public YMFPlayerView(Context context, AttributeSet attrs, YMFPlayerController.YMFPlayerControlProxy controller) {
        super(context);
        this.initEgl();
        this.mPlayerViewControllerProxy = new WeakReference<YMFPlayerController.YMFPlayerControlProxy>(controller);
    }

    @TargetApi(value=16)
    private void initEgl() {
        YMFPlayerUsrBehaviorStat.getInstance().notifyVideoPlayerViewState(0, true);
        this.setEGLContextClientVersion(2);
        this.setEGLConfigChooser(new ConfigChooser(5, 6, 5, 0, 0, 0));
        this.setDebugFlags(1);
        this.setRenderer(this);
        this.setRenderMode(0);
        this.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mGlThreadReady.set(true);
        this.mDrawBlackScreen.set(false);
        this.mChoreographer = Choreographer.getInstance();
        YMFPlayerUsrBehaviorStat.getInstance().notifyGlManagerState(0, true);
    }

    public void setRenderControlByChoreographer() {
        if (!this.mHasRegisterVsync) {
            this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this);
            this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
            this.mHasRegisterVsync = true;
        }
    }

    private void notifyViewStateChange(int viewState) {
        if (this.mViewState == viewState) {
            return;
        }
        this.mViewState = viewState;
        this.renderLock();
        if (this.mPlayerViewControllerProxy != null && this.mPlayerViewControllerProxy.get() != null) {
            ConcurrentHashMap<Integer, YMFRenderImage> map = ((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).getRenderImageMap();
            for (YMFRenderImage img : map.values()) {
                if (img == null || img.mStreamId == 0L) continue;
                if (this.mViewState == 0) {
                    this.mIgnoreStatistic.put(img.mStreamId, true);
                }
                YYVideoLibMgr.instance().onViewStateNotify(img.mStreamId, this.mViewState);
                HardDecodeWayBuffer decodeWayBuffer = YMFStreamManager.instance().getDecoderWithStreamId(img.mStreamId);
                if (decodeWayBuffer == null) continue;
                decodeWayBuffer.setVideoPlayRender(true);
            }
        }
        this.renderUnlock();
    }

    public void setIgnoreStatistic(long streamId) {
        this.mIgnoreStatistic.put(streamId, true);
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        YMFLog.info((Object)this, "[PlayView]", "surfaceDestroyed start.");
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewOnSurface(0, false);
        YMFPlayerStatisticManager.getInstance().reset();
        this.notifyViewStateChange(1);
        this.renderLock();
        this.mSurfaceCreated = false;
        this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this);
        this.renderUnlock();
        this.postToGlThread(new Runnable(){

            @Override
            public void run() {
                YMFPlayerView.this.releaseRender();
            }
        });
        super.surfaceDestroyed(holder);
        YMFLog.info((Object)this, "[PlayView]", "surfaceDestroyed end. not detach");
    }

    public void onSurfaceCreated(GL10 gl, EGLConfig config) {
        YMFLog.info((Object)this, "[PlayView]", "onSurfaceCreated .");
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewOnSurface(0, true);
        Thread.currentThread().setName(THREAD);
        this.notifyViewStateChange(0);
    }

    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.notifyViewStateChange(0);
        this.renderLock();
        this.mSurfaceCreated = true;
        if (this.mHasRegisterVsync) {
            this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this);
            this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
        }
        this.renderUnlock();
        if (this.mSurfaceWidth != width || this.mSurfaceHeight != height) {
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        if (this.mPlayerViewControllerProxy != null && this.mPlayerViewControllerProxy.get() != null) {
            ((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).updateVideoLayout(this.mSurfaceWidth, this.mSurfaceHeight);
        }
        this.forceReDraw();
        YMFLog.info((Object)this, "[PlayView]", "onSurfaceChanged width:" + width + " height:" + height + " now:" + TimeUtil.getTickCountLong());
    }

    public void forceReDraw() {
        if (this.mFirstFrameRendered) {
            this.mDrawTime = 0;
            this.setDataReDraw();
        }
        this.requestRender();
        this.requestRender();
    }

    public void release() {
        YMFPlayerUsrBehaviorStat.getInstance().notifyVideoPlayerViewState(0, false);
        YMFPlayerUsrBehaviorStat.getInstance().notifyGlManagerState(0, false);
        YMFLog.info((Object)this, "[PlayView]", "release finish.");
        this.mIgnoreStatistic.clear();
        this.mIgnoreStatisticPtsMap.clear();
        if (this.mBackgroundBitmap != null) {
            this.mBackgroundBitmap = null;
        }
    }

    private void releaseRender() {
        if (this.mVideoRender != null) {
            this.mVideoRender.release();
            this.mVideoRender = null;
        }
        if (this.mBackgroundRender != null) {
            this.mBackgroundRender.release();
            this.mBackgroundRender = null;
        }
        this.mBackgroundBitmap = null;
        this.mRenderReady.set(false);
        YMFLog.info((Object)this, "[PlayView]", "releaseRender .");
    }

    public void postToGlThread(Runnable runable) {
        if (this.mGlThreadReady.get()) {
            this.queueEvent(runable);
        }
    }

    private void notifyRenderInfo(long streamId, long pts, long dts, int width, int height, int rct, boolean ignoreStat) {
        YMFEventManager.instance().notifyRenderEvnet(streamId, pts, dts, width, height, TimeUtil.getTickCountLong(), rct, this.getVisibility(), ignoreStat);
    }

    private void notifyRenderException(String msg) {
        YMFLog.error((Object)this, "[PlayView]", "onDrawFrame Error ! " + msg);
    }

    public void requestGlRender() {
        if (this.mHasRegisterVsync) {
            this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this);
        }
        this.mHasRegisterVsync = false;
        this.requestRender();
    }

    public void doFrame(long frameTimeNanos) {
        this.renderLock();
        if (!this.mHasRegisterVsync) {
            this.renderUnlock();
            return;
        }
        this.mChoreographer.removeFrameCallback((Choreographer.FrameCallback)this);
        this.mChoreographer.postFrameCallback((Choreographer.FrameCallback)this);
        this.mHasRegisterVsync = true;
        if (frameTimeNanos - this.mLastRenderRequestTime > 24000000L && this.mSurfaceCreated) {
            ++this.mVsyncCnt;
            long t1 = System.currentTimeMillis();
            if (t1 - this.mVsyncT > 6000L) {
                this.mVsyncT = t1;
                YMFLog.info((Object)this, "[Render  ]", "  in 6 seconds " + this.mVsyncCnt);
                this.mVsyncCnt = 0L;
            }
            this.requestRender();
            this.mLastRenderRequestTime = frameTimeNanos;
        }
        this.renderUnlock();
    }

    public void onDrawFrame(GL10 gl) {
        ConcurrentHashMap<Integer, YMFRenderImage> map;
        GLUtil.checkGlError("onDrawFrame enter ");
        if (this.mPlayerViewControllerProxy != null && this.mPlayerViewControllerProxy.get() != null && (map = ((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).getRenderImageMap()) != null && map.size() > 0) {
            try {
                this.renderLock();
                if (!this.mRenderReady.get() && this.mSurfaceCreated && this.mVideoRender == null) {
                    this.mVideoRender = new YMFRender(2);
                    this.mRenderReady.set(true);
                }
                gl.glClearColor(0.0f, 0.0f, 0.0f, 1.0f);
                gl.glClear(16384);
                if (this.mRenderReady.get() && this.mVideoRender != null && this.mDrawBlackScreen.get()) {
                    this.renderUnlock();
                    return;
                }
                this.drawBackground(map.get(0));
                if (this.mRenderReady.get() && this.mSurfaceCreated) {
                    for (Map.Entry<Integer, YMFRenderImage> entry : map.entrySet()) {
                        YMFRenderImage renderImage = entry.getValue();
                        if (renderImage == null || !renderImage.mRenderPrepared || renderImage.mDecodeImage == null || renderImage.mDecodeImage.mData == null) continue;
                        this.drawVideo(gl, renderImage);
                    }
                }
                this.renderUnlock();
            }
            catch (Throwable t) {
                this.renderUnlock();
                this.notifyRenderException(t.getMessage() + " " + t.toString());
            }
        }
    }

    private void updateMultiRenderFps(YMFRenderImage image) {
        if (image != null && image.mDecodeImage != null && image.mVideoMode == VideoConstant.VideoViewMode.MultiMode) {
            if (this.minDeltaPts == 0L) {
                this.minDeltaPts = image.mDecodeImage.mDeltaPts;
            }
            if (image.mDecodeImage.mDeltaPts < this.minDeltaPts) {
                this.minDeltaPts = image.mDecodeImage.mDeltaPts;
            }
        }
    }

    private void drawBackground(YMFRenderImage renderImageDefault) {
        if (this.mPlayerViewControllerProxy != null && this.mPlayerViewControllerProxy.get() != null && renderImageDefault != null) {
            if (((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).getBackgroundBitmap() != this.mBackgroundBitmap) {
                if (this.mBackgroundRender != null) {
                    this.mBackgroundRender.release();
                    this.mBackgroundRender = null;
                }
                this.mBackgroundBitmap = ((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).getBackgroundBitmap();
                if (this.mBackgroundBitmap != null) {
                    if (this.mBackgroundRender == null) {
                        this.mBackgroundRender = new YMFRender(0);
                    }
                    this.mBackgroundRender.prepareInputBackgroundTexture(this.mBackgroundBitmap, renderImageDefault.mBackGroundPosition.mWidth, renderImageDefault.mBackGroundPosition.mHeight);
                }
            }
            if (this.mBackgroundBitmap != null && this.mBackgroundRender != null) {
                GLES20.glViewport((int)renderImageDefault.mBackGroundPosition.mX, (int)renderImageDefault.mBackGroundPosition.mY, (int)renderImageDefault.mBackGroundPosition.mWidth, (int)renderImageDefault.mBackGroundPosition.mHeight);
                this.mBackgroundRender.render();
            }
        }
    }

    private void drawVideo(GL10 gl, YMFRenderImage renderImage) {
        if (renderImage == null || renderImage.mDecodeImage == null) {
            return;
        }
        if (renderImage.mVideoMode == VideoConstant.VideoViewMode.SingeMode) {
            this.drawNormal(gl, renderImage);
        } else {
            this.drawMulti(gl, renderImage);
            this.updateMultiRenderFps(renderImage);
        }
        this.mCurrentDrawBlack = false;
        this.mCurrentDrawBlackTime = 0;
        this.mNoRenderFrameNum = 0;
        GLUtil.checkGlError((Object)((Object)this) + " onDrawFrame out ");
    }

    private void notifyRenderInfo(YMFRenderImage renderImage, int renderCostTime) {
        if (renderImage != null && renderImage.mDecodeImage.mNotifyRenderInfo && renderImage.mDecodeImage.mLastNotifyRenderInfoPts != renderImage.mDecodeImage.mPts && renderImage.mDecodeImage.mNeedRendered) {
            boolean ignoreStatistic = false;
            if (renderImage.mDecodeImage.mMultiIgnoreState) {
                this.mIgnoreStatistic.put(renderImage.mDecodeImage.mStreamId, true);
            }
            if (this.mIgnoreStatistic.containsKey(renderImage.mDecodeImage.mStreamId)) {
                ignoreStatistic = this.mIgnoreStatistic.get(renderImage.mDecodeImage.mStreamId);
                this.mIgnoreStatisticPtsMap.put(renderImage.mDecodeImage.mStreamId, renderImage.mDecodeImage.mPts);
            } else if (this.mIgnoreStatisticPtsMap.containsKey(renderImage.mDecodeImage.mStreamId)) {
                if (this.mIgnoreStatisticPtsMap.get(renderImage.mDecodeImage.mStreamId) == renderImage.mDecodeImage.mPts) {
                    ignoreStatistic = true;
                } else {
                    this.mIgnoreStatisticPtsMap.remove(renderImage.mDecodeImage.mStreamId);
                }
            }
            this.notifyRenderInfo(renderImage.mDecodeImage.mStreamId, renderImage.mDecodeImage.mPts, renderImage.mDecodeImage.mDts, renderImage.mDecodeImage.mCropRight - renderImage.mDecodeImage.mCropLeft + 1, renderImage.mDecodeImage.mCropBottom - renderImage.mDecodeImage.mCropTop + 1, renderCostTime, !ignoreStatistic ? renderImage.mDecodeImage.mIgnore : ignoreStatistic);
            renderImage.mDecodeImage.mLastNotifyRenderInfoPts = renderImage.mDecodeImage.mPts;
            renderImage.mDecodeImage.mMultiIgnoreState = false;
            if (ignoreStatistic) {
                YMFLog.info((Object)this, "[Decoder ]", "IgnoreStat mStreamId:" + renderImage.mDecodeImage.mStreamId + " pts:" + renderImage.mDecodeImage.mPts);
                this.mIgnoreStatistic.put(renderImage.mDecodeImage.mStreamId, false);
            }
        }
    }

    private void drawBlack(GL10 gl, YMFRenderImage renderImage) {
        if (!this.mCurrentDrawBlack) {
            if (renderImage.mVideoSize.width > 0 && renderImage.mVideoSize.height > 0) {
                gl.glViewport(renderImage.mVideoSize.x, renderImage.mVideoSize.y, renderImage.mVideoSize.width, renderImage.mVideoSize.height);
            }
            gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            gl.glClear(16384);
            if (this.mCurrentDrawBlackTime++ > 2) {
                this.mCurrentDrawBlack = true;
            }
            this.mFirstFrameRendered = false;
            YMFLog.warn((Object)this, "[PlayView]", "onDrawFrame mCurrentDrawBlack ");
        }
    }

    private void drawNormal(GL10 gl, YMFRenderImage renderImage) {
        if (this.mRenderReady.get() && renderImage.mDecodeImage != null && this.mVideoRender != null && this.getDataArriveFlag().get()) {
            long startRenderTime = System.currentTimeMillis();
            if (renderImage.mVideoSize.width > 0 && renderImage.mVideoSize.height > 0) {
                gl.glViewport(renderImage.mVideoSize.x, renderImage.mVideoSize.y, renderImage.mVideoSize.width, renderImage.mVideoSize.height);
            } else {
                YMFLog.error((Object)this, "[PlayView]", " glViewport error, width:" + renderImage.mVideoSize.width + " height:" + renderImage.mVideoSize.height);
            }
            if (renderImage.mScaleMode.compareTo(VideoConstant.ScaleMode.AspectFit) == 0 || renderImage.mScaleMode.compareTo(VideoConstant.ScaleMode.Original) == 0) {
                gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
                gl.glClear(16384);
            }
            if (this.mVideoRender.prepareInputImageData(renderImage.mDecodeImage)) {
                boolean isEnableMirrorMode;
                if (renderImage.mDecodeImage.mWidth != renderImage.mDecodeImage.mCropRight - renderImage.mDecodeImage.mCropLeft + 1 || renderImage.mDecodeImage.mHeight != renderImage.mDecodeImage.mCropBottom - renderImage.mDecodeImage.mCropTop + 1 || renderImage.mDecodeImage.mChangeRenderMode) {
                    this.mVideoRender.clip(renderImage.mDecodeImage.mWidth, renderImage.mDecodeImage.mHeight, renderImage.mDecodeImage.mCropLeft, renderImage.mDecodeImage.mCropRight, renderImage.mDecodeImage.mCropBottom, renderImage.mDecodeImage.mCropTop, renderImage.mDecodeImage.mClipWindow);
                }
                boolean bl = isEnableMirrorMode = renderImage.mMirrorMode.compareTo(VideoConstant.MirrorMode.Enabled) == 0;
                if (this.mVideoRender.checkUpdateMirrorMode(isEnableMirrorMode)) {
                    this.mVideoRender.flipHorizontal();
                }
                this.mVideoRender.render();
            }
            long renderCostTime = System.currentTimeMillis() - startRenderTime;
            this.notifyRenderInfo(renderImage, (int)renderCostTime);
            this.getDataArriveFlag().set(false);
            this.mFirstFrameRendered = true;
            if (this.mDrawTime++ <= 1) {
                this.setDataReDraw();
            }
        } else {
            this.notifyNoFrameRenderStatistic(renderImage);
        }
    }

    private void drawMulti(GL10 gl, YMFRenderImage renderImage) {
        if (this.mRenderReady.get() && renderImage.mDecodeImage != null && this.mVideoRender != null) {
            if (renderImage.mVideoSize.width > 0 && renderImage.mVideoSize.height > 0) {
                gl.glViewport(renderImage.mVideoSize.x, renderImage.mVideoSize.y, renderImage.mVideoSize.width, renderImage.mVideoSize.height);
            }
            long startRenderTime = System.currentTimeMillis();
            if (this.mVideoRender.prepareInputImageData(renderImage.mDecodeImage)) {
                boolean isEnableMirrorMode;
                if (renderImage.mDecodeImage.mWidth != renderImage.mDecodeImage.mCropRight - renderImage.mDecodeImage.mCropLeft + 1 || renderImage.mDecodeImage.mHeight != renderImage.mDecodeImage.mCropBottom - renderImage.mDecodeImage.mCropTop + 1 || renderImage.mDecodeImage.mChangeRenderMode) {
                    this.mVideoRender.clip(renderImage.mDecodeImage.mWidth, renderImage.mDecodeImage.mHeight, renderImage.mDecodeImage.mCropLeft, renderImage.mDecodeImage.mCropRight, renderImage.mDecodeImage.mCropBottom, renderImage.mDecodeImage.mCropTop, renderImage.mDecodeImage.mClipWindow);
                }
                if (renderImage.mDecodeImage.mCropRight - renderImage.mDecodeImage.mCropLeft + 1 != renderImage.mDrawPosition.mWidth || renderImage.mDecodeImage.mCropBottom - renderImage.mDecodeImage.mCropTop + 1 != renderImage.mDrawPosition.mHeight) {
                    this.mVideoRender.clip(renderImage.mDecodeImage.mCropRight - renderImage.mDecodeImage.mCropLeft + 1, renderImage.mDecodeImage.mCropBottom - renderImage.mDecodeImage.mCropTop + 1, renderImage.mDrawPosition.mWidth, renderImage.mDrawPosition.mHeight, renderImage.mScaleMode);
                }
                boolean bl = isEnableMirrorMode = renderImage.mMirrorMode.compareTo(VideoConstant.MirrorMode.Enabled) == 0;
                if (this.mVideoRender.checkUpdateMirrorMode(isEnableMirrorMode)) {
                    this.mVideoRender.flipHorizontal();
                }
                this.mVideoRender.render();
                ++this.mDrawTime;
            }
            long renderCostTime = System.currentTimeMillis() - startRenderTime;
            this.notifyRenderInfo(renderImage, (int)renderCostTime);
        } else {
            this.notifyNoFrameRenderStatistic(renderImage);
        }
    }

    private void notifyNoFrameRenderStatistic(YMFRenderImage renderImage) {
        if (renderImage == null) {
            return;
        }
        if (this.mNoRenderFrameNum++ % 100 == 0) {
            YMFLog.warn((Object)this, "onDrawFrame ", renderImage.mStreamId + "," + this.mRenderReady.get() + "," + this.getDataArriveFlag().get() + "," + this.mSurfaceCreated + "," + renderImage.mDecodeImage.mStreamStart + ",,pts:" + (renderImage.mDecodeImage == null ? 0L : renderImage.mDecodeImage.mPts) + ",  now:" + TimeUtil.getTickCountLong());
        }
    }

    public void setLastFrameRenderBlack(boolean black) {
        YMFLog.info((Object)this, "[PlayView]", "drawBlackScreen video" + black);
        this.mDrawBlackScreen.set(black);
        if (this.mRenderMode == 0 && this.mDrawBlackScreen.get()) {
            this.requestRender();
            this.requestRender();
        }
    }

    public void renderLock() {
        if (this.mPlayerViewControllerProxy != null && this.mPlayerViewControllerProxy.get() != null) {
            ((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).getRenderLock().lock();
        }
    }

    public void renderUnlock() {
        if (this.mPlayerViewControllerProxy != null && this.mPlayerViewControllerProxy.get() != null) {
            ((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).getRenderLock().unlock();
        }
    }

    public void setDataReDraw() {
        if (this.mPlayerViewControllerProxy != null && this.mPlayerViewControllerProxy.get() != null) {
            ((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).setDataArriveFlag();
        }
    }

    public AtomicBoolean getDataArriveFlag() {
        if (this.mPlayerViewControllerProxy != null && this.mPlayerViewControllerProxy.get() != null) {
            return ((YMFPlayerController.YMFPlayerControlProxy)this.mPlayerViewControllerProxy.get()).getDataArriveFlag();
        }
        return new AtomicBoolean(false);
    }

    private static class ConfigChooser
    implements GLSurfaceView.EGLConfigChooser {
        private int mRedSize;
        private int mGreenSize;
        private int mBlueSize;
        private int mAlphaSize;
        private int mDepthSize;
        private int mStencilSize;
        private static final int EGL_OPENGL_ES2_BIT = 4;
        private int[] mDefaultValue = new int[1];
        private int[] mConfigAttr = new int[]{12324, 4, 12323, 4, 12322, 4, 12352, 4, 12344};

        private ConfigChooser(int r, int g, int b, int a, int d, int s) {
            this.mRedSize = r;
            this.mGreenSize = g;
            this.mBlueSize = b;
            this.mAlphaSize = a;
            this.mDepthSize = d;
            this.mStencilSize = s;
        }

        public EGLConfig chooseConfig(EGL10 egl, EGLDisplay display) {
            int[] numConfig = new int[1];
            egl.eglChooseConfig(display, this.mConfigAttr, null, 0, numConfig);
            int num = numConfig[0];
            if (num > 0) {
                EGLConfig[] configs = new EGLConfig[num];
                egl.eglChooseConfig(display, this.mConfigAttr, configs, num, numConfig);
                return this.chooseConfig(egl, display, configs);
            }
            return null;
        }

        private EGLConfig chooseConfig(EGL10 egl, EGLDisplay display, EGLConfig[] configs) {
            for (EGLConfig config : configs) {
                int d = this.findConfigAttrib(egl, display, config, 12325, 0);
                int s = this.findConfigAttrib(egl, display, config, 12326, 0);
                if (d < this.mDepthSize || s < this.mStencilSize) continue;
                int r = this.findConfigAttrib(egl, display, config, 12324, 0);
                int g = this.findConfigAttrib(egl, display, config, 12323, 0);
                int b = this.findConfigAttrib(egl, display, config, 12322, 0);
                int a = this.findConfigAttrib(egl, display, config, 12321, 0);
                if (r != this.mRedSize || g != this.mGreenSize || b != this.mBlueSize || a != this.mAlphaSize) continue;
                return config;
            }
            return null;
        }

        private int findConfigAttrib(EGL10 egl, EGLDisplay display, EGLConfig config, int attribute, int defaultValue) {
            if (egl.eglGetConfigAttrib(display, config, attribute, this.mDefaultValue)) {
                return this.mDefaultValue[0];
            }
            return defaultValue;
        }
    }
}

