/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.view.YMFLayoutParams;
import com.yy.videoplayer.view.YMFPlayerController;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class YMFPlayerSession {
    private ConcurrentHashMap<View, YMFPlayerController> mPlayerViewControllerMap = new ConcurrentHashMap();
    private Context mContext = null;
    private boolean mUseTextureView = false;

    public void setUseTextureView(boolean isUseTextureView) {
        YMFLog.info(this, "[Api     ]", "setUseTextureView," + isUseTextureView);
        this.mUseTextureView = isUseTextureView;
    }

    public View createView(Context context) {
        this.mContext = context;
        YMFPlayerController playerController = new YMFPlayerController(this.mContext);
        playerController.setUseTextureView(this.mUseTextureView);
        View view = playerController.createVideoView();
        this.mPlayerViewControllerMap.put(view, playerController);
        YMFLog.info(this, "[Render  ]", "createView," + view);
        return view;
    }

    @Deprecated
    public void destroyView(View view) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            YMFLog.info(this, "[Render  ]", "destroyView," + view);
            this.mPlayerViewControllerMap.get(view).destroyVideoView();
            this.mPlayerViewControllerMap.get(view).release();
            this.mPlayerViewControllerMap.remove(view);
        }
    }

    public int linkStream(View view, long streamId, int index) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            if (index >= 0) {
                return this.mPlayerViewControllerMap.get(view).linkStream(streamId, index);
            }
            return this.mPlayerViewControllerMap.get(view).linkStream(streamId);
        }
        return -1;
    }

    public int unLinkStream(View view, long streamId, int index) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            if (index >= 0) {
                return this.mPlayerViewControllerMap.get(view).unLinkStream(streamId, index);
            }
            return this.mPlayerViewControllerMap.get(view).unLinkStream(streamId);
        }
        return -2;
    }

    public int setViewLayout(View view, YMFLayoutParams params) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            YMFLog.info(this, "[Render  ]", "setViewLayout," + view);
            return this.mPlayerViewControllerMap.get(view).setViewLayout(params);
        }
        return -2;
    }

    public int setScaleMode(View view, VideoConstant.ScaleMode scaleMode, int index) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            if (index < 0) {
                return this.mPlayerViewControllerMap.get(view).setScaleMode(scaleMode);
            }
            return this.mPlayerViewControllerMap.get(view).setScaleMode(scaleMode, index);
        }
        return -2;
    }

    public int setMirrorMode(View view, VideoConstant.MirrorMode mirrorMode, int index) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            if (index < 0) {
                return this.mPlayerViewControllerMap.get(view).setMirrorMode(mirrorMode, 0);
            }
            return this.mPlayerViewControllerMap.get(view).setMirrorMode(mirrorMode, index);
        }
        return -2;
    }

    public Bitmap getVideoScreenshot(View view, int index) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            if (index < 0) {
                return this.mPlayerViewControllerMap.get(view).getVideoScreenshot();
            }
            return this.mPlayerViewControllerMap.get(view).getVideoScreenshotExt(index);
        }
        return null;
    }

    public int switchDualVideoView(View view, long oldStreamId, long newStreamId, int seatId) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            if (seatId >= 0) {
                return this.mPlayerViewControllerMap.get(view).switchDualVideoView(oldStreamId, newStreamId, seatId);
            }
            return this.mPlayerViewControllerMap.get(view).switchDualVideoView(oldStreamId, newStreamId, 0);
        }
        return -1;
    }

    public int setLastFrameRenderBlack(View view, boolean isBlack) {
        if (this.mPlayerViewControllerMap.get(view) != null) {
            this.mPlayerViewControllerMap.get(view).setLastFrameRenderBlack(isBlack);
            return 0;
        }
        return -2;
    }

    public void release() {
        if (this.mPlayerViewControllerMap != null) {
            for (Map.Entry<View, YMFPlayerController> entry : this.mPlayerViewControllerMap.entrySet()) {
                YMFPlayerController controller = entry.getValue();
                if (controller == null) continue;
                controller.release();
            }
            this.mPlayerViewControllerMap.clear();
        }
    }
}

