/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.RequiresApi;
import android.view.View;
import android.view.ViewParent;
import android.widget.FrameLayout;
import com.yy.videoplayer.IYMFDecoderListener;
import com.yy.videoplayer.YMFStreamManager;
import com.yy.videoplayer.decoder.StateMonitor;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.VideoSizeUtils;
import com.yy.videoplayer.decoder.YYVideoLibMgr;
import com.yy.videoplayer.render.YMFImageBuffer;
import com.yy.videoplayer.stat.YMFPlayerUsrBehaviorStat;
import com.yy.videoplayer.utils.ImageUtil;
import com.yy.videoplayer.utils.YMFLog;
import com.yy.videoplayer.view.YMFLayoutParams;
import com.yy.videoplayer.view.YMFPlayerTextureView;
import com.yy.videoplayer.view.YMFPlayerView;
import com.yy.videoplayer.view.YMFRenderImage;
import com.yy.videoplayer.view.YMFSurfaceView;
import com.yy.videoplayer.view.YMFVideoPosition;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class YMFPlayerController
implements IYMFDecoderListener {
    private static final String TAG = "YMFPlayerController";
    private static final int DEFAULT_FULL_VIEW_WIDTH = -2;
    private static final int DEFAULT_FULL_VIEW_HEIGHT = -2;
    private Context mContext = null;
    private Handler mUiHandler = new Handler(Looper.getMainLooper());
    private ConcurrentHashMap<Integer, YMFRenderImage> mSeatId2RenderImageMap = new ConcurrentHashMap();
    private View mVideoView = null;
    private VideoConstant.ScaleMode mScaleMode = null;
    private VideoConstant.MirrorMode mMirrorMode = null;
    private YMFRenderImage mYMFRenderImage = null;
    private Bitmap mBackGroundBitmap = null;
    private YMFVideoPosition mBackGroundPosition = new YMFVideoPosition();
    private YMFVideoPosition mOriginBackGroundPosition = new YMFVideoPosition();
    private byte[] mTmpBuffer = null;
    private AtomicBoolean mDataArrive = new AtomicBoolean(false);
    private ReentrantLock mRenderLock = new ReentrantLock(true);
    private YMFLayoutParams mYMFLayoutParams = null;
    private YMFPlayerControlProxy playerControlProxy = null;
    private IViewNotify mViewNotify = null;
    private int mTotalVideoCnt = 0;
    private AtomicBoolean mHardDirectRenderMode = new AtomicBoolean(false);
    private HashMap<Long, Integer> mViewStateMap = new HashMap();
    private HashMap<Long, Long> mDecodeLastTimeStampMap = new HashMap();
    private AtomicInteger mLinkedCnt = new AtomicInteger(0);
    private int mSurfaceWidth = 0;
    private int mSurfaceHeight = 0;
    private boolean mUseTextureView = false;

    public YMFPlayerController(Context context) {
        this.mContext = context;
        this.mYMFRenderImage = new YMFRenderImage();
        this.mYMFRenderImage.mDecodeImage = new YMFImageBuffer(32, 32, 2, false);
        this.mYMFRenderImage.mVideoMode = VideoConstant.VideoViewMode.SingeMode;
        this.mSeatId2RenderImageMap.put(0, this.mYMFRenderImage);
        this.playerControlProxy = new YMFPlayerControlProxy(this);
        this.setViewNotify(new ViewChangedNotify());
    }

    public void setUseTextureView(boolean isUseTextureView) {
        YMFLog.info(this, "[Api     ]", "setUseTextureView," + isUseTextureView);
        this.mUseTextureView = isUseTextureView;
    }

    private void initParams(YMFLayoutParams params) {
        if (params == null) {
            return;
        }
        this.mYMFLayoutParams = params;
        if (this.mTotalVideoCnt == 0 || this.mSeatId2RenderImageMap.size() == 0) {
            for (int i = 0; i < params.mTotalVideoCnt; ++i) {
                YMFRenderImage image = new YMFRenderImage();
                image.mDecodeImage = new YMFImageBuffer(32, 32, 2, false);
                image.mVideoMode = VideoConstant.VideoViewMode.MultiMode;
                YMFLog.info(this, "[Render  ]", "initParams MultiMode");
                YMFLayoutParams.clonePosition(params.mDrawPosition[i], image.mDrawPosition);
                YMFLayoutParams.clonePosition(params.mDrawPosition[i], image.mOriginPosition);
                image.mSurfaceHeight = this.mSurfaceHeight;
                image.mSurfaceWidth = this.mSurfaceWidth;
                this.mSeatId2RenderImageMap.put(i, image);
            }
            this.mTotalVideoCnt = params.mTotalVideoCnt;
            YMFLog.info(this, "[Render  ]", "initParams " + this.mTotalVideoCnt);
        } else if (this.mTotalVideoCnt < params.mTotalVideoCnt) {
            int i;
            for (i = this.mTotalVideoCnt; i < params.mTotalVideoCnt; ++i) {
                YMFRenderImage image = new YMFRenderImage();
                image.mDecodeImage = new YMFImageBuffer(32, 32, 2, false);
                image.mRenderPrepared = false;
                image.mStreamId = 0L;
                image.mSurfaceHeight = this.mSurfaceHeight;
                image.mSurfaceWidth = this.mSurfaceWidth;
                this.mSeatId2RenderImageMap.put(i, image);
            }
            this.mTotalVideoCnt = params.mTotalVideoCnt;
            for (i = 0; i < params.mTotalVideoCnt; ++i) {
                YMFRenderImage renderImage = this.mSeatId2RenderImageMap.get(i);
                renderImage.mVideoMode = VideoConstant.VideoViewMode.MultiMode;
                YMFLayoutParams.clonePosition(params.mDrawPosition[i], renderImage.mDrawPosition);
                YMFLayoutParams.clonePosition(params.mDrawPosition[i], renderImage.mOriginPosition);
            }
        } else if (this.mTotalVideoCnt > params.mTotalVideoCnt) {
            int i;
            for (i = params.mTotalVideoCnt; i < this.mTotalVideoCnt; ++i) {
                if (this.mSeatId2RenderImageMap.get(i) != null) {
                    if (this.mSeatId2RenderImageMap.get((Object)Integer.valueOf((int)i)).mDecodeImage != null) {
                        this.mSeatId2RenderImageMap.get((Object)Integer.valueOf((int)i)).mDecodeImage.mData = null;
                    }
                    this.mSeatId2RenderImageMap.get((Object)Integer.valueOf((int)i)).mDecodeImage = null;
                }
                this.mSeatId2RenderImageMap.remove(i);
            }
            this.mTotalVideoCnt = params.mTotalVideoCnt;
            for (i = 0; i < params.mTotalVideoCnt; ++i) {
                YMFRenderImage renderImage = this.mSeatId2RenderImageMap.get(i);
                YMFLayoutParams.clonePosition(params.mDrawPosition[i], renderImage.mDrawPosition);
                YMFLayoutParams.clonePosition(params.mDrawPosition[i], renderImage.mOriginPosition);
                renderImage.mStreamId = 0L;
                renderImage.mRenderPrepared = false;
            }
        } else if (params.mTotalVideoCnt != 0 && this.mTotalVideoCnt == params.mTotalVideoCnt) {
            for (int i = 0; i < params.mTotalVideoCnt; ++i) {
                YMFRenderImage renderImage = this.mSeatId2RenderImageMap.get(i);
                YMFLayoutParams.clonePosition(params.mDrawPosition[i], renderImage.mDrawPosition);
                YMFLayoutParams.clonePosition(params.mDrawPosition[i], renderImage.mOriginPosition);
            }
        }
        this.mBackGroundBitmap = params.background;
        this.mBackGroundPosition = new YMFVideoPosition();
        this.mOriginBackGroundPosition = new YMFVideoPosition();
        if (this.mBackGroundBitmap != null) {
            YMFLayoutParams.clonePosition(params.backgroudPosition, this.mBackGroundPosition);
            YMFLayoutParams.clonePosition(params.backgroudPosition, this.mOriginBackGroundPosition);
        }
    }

    private void updateViewRenderMode() {
        if (this.mSeatId2RenderImageMap == null) {
            return;
        }
        if (this.mSeatId2RenderImageMap.size() == 1 && this.mSeatId2RenderImageMap.get((Object)Integer.valueOf((int)0)).mVideoMode == VideoConstant.VideoViewMode.SingeMode) {
            if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
                ((YMFPlayerView)this.mVideoView).forceReDraw();
            }
            if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView) {
                ((YMFPlayerTextureView)this.mVideoView).forceReDraw();
            }
        }
        if (this.mSeatId2RenderImageMap.size() > 1) {
            for (Map.Entry<Integer, YMFRenderImage> entry : this.mSeatId2RenderImageMap.entrySet()) {
                YMFRenderImage image = entry.getValue();
                image.mVideoMode = VideoConstant.VideoViewMode.MultiMode;
            }
        }
    }

    public int setViewLayout(YMFLayoutParams params) {
        this.mRenderLock.lock();
        if (params != null) {
            this.initParams(params);
        }
        int surfaceWidth = 0;
        int surfaceHeight = 0;
        if (this.mSeatId2RenderImageMap != null && this.mSeatId2RenderImageMap.size() > 0) {
            surfaceWidth = this.mSeatId2RenderImageMap.get((Object)Integer.valueOf((int)0)).mSurfaceWidth;
            surfaceHeight = this.mSeatId2RenderImageMap.get((Object)Integer.valueOf((int)0)).mSurfaceHeight;
        }
        if (surfaceWidth != 0 && surfaceHeight != 0) {
            this.updateVideoLayout(surfaceWidth, surfaceHeight);
        }
        if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
            ((YMFPlayerView)this.mVideoView).forceReDraw();
            ((YMFPlayerView)this.mVideoView).setRenderControlByChoreographer();
        }
        if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView) {
            ((YMFPlayerTextureView)this.mVideoView).forceReDraw();
            ((YMFPlayerTextureView)this.mVideoView).setRenderControlByChoreographer();
        }
        this.mRenderLock.unlock();
        return 0;
    }

    private void registerDecoderListener() {
        YMFStreamManager.instance().registerListener(this);
    }

    private void unRegisterDecoderListener() {
        YMFStreamManager.instance().unregisterListener(this);
    }

    public YMFRenderImage findRenderImageByStreamId(long streamId) {
        if (this.mSeatId2RenderImageMap != null) {
            for (Map.Entry<Integer, YMFRenderImage> entry : this.mSeatId2RenderImageMap.entrySet()) {
                YMFRenderImage image = entry.getValue();
                if (image.mStreamId != streamId) continue;
                return image;
            }
        }
        return null;
    }

    private YMFRenderImage findRenderImageBySeatIndex(int index) {
        YMFRenderImage renderImage;
        if (this.mSeatId2RenderImageMap != null && (renderImage = this.mSeatId2RenderImageMap.get(index)) != null) {
            return renderImage;
        }
        return null;
    }

    private void createVideoViewUI() {
        final CountDownLatch barrier = new CountDownLatch(1);
        this.mUiHandler.post(new Runnable(){

            @Override
            public void run() {
                YMFPlayerController.this.createVideoView();
                barrier.countDown();
            }
        });
        try {
            barrier.await();
        }
        catch (InterruptedException e) {
            YMFLog.error((Object)this, "[Render  ]", "postToUiThread barrier.await" + e.toString());
        }
    }

    private void checkSwitchDirectRenderMode(long streamId, YMFImageBuffer image) {
        if (image.mHardware && image.mDirectHardRender && !this.mHardDirectRenderMode.get()) {
            if (this.mViewNotify == null) {
                return;
            }
            this.mHardDirectRenderMode.set(true);
            ViewParent parent = null;
            YMFLog.info(this, "[Render  ]", "set hardDirectRenderMode:");
            if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
                YMFLog.info(this, "[Render  ]", "rePrepare view, src:" + this.mVideoView);
                this.unLinkStream(streamId);
                parent = this.mVideoView.getParent();
                this.createVideoViewUI();
            } else if (this.mVideoView == null) {
                return;
            }
            if (this.mViewNotify != null) {
                YMFLog.info(this, "[Render  ]", "onViewChangedNotify, dst" + this.mVideoView);
                try {
                    this.mViewNotify.onViewChangedNotify(parent, this.mVideoView);
                    this.linkStream(streamId);
                    this.setScaleMode(this.mScaleMode);
                }
                catch (Exception e) {
                    YMFLog.error((Object)this, "[Render  ]", "checkSwitchDirectRenderMode\uff1a " + e.toString());
                    return;
                }
            }
        } else if (!image.mDirectHardRender && this.mHardDirectRenderMode.get()) {
            this.mHardDirectRenderMode.set(false);
        }
    }

    @Override
    public void onDecodeStreamStart(long streamId, YMFImageBuffer image) {
    }

    @Override
    public void onDecodeStreamEnd(long streamId, YMFImageBuffer image) {
        YMFRenderImage renderImage = this.findRenderImageByStreamId(streamId);
        if (renderImage == null) {
            return;
        }
        if (renderImage.mDecodeImage != null) {
            renderImage.mDecodeImage.assignWithoutBuffer(image);
        }
    }

    @Override
    public void onDecodedFrameAvailable(long streamId, YMFImageBuffer image) {
        this.checkSwitchDirectRenderMode(streamId, image);
        if (this.mHardDirectRenderMode.get()) {
            return;
        }
        YMFRenderImage renderImage = this.findRenderImageByStreamId(streamId);
        if (renderImage == null) {
            return;
        }
        this.updateStreamDeltaPts(streamId, image);
        this.processMediaSample(renderImage, image);
    }

    public void setLastFrameRenderBlack(boolean isBlack) {
        if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
            ((YMFPlayerView)this.mVideoView).setLastFrameRenderBlack(isBlack);
        }
        if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView) {
            ((YMFPlayerTextureView)this.mVideoView).setLastFrameRenderBlack(isBlack);
        }
    }

    private void updateStreamDeltaPts(long streamId, YMFImageBuffer image) {
        if (this.mDecodeLastTimeStampMap != null && image != null) {
            if (!this.mDecodeLastTimeStampMap.containsKey(streamId)) {
                this.mDecodeLastTimeStampMap.put(streamId, image.mPts);
                return;
            }
            if (this.mDecodeLastTimeStampMap.containsKey(streamId)) {
                image.mDeltaPts = image.mPts - this.mDecodeLastTimeStampMap.get(streamId);
                this.mDecodeLastTimeStampMap.put(streamId, image.mPts);
            }
        }
    }

    private boolean prepareView() {
        this.mRenderLock.lock();
        if (this.mUseTextureView) {
            this.mVideoView = new YMFPlayerTextureView(this.mContext, null, this.playerControlProxy);
            YMFLog.info(this, "[Render  ]", "createView YMFPlayerTextureView:" + this.mVideoView);
        } else if (this.mHardDirectRenderMode.get()) {
            this.mVideoView = new YMFSurfaceView(this.mContext);
            YMFLog.info(this, "[Render  ]", "createView YMFSurfaceView:" + this.mVideoView);
        } else {
            this.mVideoView = new YMFPlayerView(this.mContext, null, this.playerControlProxy);
            YMFLog.info(this, "[Render  ]", "createView YMFPlayerView:" + this.mVideoView);
        }
        this.mRenderLock.unlock();
        return true;
    }

    public View createVideoView() {
        this.destroyVideoView();
        this.prepareView();
        return this.mVideoView;
    }

    @Deprecated
    public void destroyVideoView() {
        this.mRenderLock.lock();
        YMFLog.info(this, "[Render  ]", "destroyVideoView." + this.mVideoView);
        if (this.mVideoView != null) {
            if (this.mVideoView instanceof YMFSurfaceView) {
                ((YMFSurfaceView)this.mVideoView).release();
            } else if (this.mVideoView instanceof YMFPlayerView) {
                ((YMFPlayerView)this.mVideoView).release();
            } else if (this.mVideoView instanceof YMFPlayerTextureView) {
                ((YMFPlayerTextureView)this.mVideoView).release();
            }
            this.mVideoView = null;
        }
        this.mRenderLock.unlock();
    }

    public int setScaleMode(VideoConstant.ScaleMode scaleMode) {
        if (!this.mHardDirectRenderMode.get()) {
            YMFRenderImage renderImage = this.findRenderImageBySeatIndex(0);
            if (renderImage != null && renderImage.mScaleMode != scaleMode) {
                renderImage.mScaleMode = scaleMode;
                this.mRenderLock.lock();
                this.updateVideoSize(renderImage);
                this.mRenderLock.unlock();
                this.updateViewRenderMode();
            }
        } else if (this.mVideoView instanceof YMFSurfaceView) {
            ((YMFSurfaceView)this.mVideoView).setScaleMode(scaleMode);
        }
        this.mScaleMode = scaleMode;
        YMFLog.info(this, "[PlayView]", "setScaleMode:" + (Object)((Object)scaleMode));
        return 0;
    }

    public VideoConstant.ScaleMode getScaleMode() {
        return this.mScaleMode;
    }

    public int setScaleMode(VideoConstant.ScaleMode scaleMode, int videoIndex) {
        YMFRenderImage renderImage = this.findRenderImageBySeatIndex(videoIndex);
        if (renderImage != null) {
            renderImage.mScaleMode = scaleMode;
            this.mRenderLock.lock();
            this.updateVideoSize(renderImage);
            this.mRenderLock.unlock();
        }
        YMFLog.info(this, "[PlayView]", "setScaleMode  videoIndex" + videoIndex + " scaleMode " + (Object)((Object)scaleMode));
        return 0;
    }

    public VideoConstant.ScaleMode getScaleMode(int videoIndex) {
        YMFRenderImage renderImage = this.findRenderImageBySeatIndex(videoIndex);
        if (renderImage != null) {
            return renderImage.mScaleMode;
        }
        return VideoConstant.ScaleMode.AspectFit;
    }

    public int setMirrorMode(VideoConstant.MirrorMode mirrorMode, int videoIndex) {
        YMFRenderImage renderImage = this.findRenderImageBySeatIndex(videoIndex);
        if (renderImage != null) {
            renderImage.mMirrorMode = mirrorMode;
        }
        this.mMirrorMode = mirrorMode;
        YMFLog.info(this, "[PlayView]", "setMirrorMode:" + (Object)((Object)mirrorMode) + " videoIndex:" + videoIndex);
        return 0;
    }

    public VideoConstant.MirrorMode getMirrorMode(int videoIndex) {
        YMFRenderImage renderImage = this.findRenderImageBySeatIndex(videoIndex);
        if (renderImage != null) {
            return renderImage.mMirrorMode;
        }
        return VideoConstant.MirrorMode.Disabled;
    }

    @Deprecated
    public void release() {
        this.mRenderLock.lock();
        for (Map.Entry<Integer, YMFRenderImage> entry : this.mSeatId2RenderImageMap.entrySet()) {
            YMFRenderImage renderImage = entry.getValue();
            if (renderImage == null) continue;
            if (renderImage.mDecodeImage != null) {
                renderImage.mDecodeImage.mData = null;
            }
            renderImage.mDecodeImage = null;
        }
        this.mSeatId2RenderImageMap.clear();
        this.mViewStateMap.clear();
        this.mDecodeLastTimeStampMap.clear();
        this.mTotalVideoCnt = 0;
        if (this.mBackGroundBitmap != null) {
            this.mBackGroundBitmap = null;
        }
        this.mRenderLock.unlock();
    }

    public int switchDualVideoView(long oldStreamId, long newStreamId, int seatId) {
        YMFRenderImage renderImage;
        YMFLog.info(this, "[Render  ]", "switchDualVideoView unLinkStream, streamId" + oldStreamId + ",cnt:" + this.mLinkedCnt.get());
        this.mRenderLock.lock();
        if (this.mVideoView instanceof YMFSurfaceView) {
            ((YMFSurfaceView)this.mVideoView).unLinkFromStream(oldStreamId);
        } else {
            renderImage = this.findRenderImageByStreamId(oldStreamId);
            if (renderImage != null) {
                renderImage.mStreamId = 0L;
                renderImage.mRenderPrepared = false;
            }
        }
        renderImage = this.findRenderImageBySeatIndex(seatId);
        if (renderImage != null) {
            renderImage.mStreamId = newStreamId;
            renderImage.mRenderPrepared = true;
        }
        this.mRenderLock.unlock();
        YMFLog.info(this, "[Render  ]", "switchDualVideoView LinkStream, streamId" + newStreamId + ",cnt:" + this.mLinkedCnt.get());
        this.notifyViewStateChange(oldStreamId, 1);
        this.notifyRenderUnlinkEvent(oldStreamId);
        this.notifyViewStateChange(newStreamId, 0);
        this.notifyRenderLinkEvent(newStreamId);
        return 0;
    }

    public int linkStream(long streamId, int videoIndex) {
        YMFRenderImage renderImage;
        if (streamId == 0L) {
            return -1;
        }
        if (videoIndex < 0) {
            return -1;
        }
        this.mLinkedCnt.getAndIncrement();
        this.registerDecoderListener();
        YMFLog.info(this, "[Render  ]", "linkStream, streamId" + streamId + " videoIndex:" + videoIndex + ",cnt:" + this.mLinkedCnt.get());
        this.mRenderLock.lock();
        YMFRenderImage oldRenderImage = this.findRenderImageByStreamId(streamId);
        if (oldRenderImage != null) {
            oldRenderImage.mStreamId = 0L;
            oldRenderImage.mRenderPrepared = false;
        }
        if ((renderImage = this.findRenderImageBySeatIndex(videoIndex)) != null) {
            renderImage.mStreamId = streamId;
            renderImage.mRenderPrepared = true;
        }
        this.notifyViewStateChange(streamId, 0);
        this.mRenderLock.unlock();
        this.notifyRenderLinkEvent(streamId);
        return 0;
    }

    public int unLinkStream(long streamId, int videoIndex) {
        if (streamId == 0L) {
            return -1;
        }
        if (videoIndex < 0) {
            return -1;
        }
        this.mLinkedCnt.getAndDecrement();
        YMFLog.info(this, "[Render  ]", "unLinkStream, streamId" + streamId + " videoIndex:" + videoIndex + ",cnt:" + this.mLinkedCnt.get());
        if (this.mLinkedCnt.get() == 0) {
            this.unRegisterDecoderListener();
        }
        this.mRenderLock.lock();
        YMFRenderImage renderImage = this.findRenderImageBySeatIndex(videoIndex);
        if (renderImage != null) {
            renderImage.mStreamId = 0L;
            renderImage.mRenderPrepared = false;
            renderImage.mDecodeImage.mData = null;
            if (renderImage.mDecodeImage != null) {
                renderImage.mDecodeImage.mStreamStart = false;
            }
        }
        this.notifyViewStateChange(streamId, 1);
        this.mRenderLock.unlock();
        if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
            ((YMFPlayerView)this.mVideoView).forceReDraw();
        }
        if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView) {
            ((YMFPlayerTextureView)this.mVideoView).forceReDraw();
        }
        this.notifyRenderUnlinkEvent(streamId);
        return 0;
    }

    public int linkStream(long streamId) {
        if (streamId == 0L) {
            return -1;
        }
        this.mLinkedCnt.getAndIncrement();
        this.registerDecoderListener();
        YMFLog.info(this, "[Render  ]", "linkStream, streamId" + streamId + ",cnt:" + this.mLinkedCnt.get());
        this.mRenderLock.lock();
        if (this.mVideoView instanceof YMFSurfaceView) {
            ((YMFSurfaceView)this.mVideoView).linkToStream(streamId);
        } else {
            YMFRenderImage renderImage = this.findRenderImageBySeatIndex(0);
            if (renderImage != null) {
                renderImage.mStreamId = streamId;
                renderImage.mRenderPrepared = true;
            }
        }
        this.notifyViewStateChange(streamId, 0);
        this.mRenderLock.unlock();
        this.notifyRenderLinkEvent(streamId);
        return 0;
    }

    public int unLinkStream(long streamId) {
        if (streamId == 0L) {
            return -1;
        }
        this.mLinkedCnt.getAndDecrement();
        this.unRegisterDecoderListener();
        YMFLog.info(this, "[Render  ]", "unLinkStream, streamId" + streamId + ",cnt:" + this.mLinkedCnt.get());
        if (this.mLinkedCnt.get() == 0) {
            this.unRegisterDecoderListener();
        }
        this.mRenderLock.lock();
        if (this.mVideoView instanceof YMFSurfaceView) {
            ((YMFSurfaceView)this.mVideoView).unLinkFromStream(streamId);
        } else {
            YMFRenderImage renderImage = this.findRenderImageByStreamId(streamId);
            if (renderImage != null) {
                renderImage.mStreamId = 0L;
                renderImage.mRenderPrepared = false;
                renderImage.mDecodeImage.mData = null;
            }
        }
        this.notifyViewStateChange(streamId, 1);
        this.mRenderLock.unlock();
        if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
            ((YMFPlayerView)this.mVideoView).forceReDraw();
        }
        if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView) {
            ((YMFPlayerTextureView)this.mVideoView).forceReDraw();
        }
        this.notifyRenderUnlinkEvent(streamId);
        return 0;
    }

    private void notifyViewStateChange(long streamId, int viewState) {
        if (this.mViewStateMap.get(streamId) != null && this.mViewStateMap.get(streamId) == viewState) {
            return;
        }
        this.mViewStateMap.put(streamId, viewState);
        if (viewState == 0) {
            if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
                ((YMFPlayerView)this.mVideoView).setIgnoreStatistic(streamId);
            }
            if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView) {
                ((YMFPlayerTextureView)this.mVideoView).setIgnoreStatistic(streamId);
            }
        }
        YYVideoLibMgr.instance().onViewStateNotify(streamId, viewState);
    }

    private void notifyRenderUnlinkEvent(long streamId) {
        StateMonitor.NotifyClearPts(streamId);
        StateMonitor.instance().NotifyRemoveView(streamId);
        StateMonitor.NotifyReleaseRender(streamId);
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewLinkStream(0, streamId, false);
    }

    private void notifyRenderLinkEvent(long streamId) {
        StateMonitor.NotifyCreateRender(streamId, 4);
        StateMonitor.instance().NotifyAddView(streamId, 0, VideoConstant.ViewType.GL_VIDEO_VIEW_GLSURFACE, TAG);
        YMFPlayerUsrBehaviorStat.getInstance().notifyPlayerViewLinkStream(0, streamId, true);
    }

    public Bitmap getVideoScreenshotByStreamID(long streamId) {
        try {
            YMFRenderImage renderImage = this.findRenderImageByStreamId(streamId);
            if (renderImage != null) {
                return this.getBitmap(renderImage);
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[PlayView]", "getScrennShotByStreamID exception:" + e.getMessage());
        }
        return null;
    }

    public Bitmap getVideoScreenshotExt(int videoIndex) {
        try {
            YMFRenderImage renderImage = this.findRenderImageBySeatIndex(videoIndex);
            if (renderImage != null) {
                return this.getBitmap(renderImage);
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[PlayView]", "getScrennShot exception:" + e.getMessage());
        }
        return null;
    }

    public Bitmap getVideoScreenshot() {
        try {
            YMFRenderImage renderImage = this.findRenderImageBySeatIndex(0);
            if (renderImage != null) {
                return this.getBitmap(renderImage);
            }
        }
        catch (Exception e) {
            YMFLog.error((Object)this, "[PlayView]", "getScrennShot exception:" + e.getMessage());
        }
        return null;
    }

    private Bitmap getBitmap(YMFRenderImage renderImage) {
        YMFImageBuffer imageBuffer = renderImage.mDecodeImage;
        Bitmap bmp = null;
        if (imageBuffer != null) {
            try {
                this.mRenderLock.lock();
                byte[] yuv = new byte[imageBuffer.mBufSize];
                byte[] argb = new byte[imageBuffer.mWidth * imageBuffer.mHeight * 4];
                imageBuffer.mData.rewind();
                imageBuffer.mData.get(yuv, 0, imageBuffer.mBufSize);
                YMFLog.info(this, "[PlayView]", "Format:" + renderImage.mDecodeImage.mFormat + "getBitmap renderImage.mVideoWidth:" + renderImage.mVideoWidth + " renderImage.mVideoWidth;" + renderImage.mVideoHeight + " imageBuffer.mWidth;" + imageBuffer.mWidth + " imageBuffer.mHeight:" + imageBuffer.mHeight);
                switch (renderImage.mDecodeImage.mFormat) {
                    case 1: {
                        ImageUtil.NV12ToARGB(yuv, imageBuffer.mWidth, imageBuffer.mHeight, argb, false);
                        break;
                    }
                    case 0: {
                        ImageUtil.NV21ToARGB(yuv, imageBuffer.mWidth, imageBuffer.mHeight, argb, false);
                        break;
                    }
                    case 3: {
                        ImageUtil.YV12ToARGB(yuv, imageBuffer.mWidth, imageBuffer.mHeight, argb, false);
                        break;
                    }
                    case 2: {
                        ImageUtil.I420ToARGB(yuv, imageBuffer.mWidth, imageBuffer.mHeight, argb, false);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                bmp = Bitmap.createBitmap((int)renderImage.mVideoWidth, (int)renderImage.mVideoHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                bmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(argb));
                this.mRenderLock.unlock();
            }
            catch (Exception e) {
                this.mRenderLock.unlock();
                YMFLog.error((Object)this, "[Render  ]", " getBitmap failed,e:" + e.fillInStackTrace());
            }
            return bmp;
        }
        return null;
    }

    private void updateVideoSize(YMFRenderImage renderImage) {
        if (renderImage != null) {
            renderImage.mVideoSize = renderImage.mVideoMode == VideoConstant.VideoViewMode.MultiMode ? VideoSizeUtils.calcVideoSize(renderImage.mDrawPosition.mX, renderImage.mDrawPosition.mY, renderImage.mDrawPosition.mWidth, renderImage.mDrawPosition.mHeight) : VideoSizeUtils.CalcFitSize(renderImage.mVideoWidth, renderImage.mVideoHeight, renderImage.mSurfaceWidth, renderImage.mSurfaceHeight, renderImage.mScaleMode);
            if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
                ((YMFPlayerView)this.mVideoView).forceReDraw();
            }
            if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView) {
                ((YMFPlayerTextureView)this.mVideoView).forceReDraw();
            }
        }
    }

    private void checkSizeUpdate(YMFRenderImage renderImage, int width, int height) {
        if (renderImage != null && (renderImage.mVideoWidth != width || renderImage.mVideoHeight != height)) {
            renderImage.mVideoWidth = width;
            renderImage.mVideoHeight = height;
            this.updateVideoSize(renderImage);
            YMFLog.info(this, "[PlayView]", "checkSizeUpdate video width:" + width + " height:" + height);
        }
    }

    private void copyDecodeBuffer(YMFRenderImage renderImage, YMFImageBuffer image) {
        if (renderImage.mDecodeImage == null || renderImage.mDecodeImage.mWidth != image.mWidth || renderImage.mDecodeImage.mHeight != image.mHeight || renderImage.mDecodeImage.mFormat != image.mFormat || renderImage.mDecodeImage.mData == null) {
            renderImage.mDecodeImage = new YMFImageBuffer(image.mWidth, image.mHeight, image.mFormat, true);
        }
        if (this.mTmpBuffer == null || this.mTmpBuffer.length != image.mWidth * image.mHeight * 3 / 2) {
            this.mTmpBuffer = new byte[image.mWidth * image.mHeight * 3 / 2];
        }
        if (image.mData.hasArray() && renderImage.mDecodeImage.mData.hasArray()) {
            System.arraycopy(image.mData.array(), image.mData.arrayOffset(), renderImage.mDecodeImage.mData.array(), renderImage.mDecodeImage.mData.arrayOffset(), image.mBufSize);
        } else {
            image.mData.rewind();
            if (image.mData.remaining() < this.mTmpBuffer.length) {
                YMFLog.error((Object)this, "[PlayView]", "copyHardwareBuffer " + image.mData.remaining() + " != " + this.mTmpBuffer.length + "," + image.mWidth + "x" + image.mHeight);
            }
            image.mData.get(this.mTmpBuffer);
            renderImage.mDecodeImage.mData.rewind();
            renderImage.mDecodeImage.mData.put(this.mTmpBuffer);
        }
        renderImage.mDecodeImage.mHardware = image.mHardware;
        renderImage.mDecodeImage.mStreamId = image.mStreamId;
        renderImage.mDecodeImage.mDts = image.mDts;
        renderImage.mDecodeImage.mPts = image.mPts;
        renderImage.mDecodeImage.mDeltaPts = image.mDeltaPts;
        renderImage.mDecodeImage.mCropRight = image.mCropRight;
        renderImage.mDecodeImage.mCropBottom = image.mCropBottom;
        renderImage.mDecodeImage.mCropTop = image.mCropTop;
        renderImage.mDecodeImage.mCropLeft = image.mCropLeft;
        renderImage.mDecodeImage.mStreamStart = image.mStreamStart;
        renderImage.mDecodeImage.mNeedRendered = image.mNeedRendered;
        renderImage.mDecodeImage.mSsrc = image.mSsrc;
        renderImage.mDecodeImage.mNotifyRenderInfo = image.mNotifyRenderInfo;
        renderImage.mDecodeImage.mIgnore = image.mIgnore;
        renderImage.mDecodeImage.mClipWindow = image.mClipWindow;
        renderImage.mDecodeImage.mChangeRenderMode = image.mChangeRenderMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(api=16)
    public boolean processMediaSample(YMFRenderImage renderImage, YMFImageBuffer srcImage) {
        if (renderImage != null) {
            try {
                this.mRenderLock.lock();
                this.copyDecodeBuffer(renderImage, srcImage);
                this.checkSizeUpdate(renderImage, srcImage.mCropRight - srcImage.mCropLeft + 1, srcImage.mCropBottom - srcImage.mCropTop + 1);
                if (renderImage.mVideoMode == VideoConstant.VideoViewMode.SingeMode) {
                    this.mDataArrive.set(true);
                    if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView && renderImage.mDecodeImage.mNeedRendered) {
                        ((YMFPlayerView)this.mVideoView).requestGlRender();
                    }
                    if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView && renderImage.mDecodeImage.mNeedRendered) {
                        ((YMFPlayerTextureView)this.mVideoView).requestGlRender();
                    }
                } else {
                    if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerView) {
                        if (this.mSeatId2RenderImageMap.size() > 1) {
                            ((YMFPlayerView)this.mVideoView).setRenderControlByChoreographer();
                        } else {
                            ((YMFPlayerView)this.mVideoView).requestGlRender();
                        }
                    }
                    if (this.mVideoView != null && this.mVideoView instanceof YMFPlayerTextureView) {
                        if (this.mSeatId2RenderImageMap.size() > 1) {
                            ((YMFPlayerTextureView)this.mVideoView).setRenderControlByChoreographer();
                        } else {
                            ((YMFPlayerTextureView)this.mVideoView).requestGlRender();
                        }
                    }
                }
            }
            catch (Exception e) {
                YMFLog.error((Object)this, "[PlayView]", e.getMessage() + " processMediaSample " + e.toString());
            }
            finally {
                this.mRenderLock.unlock();
            }
        }
        return true;
    }

    public void updateVideoLayout(int surfaceWidth, int surfaceHeight) {
        YMFLog.info(this, TAG, " updateMultiDrawLayout surface:" + surfaceWidth + "," + surfaceHeight);
        this.mRenderLock.lock();
        this.mSurfaceHeight = surfaceHeight;
        this.mSurfaceWidth = surfaceWidth;
        if (this.mSeatId2RenderImageMap != null && this.mSeatId2RenderImageMap.size() > 0) {
            if (this.mSeatId2RenderImageMap.get((Object)Integer.valueOf((int)0)).mVideoMode == VideoConstant.VideoViewMode.MultiMode) {
                this.updateMultiDrawBackgroundParam(surfaceWidth, surfaceHeight);
            }
            for (Map.Entry<Integer, YMFRenderImage> entry : this.mSeatId2RenderImageMap.entrySet()) {
                YMFRenderImage renderImage = entry.getValue();
                if (renderImage == null) continue;
                renderImage.mSurfaceWidth = surfaceWidth;
                renderImage.mSurfaceHeight = surfaceHeight;
                if (renderImage.mVideoMode == VideoConstant.VideoViewMode.MultiMode) {
                    this.updateMultiDrawLayout(renderImage);
                }
                this.updateVideoSize(renderImage);
                YMFLog.info(this, TAG, " updateMultiDrawLayout :" + renderImage.toString());
            }
        }
        this.mRenderLock.unlock();
    }

    public View getVideoView() {
        return this.mVideoView;
    }

    private void updateMultiDrawLayout(YMFRenderImage renderImage) {
        if (renderImage == null) {
            return;
        }
        if (renderImage.mOriginPosition.mWidth == -2 && renderImage.mOriginPosition.mHeight == -2) {
            renderImage.mDrawPosition.mX = 0;
            renderImage.mDrawPosition.mY = 0;
            renderImage.mDrawPosition.mWidth = renderImage.mSurfaceWidth;
            renderImage.mDrawPosition.mHeight = renderImage.mSurfaceHeight;
        } else {
            renderImage.mDrawPosition.mX = renderImage.mOriginPosition.mX;
            renderImage.mDrawPosition.mY = renderImage.mSurfaceHeight - renderImage.mOriginPosition.mY - renderImage.mOriginPosition.mHeight;
            renderImage.mDrawPosition.mWidth = renderImage.mOriginPosition.mWidth;
            renderImage.mDrawPosition.mHeight = renderImage.mOriginPosition.mHeight;
        }
        if (this.mBackGroundPosition != null) {
            YMFLayoutParams.clonePosition(this.mBackGroundPosition, renderImage.mBackGroundPosition);
        }
    }

    private void updateMultiDrawBackgroundParam(int surfaceWidth, int surfaceHeight) {
        this.mBackGroundPosition.mX = this.mOriginBackGroundPosition.mX;
        this.mBackGroundPosition.mY = surfaceHeight - this.mOriginBackGroundPosition.mY - this.mOriginBackGroundPosition.mHeight;
        this.mBackGroundPosition.mHeight = this.mOriginBackGroundPosition.mHeight;
        this.mBackGroundPosition.mWidth = this.mOriginBackGroundPosition.mWidth;
    }

    public void setViewNotify(IViewNotify notify) {
        this.mViewNotify = notify;
    }

    public class ViewChangedNotify
    implements IViewNotify {
        @Override
        public void onViewChangedNotify(Object parent, View newView) {
            if (YMFPlayerController.this.mUiHandler != null && newView != null && parent != null) {
                this.postToUiThread((FrameLayout)parent, newView);
            }
        }

        void postToUiThread(final FrameLayout parent, final View newView) {
            if (Thread.currentThread().getId() == YMFPlayerController.this.mUiHandler.getLooper().getThread().getId()) {
                parent.removeAllViews();
                parent.addView(newView);
            } else {
                final CountDownLatch barrier = new CountDownLatch(1);
                YMFPlayerController.this.mUiHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        parent.removeAllViews();
                        parent.addView(newView);
                        barrier.countDown();
                    }
                });
                try {
                    barrier.await();
                }
                catch (InterruptedException e) {
                    YMFLog.error((Object)this, "[Render  ]", "postToUiThread barrier.await" + e.toString());
                }
            }
        }
    }

    public static interface IViewNotify {
        public void onViewChangedNotify(Object var1, View var2);
    }

    public class YMFPlayerControlProxy {
        private YMFPlayerController mPlayerController = null;

        YMFPlayerControlProxy(YMFPlayerController controller) {
            this.mPlayerController = controller;
        }

        public ReentrantLock getRenderLock() {
            return this.mPlayerController.mRenderLock;
        }

        public AtomicBoolean getDataArriveFlag() {
            return this.mPlayerController.mDataArrive;
        }

        public void setDataArriveFlag() {
            this.mPlayerController.mDataArrive.set(true);
        }

        public ConcurrentHashMap<Integer, YMFRenderImage> getRenderImageMap() {
            return this.mPlayerController.mSeatId2RenderImageMap;
        }

        public Bitmap getBackgroundBitmap() {
            return YMFPlayerController.this.mBackGroundBitmap;
        }

        public void updateVideoLayout(int surfaceWidth, int surfaceHeight) {
            this.mPlayerController.updateVideoLayout(surfaceWidth, surfaceHeight);
        }
    }
}

