/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import android.text.TextUtils;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.yy.videoplayer.utils.FP;
import com.yy.videoplayer.utils.YMFLog;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Vector;

public class StringUtils {
    public static final boolean IGNORE_CASE = true;
    public static final boolean IGNORE_WIDTH = true;
    private static final int SHA1_LENGTH = 40;

    public static boolean isNullOrEmpty(String str) {
        return FP.empty(str);
    }

    public static boolean isAllWhitespaces(String str) {
        boolean ret = true;
        for (int i = 0; i < str.length(); ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public static boolean isAllDigits(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static boolean equal(String s1, String s2) {
        return StringUtils.equal(s1, s2, false);
    }

    public static boolean equal(String s1, String s2, boolean ignoreCase) {
        if (s1 != null && s2 != null) {
            if (ignoreCase) {
                return s1.equalsIgnoreCase(s2);
            }
            return s1.equals(s2);
        }
        return s1 == null && s2 == null;
    }

    public static Vector<String> parseMediaUrls(String str, String beginTag, String endTag) {
        Vector<String> list = new Vector<String>();
        if (!StringUtils.isNullOrEmpty(str)) {
            int beginIndex = str.indexOf(beginTag, 0);
            int endIndex = str.indexOf(endTag, 0);
            while (beginIndex != -1 && endIndex != -1 && endIndex > beginIndex) {
                String imgUrl = str.substring(beginIndex += beginTag.length(), endIndex);
                if (!StringUtils.isNullOrEmpty(imgUrl) && imgUrl.charAt(0) != '[') {
                    list.add(imgUrl);
                }
                endIndex += endIndex + endTag.length();
                beginIndex = str.indexOf(beginTag, endIndex);
                endIndex = str.indexOf(endTag, endIndex);
            }
        }
        return list;
    }

    public static int find(String pattern, String s) {
        return StringUtils.find(pattern, s, false);
    }

    public static int find(String pattern, String s, boolean ignoreCase) {
        return StringUtils.find(pattern, s, ignoreCase, false);
    }

    public static int find(String pattern, String s, boolean ignoreCase, boolean ignoreWidth) {
        if (FP.empty(s)) {
            return -1;
        }
        pattern = FP.ref(pattern);
        if (ignoreCase) {
            pattern = pattern.toLowerCase();
            s = s.toLowerCase();
        }
        if (ignoreWidth) {
            pattern = StringUtils.narrow(pattern);
            s = StringUtils.narrow(s);
        }
        return s.indexOf(pattern);
    }

    public static String narrow(String s) {
        if (FP.empty(s)) {
            return "";
        }
        char[] cs = s.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = StringUtils.narrow(cs[i]);
        }
        return new String(cs);
    }

    public static char narrow(char c) {
        char code = c;
        if (code >= '\uff01' && code <= '\uff5d') {
            return (char)(code - 65248);
        }
        if (code == '\u3000') {
            return (char)(code - 12288 + 32);
        }
        if (code == '\uff61') {
            return '\u3002';
        }
        if (code == '\u30fb') {
            return '\u00b7';
        }
        if (code == '\u2022') {
            return '\u00b7';
        }
        return c;
    }

    public static int ord(char c) {
        if ('a' <= c && c <= 'z') {
            return c;
        }
        if ('A' <= c && c <= 'Z') {
            return c - 65 + 97;
        }
        return 0;
    }

    public static int compare(String x, String y) {
        return FP.ref(x).compareTo(FP.ref(y));
    }

    public static String getHashIfPassIsPlainText(String password) {
        if (!StringUtils.isNullOrEmpty(password) && password.length() < 40) {
            return StringUtils.sha1(password);
        }
        return password;
    }

    public static String sha1(String str) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            byte[] digest = sha1.digest(str.getBytes());
            sb.append(StringUtils.bytesToHexString(digest));
        }
        catch (NoSuchAlgorithmException e) {
            YMFLog.error(null, "[Util    ]", "StringUtils exception:" + e.toString());
        }
        return sb.toString();
    }

    public static String bytesToHexString(byte[] bytes) {
        if (bytes == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            int val = b & 0xFF;
            if (val < 16) {
                sb.append("0");
            }
            sb.append(Integer.toHexString(val));
        }
        return sb.toString();
    }

    public static boolean isValidMobileNumber(String phone) {
        if (phone == null || phone.length() != 11 || !phone.startsWith("1")) {
            return false;
        }
        return StringUtils.isAllDigits(phone);
    }

    public static boolean isNameMatchMobilePattern(String name) {
        return name != null && name.matches("1\\d{10}(y*|s*)");
    }

    public static String getMobileFromName(String name) {
        String mobile;
        YMFLog.debug(null, "[Util    ]", "StringUtil mobile user name:%s", name);
        if (name == null) {
            return "";
        }
        if (name.startsWith("1") && name.length() >= 11 && StringUtils.isValidMobileNumber(mobile = name.substring(0, 11))) {
            return mobile;
        }
        return "";
    }

    public static boolean isIpv4Addr(String addr) {
        return addr != null && addr.matches("(\\d{1,3}\\.){3}\\d{1,3}");
    }

    public static <A, B> String fromPair(Pair<A, B> p) {
        return p.first + ":" + p.second;
    }

    public static <A, B> String join(CharSequence delim, List<Pair<A, B>> xs) {
        return TextUtils.join((CharSequence)delim, FP.map(new FP.UnaryFunc<String, Pair<A, B>>(){

            @Override
            public String apply(Pair<A, B> p) {
                return StringUtils.fromPair(p);
            }
        }, xs));
    }

    public static <E> String join(CharSequence delim, SparseArray<E> xs) {
        return StringUtils.join(delim, FP.toList(xs));
    }

    public static String join(CharSequence delim, SparseIntArray xs) {
        return StringUtils.join(delim, FP.toList(xs));
    }
}

