/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.utils;

import java.nio.ByteBuffer;

public class ByteVector {
    private static final float s_growRation = 1.3f;
    private int mSize = 0;
    private byte[] mBytes = null;

    public ByteVector(int size) {
        this.reserve(size);
    }

    private int remaining() {
        if (this.mBytes == null) {
            return 0;
        }
        return this.mBytes.length - this.mSize;
    }

    public void reserve(int len) {
        if (len <= 0) {
            return;
        }
        int remain = this.remaining();
        if (remain < len || this.mBytes == null) {
            int realLen = (int)(1.3f * (float)len + (float)this.mSize);
            byte[] tmp = new byte[realLen];
            if (this.mSize > 0 && this.mBytes != null) {
                System.arraycopy(this.mBytes, 0, tmp, 0, this.mSize);
            }
            this.mBytes = tmp;
        }
    }

    public byte[] getBytes() {
        return this.mBytes;
    }

    public int size() {
        return this.mSize;
    }

    public void put(ByteBuffer buffer, int len) {
        if (buffer == null || len <= 0) {
            return;
        }
        int cnt = buffer.remaining() > len ? len : buffer.remaining();
        this.reserve(this.mSize + cnt);
        buffer.get(this.mBytes, this.mSize, cnt);
        this.mSize += cnt;
    }

    public void clear() {
        this.mSize = 0;
    }

    public void release() {
        this.mSize = 0;
        this.mBytes = null;
    }
}

