/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.stat;

import com.yy.videoplayer.stat.IYMFBehaviorEventListener;
import com.yy.videoplayer.utils.YMFLog;

public class YMFPlayerUsrBehaviorStat {
    private static YMFPlayerUsrBehaviorStat mInstance;
    private String tag = "YMFPlay";
    public IYMFBehaviorEventListener mBehaviorListener = null;

    public static YMFPlayerUsrBehaviorStat getInstance() {
        if (mInstance == null) {
            mInstance = new YMFPlayerUsrBehaviorStat();
        }
        return mInstance;
    }

    public void setYMFBehaviorEventListener(IYMFBehaviorEventListener listener) {
        this.mBehaviorListener = listener;
    }

    public void notifyVideoDecoderIdState(long streamId, int decoderType, boolean state) {
        YMFLog.info(this, "[Decoder ]", "upload usrBehavior notifyVideoDecoderIdState, streamId:" + streamId + " decoderType:" + decoderType + " state:" + state);
        if (this.mBehaviorListener != null) {
            String oval = "decoderType:" + decoderType + ",streamId:" + streamId + ",state:" + (state ? "1" : "0");
            this.mBehaviorListener.onBehaviorEvent(this.tag, "decoderState", oval, 1);
        }
    }

    public void notifyVideoPlayerViewState(int viewType, boolean state) {
        YMFLog.info(this, "[PlayView]", "upload usrBehavior notifyVideoPlayerViewState, viewType:" + viewType + " state:" + state);
        if (this.mBehaviorListener != null) {
            String oval = "viewType:" + viewType + ",state:" + (state ? "1" : "0");
            this.mBehaviorListener.onBehaviorEvent(this.tag, "viewState", oval, 1);
        }
    }

    public void notifyGlManagerState(int viewType, boolean state) {
        YMFLog.info(this, "[Procedur]", "upload usrBehavior notifyGlManagerState, viewType:" + viewType + " state:" + state);
        if (this.mBehaviorListener != null) {
            // empty if block
        }
    }

    public void notifyPlayerViewLinkStream(int viewType, long streamId, boolean state) {
        YMFLog.info(this, "[PlayView]", "upload usrBehavior notifyPlayerViewLinkStream, viewType:" + viewType + " streamId" + streamId + " state:" + state);
        if (this.mBehaviorListener != null) {
            String oval = "viewType:" + viewType + ",streamId:" + streamId + ",state:" + (state ? "1" : "0");
            this.mBehaviorListener.onBehaviorEvent(this.tag, "viewLinkState", oval, 1);
        }
    }

    public void notifyPlayerViewOnSurface(int viewType, boolean state) {
        YMFLog.info(this, "[PlayView]", "upload usrBehavior notifyPlayerViewOnSurface, viewType:" + viewType + " state:" + state);
        if (this.mBehaviorListener != null) {
            String oval = "viewType:" + viewType + ",state:" + (state ? "1" : "0");
            this.mBehaviorListener.onBehaviorEvent(this.tag, "viewDisplayState", oval, 1);
        }
    }

    public void notifyPlayerException(String exceptionType) {
        YMFLog.info(this, "[PlayView]", "upload usrBehavior notifyPlayerException, exceptionType:" + exceptionType);
        if (this.mBehaviorListener != null) {
            this.mBehaviorListener.onBehaviorEvent(this.tag, "playerException", exceptionType, 1);
        }
    }

    public void notifyFirstFrameDecode() {
        YMFLog.info(this, "[PlayView]", "upload usrBehavior notifyFirstFrameDecode");
        if (this.mBehaviorListener != null) {
            String oval = "systemTime:" + System.currentTimeMillis();
            this.mBehaviorListener.onBehaviorEvent(this.tag, "firstFrameDecode", oval, 1);
        }
    }

    public void notifyFirstFrameRendered(int type) {
        YMFLog.info(this, "[PlayView]", "upload usrBehavior notifyFirstFrameRendered, type:" + type);
        if (this.mBehaviorListener != null) {
            String oval = "type:" + type + ",systemTime:" + System.currentTimeMillis();
            this.mBehaviorListener.onBehaviorEvent(this.tag, "firstFrameRendered", oval, 1);
        }
    }

    private static interface UsrBehaviorStatInfoKey {
        public static final String VideoDecoderState = "decoderState";
        public static final String PlayerViewState = "viewState";
        public static final String GlManagerState = "glManagerState";
        public static final String PlayerViewLinkStream = "viewLinkState";
        public static final String PlayerViewOnSurface = "viewDisplayState";
        public static final String PlayerException = "playerException";
        public static final String FirstFrameDecode = "firstFrameDecode";
        public static final String FirstFrameRendered = "firstFrameRendered";
    }
}

