/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.stat;

import com.yy.videoplayer.stat.VideoPlayerStatistic;
import com.yy.videoplayer.stat.VideoStatisticTool;
import com.yy.videoplayer.utils.YMFLog;
import java.util.ArrayList;
import java.util.HashMap;

public class YMFPlayerStatisticManager {
    public static final String TAG = "YMFPlayerStatisticManager ";
    private static volatile YMFPlayerStatisticManager mInstance;
    private VideoPlayerStatistic mVideoPlayerStatistic = new VideoPlayerStatistic();
    private static final byte[] SYNC_FLAG;
    private HashMap<Long, VideoStatisticTool> mDecodeLatencyStatistic = new HashMap();
    private HashMap<Long, VideoStatisticTool> mRenderLatencyStatistic = new HashMap();
    private HashMap<Long, VideoStatisticTool> mRenderTimeStatistic = new HashMap();
    private HashMap<Long, VideoStatisticTool> mPtsStatistic = new HashMap();
    private HashMap<Long, VideoStatisticTool> mRenderFrameStatistic = new HashMap();
    private HashMap<Long, VideoStatisticTool> mDecodeMaxLatencyStatistic = new HashMap();
    private HashMap<Long, VideoStatisticTool> mRenderMaxLatencyStatistic = new HashMap();
    private HashMap<Long, VideoStatisticTool> mDecodeVideoMaxLatencyStatistic = new HashMap();
    private HashMap<Long, Long> mLastSampleMap = new HashMap();
    private HashMap<Long, Long> mLastRenderTimeStampMap = new HashMap();
    private ArrayList<VideoStatisticTool> statisticTools = new ArrayList();
    private HashMap<Long, Long> mResetRenderPtsStreamMap = new HashMap();
    protected static final int RESET_DATA_COUNT = 10;
    protected static final int RESET_DATA_TIME = 5000;
    private HashMap<Long, Long> mStartResetTimeMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized YMFPlayerStatisticManager getInstance() {
        if (mInstance != null) return mInstance;
        byte[] byArray = SYNC_FLAG;
        synchronized (SYNC_FLAG) {
            if (mInstance != null) return mInstance;
            mInstance = new YMFPlayerStatisticManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private YMFPlayerStatisticManager() {
        this.init();
    }

    private void init() {
    }

    public synchronized void reset() {
        for (long streamId : this.mLastSampleMap.keySet()) {
            this.mLastSampleMap.put(streamId, 0L);
        }
        for (long streamId : this.mLastRenderTimeStampMap.keySet()) {
            this.mLastRenderTimeStampMap.put(streamId, 0L);
        }
        for (long streamId : this.mStartResetTimeMap.keySet()) {
            this.mStartResetTimeMap.put(streamId, System.currentTimeMillis());
        }
        YMFLog.info(this, "[Stat    ]", "reset all");
    }

    public synchronized void reset(long streamId) {
        this.mLastSampleMap.put(streamId, 0L);
        this.mLastRenderTimeStampMap.put(streamId, 0L);
        this.mStartResetTimeMap.put(streamId, System.currentTimeMillis());
        YMFLog.info(this, "[Stat    ]", "reset streamId\uff1a" + streamId);
    }

    public synchronized void setResetStatistic(long streamId, long pts) {
        YMFLog.info(this, "[Stat    ]", "setResetStatistic streamId\uff1a" + streamId + " pts\uff1a" + pts);
        this.reset(streamId);
    }

    public synchronized void setVideoDecodeId(long streamId, int id) {
        if (this.mVideoPlayerStatistic != null) {
            this.mVideoPlayerStatistic.setVideoDecodeId(streamId, id);
        }
    }

    public synchronized void setDecodeOutputWidth(long streamId, int width) {
        if (this.mVideoPlayerStatistic != null) {
            this.mVideoPlayerStatistic.setVideoDecodeOutputWidth(streamId, width);
        }
    }

    public synchronized void setDecodeOutputHeight(long streamId, int height) {
        if (this.mVideoPlayerStatistic != null) {
            this.mVideoPlayerStatistic.setDecodeOutputHeight(streamId, height);
        }
    }

    public synchronized void setDecodeOutputCount(long streamId, int fps) {
        if (this.mVideoPlayerStatistic != null) {
            this.mVideoPlayerStatistic.setDecodeOutputCount(streamId, fps);
        }
    }

    public synchronized void setRenderFrameCount(long streamId, int renderFrameCount) {
        if (this.mVideoPlayerStatistic != null && this.mRenderFrameStatistic != null) {
            if (!this.mRenderFrameStatistic.containsKey(streamId)) {
                VideoStatisticTool tool = new VideoStatisticTool();
                this.mRenderFrameStatistic.put(streamId, tool);
            }
            this.mRenderFrameStatistic.get(streamId).triggerStatistic(renderFrameCount);
        }
    }

    public void setDecodeInBitrate(long streamId, int setDecodeInBitrate) {
    }

    public synchronized void setRenderTimeStamp(long streamId, long timeStamp, long pts) {
        if (this.mVideoPlayerStatistic != null && this.mRenderTimeStatistic != null) {
            if (!this.mRenderTimeStatistic.containsKey(streamId)) {
                VideoStatisticTool tool = new VideoStatisticTool();
                this.mRenderTimeStatistic.put(streamId, tool);
            }
            if (!this.mLastRenderTimeStampMap.containsKey(streamId) || this.mLastRenderTimeStampMap.get(streamId) == 0L) {
                this.mLastRenderTimeStampMap.put(streamId, timeStamp);
                return;
            }
            if (this.mStartResetTimeMap.containsKey(streamId) && System.currentTimeMillis() - this.mStartResetTimeMap.get(streamId) < 5000L) {
                this.mLastRenderTimeStampMap.put(streamId, timeStamp);
                return;
            }
            int deal = (int)(timeStamp - this.mLastRenderTimeStampMap.get(streamId));
            this.mLastRenderTimeStampMap.put(streamId, timeStamp);
            this.mRenderTimeStatistic.get(streamId).triggerStatisticCalcStalling(deal);
        }
    }

    public synchronized void setDecodeLatency(long streamId, int decodeLatency) {
        if (this.mVideoPlayerStatistic != null) {
            VideoStatisticTool tool;
            if (this.mStartResetTimeMap.containsKey(streamId) && System.currentTimeMillis() - this.mStartResetTimeMap.get(streamId) < 5000L) {
                return;
            }
            if (this.mDecodeLatencyStatistic != null) {
                if (!this.mDecodeLatencyStatistic.containsKey(streamId)) {
                    tool = new VideoStatisticTool();
                    this.mDecodeLatencyStatistic.put(streamId, tool);
                }
                this.mDecodeLatencyStatistic.get(streamId).triggerStatisticCalcBySecond(decodeLatency);
            }
            if (this.mDecodeMaxLatencyStatistic != null) {
                if (!this.mDecodeMaxLatencyStatistic.containsKey(streamId)) {
                    tool = new VideoStatisticTool();
                    this.mDecodeMaxLatencyStatistic.put(streamId, tool);
                }
                this.mDecodeMaxLatencyStatistic.get(streamId).triggerStatisticCalcBySecond(decodeLatency);
            }
            if (this.mDecodeVideoMaxLatencyStatistic != null) {
                if (!this.mDecodeVideoMaxLatencyStatistic.containsKey(streamId)) {
                    tool = new VideoStatisticTool();
                    this.mDecodeVideoMaxLatencyStatistic.put(streamId, tool);
                }
                this.mDecodeVideoMaxLatencyStatistic.get(streamId).triggerStatisticCalcBySecond(decodeLatency);
            }
        }
    }

    public synchronized void setDecodeVideoMaxLatency(long streamId, long decodeLatency) {
        if (this.mDecodeVideoMaxLatencyStatistic != null) {
            if (this.mStartResetTimeMap.containsKey(streamId) && System.currentTimeMillis() - this.mStartResetTimeMap.get(streamId) < 5000L) {
                return;
            }
            if (!this.mDecodeVideoMaxLatencyStatistic.containsKey(streamId)) {
                VideoStatisticTool tool = new VideoStatisticTool();
                this.mDecodeVideoMaxLatencyStatistic.put(streamId, tool);
            }
            this.mDecodeVideoMaxLatencyStatistic.get(streamId).triggerStatisticCalcBySecond((int)decodeLatency);
        }
    }

    public synchronized void setRenderLatency(long streamId, int renderLatency) {
        if (this.mVideoPlayerStatistic != null) {
            VideoStatisticTool tool;
            if (this.mRenderLatencyStatistic != null) {
                if (!this.mRenderLatencyStatistic.containsKey(streamId)) {
                    tool = new VideoStatisticTool();
                    this.mRenderLatencyStatistic.put(streamId, tool);
                }
                this.mRenderLatencyStatistic.get(streamId).triggerStatisticCalcBySecond(renderLatency);
            }
            if (this.mRenderMaxLatencyStatistic != null) {
                if (!this.mRenderMaxLatencyStatistic.containsKey(streamId)) {
                    tool = new VideoStatisticTool();
                    this.mRenderMaxLatencyStatistic.put(streamId, tool);
                }
                this.mRenderMaxLatencyStatistic.get(streamId).triggerStatisticCalcBySecond(renderLatency);
            }
        }
    }

    public void setGpuDeviceName(String name) {
        VideoPlayerStatistic.setGpuDeviceName(name);
    }

    public synchronized String getVideoDecodeBaseStatistics(int sendSeq) {
        return VideoPlayerStatistic.getBasePlayerVideoStatistics(sendSeq);
    }

    public synchronized String getVideoDecodeStatistics(boolean bKeyStat, long streamId) {
        this.flush(bKeyStat, streamId);
        String result = VideoPlayerStatistic.getPlayerVideoStatistics(bKeyStat, streamId);
        return result;
    }

    private void flush(boolean bKeyStat, long streamId) {
        if (bKeyStat) {
            if (this.mRenderFrameStatistic != null) {
                if (!this.mRenderFrameStatistic.containsKey(streamId)) {
                    this.mVideoPlayerStatistic.setRenderFrameCount(streamId, -1);
                } else {
                    this.mRenderFrameStatistic.get(streamId).flush();
                    this.mVideoPlayerStatistic.setRenderFrameCount(streamId, this.mRenderFrameStatistic.get((Object)Long.valueOf((long)streamId)).getStatisticResult().sumDeal);
                }
            }
            if (this.mRenderTimeStatistic != null) {
                if (!this.mRenderTimeStatistic.containsKey(streamId)) {
                    this.mVideoPlayerStatistic.setRenderStallingIndication(streamId, -1);
                    this.mVideoPlayerStatistic.setRenderPtsMaxDiff(streamId, -1);
                } else {
                    this.mRenderTimeStatistic.get(streamId).flush();
                    VideoStatisticTool.VideoStatisticResult result = this.mRenderTimeStatistic.get(streamId).getStatisticResult();
                    this.mVideoPlayerStatistic.setRenderStallingIndication(streamId, result.other);
                    this.mVideoPlayerStatistic.setRenderPtsMaxDiff(streamId, result.maxDeal);
                }
            }
            if (this.mDecodeLatencyStatistic != null) {
                if (!this.mDecodeLatencyStatistic.containsKey(streamId)) {
                    this.mVideoPlayerStatistic.setDecodeMeanLatency(streamId, -1);
                } else {
                    this.mDecodeLatencyStatistic.get(streamId).flush();
                    this.mVideoPlayerStatistic.setDecodeMeanLatency(streamId, this.mDecodeLatencyStatistic.get((Object)Long.valueOf((long)streamId)).getStatisticResult().meanDeal);
                }
            }
            if (this.mRenderLatencyStatistic != null) {
                if (!this.mRenderLatencyStatistic.containsKey(streamId)) {
                    this.mVideoPlayerStatistic.setRenderMeanLatency(streamId, -1);
                } else {
                    this.mRenderLatencyStatistic.get(streamId).flush();
                    this.mVideoPlayerStatistic.setRenderMeanLatency(streamId, this.mRenderLatencyStatistic.get((Object)Long.valueOf((long)streamId)).getStatisticResult().meanDeal);
                }
            }
        } else {
            if (this.mDecodeMaxLatencyStatistic != null) {
                if (!this.mDecodeMaxLatencyStatistic.containsKey(streamId)) {
                    this.mVideoPlayerStatistic.setDecodeMaxLatency(streamId, -1);
                } else {
                    this.mDecodeMaxLatencyStatistic.get(streamId).flush();
                    this.mVideoPlayerStatistic.setDecodeMaxLatency(streamId, this.mDecodeMaxLatencyStatistic.get((Object)Long.valueOf((long)streamId)).getStatisticResult().maxDeal);
                }
            }
            if (this.mRenderMaxLatencyStatistic != null) {
                if (!this.mRenderMaxLatencyStatistic.containsKey(streamId)) {
                    this.mVideoPlayerStatistic.setRenderMaxLatency(streamId, -1);
                } else {
                    this.mRenderMaxLatencyStatistic.get(streamId).flush();
                    this.mVideoPlayerStatistic.setRenderMaxLatency(streamId, this.mRenderMaxLatencyStatistic.get((Object)Long.valueOf((long)streamId)).getStatisticResult().maxDeal);
                }
            }
            if (this.mDecodeVideoMaxLatencyStatistic != null) {
                if (!this.mDecodeVideoMaxLatencyStatistic.containsKey(streamId)) {
                    this.mVideoPlayerStatistic.setDecodeVideoMaxLatency(streamId, -1);
                } else {
                    this.mDecodeVideoMaxLatencyStatistic.get(streamId).flush();
                    this.mVideoPlayerStatistic.setDecodeVideoMaxLatency(streamId, this.mDecodeVideoMaxLatencyStatistic.get((Object)Long.valueOf((long)streamId)).getStatisticResult().maxDeal);
                }
            }
        }
    }

    public synchronized void clean(long streamId) {
        if (this.mVideoPlayerStatistic != null) {
            this.mVideoPlayerStatistic.clean(streamId);
        }
        if (this.mRenderFrameStatistic != null && this.mRenderFrameStatistic.containsKey(streamId)) {
            this.mRenderFrameStatistic.remove(streamId);
        }
        if (this.mRenderTimeStatistic != null && this.mRenderTimeStatistic.containsKey(streamId)) {
            this.mRenderTimeStatistic.remove(streamId);
        }
        if (this.mPtsStatistic != null && this.mPtsStatistic.containsKey(streamId)) {
            this.mPtsStatistic.remove(streamId);
        }
        if (this.mDecodeLatencyStatistic != null && this.mDecodeLatencyStatistic.containsKey(streamId)) {
            this.mDecodeLatencyStatistic.remove(streamId);
        }
        if (this.mRenderLatencyStatistic != null && this.mRenderLatencyStatistic.containsKey(streamId)) {
            this.mRenderLatencyStatistic.remove(streamId);
        }
        if (this.mDecodeMaxLatencyStatistic != null && this.mDecodeMaxLatencyStatistic.containsKey(streamId)) {
            this.mDecodeMaxLatencyStatistic.remove(streamId);
        }
        if (this.mDecodeVideoMaxLatencyStatistic != null && this.mDecodeVideoMaxLatencyStatistic.containsKey(streamId)) {
            this.mDecodeVideoMaxLatencyStatistic.remove(streamId);
        }
        if (this.mRenderMaxLatencyStatistic != null && this.mRenderMaxLatencyStatistic.containsKey(streamId)) {
            this.mRenderMaxLatencyStatistic.remove(streamId);
        }
        this.mLastSampleMap.clear();
        this.mLastRenderTimeStampMap.clear();
        this.mStartResetTimeMap.clear();
        YMFLog.info(TAG, "[Stat    ]", "clean streamId:" + streamId);
    }

    static {
        SYNC_FLAG = new byte[1];
    }
}

