/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.stat;

import com.yy.videoplayer.stat.CommonUtil;
import com.yy.videoplayer.utils.CPUTool;
import com.yy.videoplayer.utils.YMFLog;
import java.util.HashMap;
import java.util.LinkedHashMap;

public class VideoPlayerStatistic {
    private static final String TAG = "VideoPlayerStatistic";
    private static VideoPlayerStatistic mInstance;
    private static LinkedHashMap<String, Object> mCorePlayerDataHashMap;
    private static LinkedHashMap<String, Object> mAssistantUploadDataHashMap;
    private static LinkedHashMap<String, Object> mBaseUploadDataHashMap;
    private static String mCpuName;
    private static String mVersion;
    private static String mGpuName;
    private static HashMap<Long, Integer> mDecodeId;
    private static HashMap<Long, Integer> mDecodeOutputWidth;
    private static HashMap<Long, Integer> mDecodeOutputHeight;
    private static HashMap<Long, Integer> mDecodeOutputCount;
    private static HashMap<Long, Integer> mRenderFrameCount;
    private static HashMap<Long, Integer> mBitrateCount;
    private static HashMap<Long, Integer> mRenderStallingIndication;
    private static HashMap<Long, Integer> mRenderPtsMaxDiff;
    private static HashMap<Long, Integer> mDecodeMaxLatency;
    private static HashMap<Long, Integer> mDecodeVideoMaxLatency;
    private static HashMap<Long, Integer> mRenderMaxLatency;
    private static HashMap<Long, Integer> mDecodeMeanLatency;
    private static HashMap<Long, Integer> mRenderMeanLatency;
    private static Object mSyncObj;

    public static VideoPlayerStatistic getInstance() {
        if (mInstance == null) {
            mInstance = new VideoPlayerStatistic();
        }
        return mInstance;
    }

    public VideoPlayerStatistic() {
        this.initInfo();
    }

    private void initInfo() {
        mVersion = "200.3.3.200";
        mCpuName = CPUTool.getCpuInfo();
    }

    public static void setGpuDeviceName(String name) {
        mGpuName = name;
    }

    public void setVideoDecodeId(long streamId, int id) {
        if (mDecodeId != null) {
            mDecodeId.put(streamId, CommonUtil.wrapperHiidoDecodeId(id));
        }
    }

    public void setVideoDecodeOutputWidth(long streamId, int width) {
        if (mDecodeOutputWidth != null) {
            mDecodeOutputWidth.put(streamId, width);
        }
    }

    public void setDecodeOutputHeight(long streamId, int height) {
        if (mDecodeOutputHeight != null) {
            mDecodeOutputHeight.put(streamId, height);
        }
    }

    public void setDecodeOutputCount(long streamId, int fps) {
        if (mDecodeOutputCount != null) {
            mDecodeOutputCount.put(streamId, fps);
        }
    }

    public void setRenderFrameCount(long streamId, int renderFrameCount) {
        if (mRenderFrameCount != null) {
            mRenderFrameCount.put(streamId, renderFrameCount);
        }
    }

    public void setDecodeInBitrate(long streamId, int setDecodeInBitrate) {
        if (mBitrateCount != null) {
            mBitrateCount.put(streamId, setDecodeInBitrate);
        }
    }

    public void setRenderStallingIndication(long streamId, int renderStallingIndication) {
        if (mRenderStallingIndication != null) {
            mRenderStallingIndication.put(streamId, renderStallingIndication);
        }
    }

    public void setRenderPtsMaxDiff(long streamId, int renderPtsMaxDiff) {
        if (mRenderPtsMaxDiff != null) {
            mRenderPtsMaxDiff.put(streamId, renderPtsMaxDiff);
        }
    }

    public void setDecodeMaxLatency(long streamId, int decodeMaxLatency) {
        if (mDecodeMaxLatency != null) {
            mDecodeMaxLatency.put(streamId, decodeMaxLatency);
        }
    }

    public void setDecodeVideoMaxLatency(long streamId, int decodeMaxLatency) {
        if (mDecodeVideoMaxLatency != null) {
            mDecodeVideoMaxLatency.put(streamId, decodeMaxLatency);
        }
    }

    public void setRenderMaxLatency(long streamId, int renderMaxLatency) {
        if (mRenderMaxLatency != null) {
            mRenderMaxLatency.put(streamId, renderMaxLatency);
        }
    }

    public void setDecodeMeanLatency(long streamId, int decodeMeanLatency) {
        if (mDecodeMeanLatency != null) {
            mDecodeMeanLatency.put(streamId, decodeMeanLatency);
        }
    }

    public void setRenderMeanLatency(long streamId, int renderMeanLatency) {
        if (mRenderMeanLatency != null) {
            mRenderMeanLatency.put(streamId, renderMeanLatency);
        }
    }

    public static String getBasePlayerVideoStatistics(int sendSeq) {
        if (sendSeq < 3) {
            mBaseUploadDataHashMap.put("vver", CommonUtil.toURLEncoded(mVersion));
            mBaseUploadDataHashMap.put("cpu", CommonUtil.toURLEncoded(mCpuName));
            mBaseUploadDataHashMap.put("gpu", CommonUtil.toURLEncoded(mGpuName));
            String data = CommonUtil.getParamsOrderByKey(mBaseUploadDataHashMap);
            YMFLog.info(TAG, "[Stat    ]", "videoplayer hiido data:" + data);
            mBaseUploadDataHashMap.clear();
            return data;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPlayerVideoStatistics(boolean bKeyStat, long streamId) {
        String data = "";
        Object object = mSyncObj;
        synchronized (object) {
            if (bKeyStat) {
                mCorePlayerDataHashMap.put("did", mDecodeId.get(streamId) != null ? mDecodeId.get(streamId) : 0);
                mCorePlayerDataHashMap.put("dow", mDecodeOutputWidth.get(streamId) != null ? mDecodeOutputWidth.get(streamId) : 0);
                mCorePlayerDataHashMap.put("doh", mDecodeOutputHeight.get(streamId) != null ? mDecodeOutputHeight.get(streamId) : 0);
                mCorePlayerDataHashMap.put("dofr", mDecodeOutputCount.get(streamId) != null ? mDecodeOutputCount.get(streamId) : 0);
                mCorePlayerDataHashMap.put("frdc", mRenderFrameCount.get(streamId) != null ? mRenderFrameCount.get(streamId) : -1);
                mCorePlayerDataHashMap.put("vrsi", mRenderStallingIndication.get(streamId) != null ? mRenderStallingIndication.get(streamId) : -1);
                mCorePlayerDataHashMap.put("rpd", mRenderPtsMaxDiff.get(streamId) != null ? mRenderPtsMaxDiff.get(streamId) : -1);
                mCorePlayerDataHashMap.put("dal", mDecodeMeanLatency.get(streamId) != null ? mDecodeMeanLatency.get(streamId) : -1);
                mCorePlayerDataHashMap.put("ral", mRenderMeanLatency.get(streamId) != null ? mRenderMeanLatency.get(streamId) : -1);
                data = CommonUtil.getParamsOrderByKey(mCorePlayerDataHashMap);
            } else {
                mAssistantUploadDataHashMap.put("dml", mDecodeMaxLatency.get(streamId));
                mAssistantUploadDataHashMap.put("rml", mRenderMaxLatency.get(streamId));
                mAssistantUploadDataHashMap.put("dmt", mDecodeVideoMaxLatency.get(streamId));
                data = CommonUtil.getParamsOrderByKey(mAssistantUploadDataHashMap);
            }
        }
        YMFLog.info(TAG, "[Procedur]", "videoplayer hiido streamId:" + streamId + " data:" + data);
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(long streamId) {
        Object object = mSyncObj;
        synchronized (object) {
            if (mDecodeId != null && mDecodeId.containsKey(streamId)) {
                mDecodeId.remove(streamId);
            }
            if (mDecodeOutputWidth != null && mDecodeOutputWidth.containsKey(streamId)) {
                mDecodeOutputWidth.remove(streamId);
            }
            if (mDecodeOutputCount != null && mDecodeOutputCount.containsKey(streamId)) {
                mDecodeOutputCount.remove(streamId);
            }
            if (mRenderFrameCount != null && mRenderFrameCount.containsKey(streamId)) {
                mRenderFrameCount.remove(streamId);
            }
            if (mRenderStallingIndication != null && mRenderStallingIndication.containsKey(streamId)) {
                mRenderStallingIndication.remove(streamId);
            }
            if (mRenderPtsMaxDiff != null && mRenderPtsMaxDiff.containsKey(streamId)) {
                mRenderPtsMaxDiff.remove(streamId);
            }
            if (mDecodeMaxLatency != null && mDecodeMaxLatency.containsKey(streamId)) {
                mDecodeMaxLatency.remove(streamId);
            }
            if (mDecodeVideoMaxLatency != null && mDecodeVideoMaxLatency.containsKey(streamId)) {
                mDecodeVideoMaxLatency.remove(streamId);
            }
            if (mDecodeMeanLatency != null && mDecodeMeanLatency.containsKey(streamId)) {
                mDecodeMeanLatency.remove(streamId);
            }
            if (mRenderMeanLatency != null && mRenderMeanLatency.containsKey(streamId)) {
                mRenderMeanLatency.remove(streamId);
            }
            if (mRenderMaxLatency != null && mRenderMaxLatency.containsKey(streamId)) {
                mRenderMaxLatency.remove(streamId);
            }
            if (mDecodeOutputHeight != null && mDecodeOutputHeight.containsKey(streamId)) {
                mDecodeOutputHeight.remove(streamId);
            }
        }
    }

    static {
        mCorePlayerDataHashMap = new LinkedHashMap();
        mAssistantUploadDataHashMap = new LinkedHashMap();
        mBaseUploadDataHashMap = new LinkedHashMap();
        mCpuName = "";
        mVersion = "";
        mGpuName = "";
        mDecodeId = new HashMap();
        mDecodeOutputWidth = new HashMap();
        mDecodeOutputHeight = new HashMap();
        mDecodeOutputCount = new HashMap();
        mRenderFrameCount = new HashMap();
        mBitrateCount = new HashMap();
        mRenderStallingIndication = new HashMap();
        mRenderPtsMaxDiff = new HashMap();
        mDecodeMaxLatency = new HashMap();
        mDecodeVideoMaxLatency = new HashMap();
        mRenderMaxLatency = new HashMap();
        mDecodeMeanLatency = new HashMap();
        mRenderMeanLatency = new HashMap();
        mSyncObj = new Object();
    }

    public static interface AudienceHiidoCoreStatisticKey {
        public static final String DecodeId = "did";
        public static final String DecodeOutputWidth = "dow";
        public static final String DecodeOutputHeight = "doh";
        public static final String DecodeOutputCount = "dofr";
        public static final String RenderFrameCount = "frdc";
        public static final String RenderStallingIndication = "vrsi";
        public static final String RenderPtsMaxDiff = "rpd";
        public static final String DecodeMaxLatency = "dml";
        public static final String RenderMaxLatency = "rml";
        public static final String DecodeMeanLatency = "dal";
        public static final String RenderMeanLatency = "ral";
        public static final String DecodeVideoMaxLatency = "dmt";
        public static final String AppCpuRate = "s7";
    }

    public static interface AudienceHiidoAssistantStatisticKey {
        public static final String VideoLibVer = "vver";
        public static final String CpuDeviceInfo = "cpu";
        public static final String GpuDeviceInfo = "gpu";
    }
}

