/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.render;

import android.opengl.GLES20;
import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.render.IProgram;
import com.yy.videoplayer.render.YMFShader;
import com.yy.videoplayer.render.YMFShaderData;
import com.yy.videoplayer.utils.YMFLog;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.util.HashMap;

public abstract class YMFProgramBase
implements IProgram {
    private static final String TAG = "YMFProgramBase";
    private static final int INPUT_TYPE_ATTRIBUTE = 0;
    private static final int INPUT_TYPE_UNIFORM = 1;
    private HashMap<String, Integer> mHandleMap = new HashMap();
    protected int mProgram;
    private YMFShader mShader;
    private YMFShaderData mShaderData = new YMFShaderData();

    protected YMFProgramBase(String vertexShader, String fragmentShader) {
        this.mShader = new YMFShader(vertexShader, fragmentShader);
        if (this.mShader.ready()) {
            this.initProgram(this.mShader);
        }
    }

    @Override
    public void useProgram() {
        GLES20.glUseProgram((int)this.mProgram);
    }

    @Override
    public void flipVertical() {
        this.mShaderData.flipVertical(true);
    }

    @Override
    public void flipHorizontal() {
        this.mShaderData.flipHorizontal(true);
    }

    @Override
    public boolean checkUpdateMirrorMode(boolean bEnableMirrorMode) {
        return this.mShaderData.checkUpdateMirrorMode(bEnableMirrorMode);
    }

    @Override
    public void rotation(int angle) {
        this.mShaderData.setRotation(angle);
    }

    @Override
    public void clip(int inWidth, int inHeight, int cropLeft, int cropRight, int cropBottom, int cropTop, boolean clipWindow) {
        int outWidth = cropRight - cropLeft + 1;
        int outHeight = cropBottom - cropTop + 1;
        int clipMode = 0;
        if (outWidth != inWidth) {
            if (cropLeft != 0) {
                clipMode |= 1;
            }
            clipMode |= 2;
        }
        if (outHeight != inHeight) {
            if (cropTop != 0) {
                clipMode |= 8;
            }
            clipMode |= 4;
        }
        if (clipWindow) {
            this.mShaderData.clip(inWidth, inHeight, cropLeft, cropRight, cropBottom, cropTop);
        } else {
            this.mShaderData.clip(inWidth, inHeight, outWidth, outHeight, clipMode);
        }
    }

    @Override
    public void clip(int inWidth, int inHeight, int outWidth, int outHeight, VideoConstant.ScaleMode scaleMode) {
        this.mShaderData.clip(inWidth, inHeight, outWidth, outHeight, scaleMode);
    }

    @Override
    public void drawFrame() {
        this.onSetUniformValue();
        this.onSetAttributeValue();
        GLES20.glDrawArrays((int)5, (int)0, (int)this.mShaderData.getVertexCount());
        this.onUnSetAttributeValue();
    }

    @Override
    public void release() {
        if (this.mShader != null) {
            this.mShader.release();
            this.mShader = null;
        }
        if (this.mProgram != -1) {
            GLES20.glDeleteProgram((int)this.mProgram);
            this.mProgram = -1;
        }
        this.mHandleMap.clear();
        this.mShaderData = null;
    }

    protected int getVertexCoordStride() {
        return this.mShaderData.getVertexCoordStride();
    }

    protected FloatBuffer getVertexCoordData() {
        return this.mShaderData.getVertexCoordData();
    }

    protected int getTextureCoordStride() {
        return this.mShaderData.getTextureCoordStride();
    }

    protected FloatBuffer getTextureCoordData() {
        return this.mShaderData.getTextureCoordData();
    }

    protected FloatBuffer getWaterMarkCoordData() {
        return this.mShaderData.getWaterMarkCoordData();
    }

    protected float[] getVertexMatrix() {
        return this.mShaderData.getVertexMatrix();
    }

    protected float[] getTextureMatrix() {
        return this.mShaderData.getTextureMatrix();
    }

    protected void setUniform1i(String name, int x) {
        int location = this.getHandle(name, 1);
        if (location != -1) {
            GLES20.glUniform1i((int)location, (int)x);
        }
    }

    protected void setUniformMatrix4fv(String name, int count, boolean transpose, float[] value, int offset) {
        int location = this.getHandle(name, 1);
        if (location != -1) {
            GLES20.glUniformMatrix4fv((int)location, (int)count, (boolean)transpose, (float[])value, (int)offset);
        }
    }

    protected void setVertexAttribPointer(String name, int size, int type, boolean normalized, int stride, Buffer ptr) {
        int location = this.getHandle(name, 0);
        if (location != -1) {
            GLES20.glEnableVertexAttribArray((int)location);
            GLES20.glVertexAttribPointer((int)location, (int)size, (int)type, (boolean)normalized, (int)stride, (Buffer)ptr);
        }
    }

    protected void unSetVertexAttribPointer(String name) {
        int location = this.getHandle(name, 0);
        if (location != -1) {
            GLES20.glDisableVertexAttribArray((int)location);
        }
    }

    private int getHandle(String name, int type) {
        if (this.mHandleMap.containsKey(name)) {
            return this.mHandleMap.get(name);
        }
        int handle = -1;
        if (type == 0) {
            handle = GLES20.glGetAttribLocation((int)this.mProgram, (String)name);
        } else if (type == 1) {
            handle = GLES20.glGetUniformLocation((int)this.mProgram, (String)name);
        }
        if (handle != -1) {
            this.mHandleMap.put(name, handle);
        } else {
            YMFLog.error((Object)this, "[Util    ]", "Could not get location for " + name);
        }
        return handle;
    }

    private void initProgram(YMFShader shader) {
        int program = GLES20.glCreateProgram();
        if (program != 0) {
            GLES20.glAttachShader((int)program, (int)shader.getVertexHandle());
            GLES20.glAttachShader((int)program, (int)shader.getFragmentHandle());
            GLES20.glLinkProgram((int)program);
            int[] linkStatus = new int[1];
            GLES20.glGetProgramiv((int)program, (int)35714, (int[])linkStatus, (int)0);
            if (linkStatus[0] != 1) {
                String error = GLES20.glGetProgramInfoLog((int)program);
                this.release();
                YMFLog.error((Object)this, "[Util    ]", "Link shader error:" + error);
                return;
            }
        }
        this.mProgram = program;
    }

    protected abstract void onSetAttributeValue();

    protected abstract void onSetUniformValue();

    protected abstract void onUnSetAttributeValue();
}

