/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.render;

import android.graphics.ImageFormat;
import com.yy.videoplayer.utils.YMFLog;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class YMFImageBuffer {
    private static int mDirectoryBufferOffset;
    public int mFormat;
    public int mWidth;
    public int mHeight;
    public int mCropRight;
    public int mCropBottom;
    public int mCropLeft;
    public int mCropTop;
    public int mBufSize;
    public long mPts;
    public long mDts;
    public long mStreamId;
    public boolean mClipWindow;
    public boolean mChangeRenderMode;
    public boolean mHardware;
    public boolean mDirectHardRender = false;
    public boolean mNeedRendered = true;
    public boolean mStreamStart = false;
    public int mSsrc;
    public boolean mNotifyRenderInfo = true;
    public boolean mIgnore = false;
    public ByteBuffer mData;
    public long mLastNotifyRenderInfoPts = 0L;
    public long mDeltaPts = 0L;
    public boolean mMultiIgnoreState = false;
    public ReentrantReadWriteLock mSyncLock = new ReentrantReadWriteLock();

    public void tryLockData() {
        this.mSyncLock.writeLock().lock();
    }

    public void tryUnlockData() {
        try {
            while (this.mSyncLock.getWriteHoldCount() != 0) {
                this.mSyncLock.writeLock().unlock();
            }
        }
        catch (IllegalMonitorStateException e) {
            YMFLog.warn(this, "[Decoder ]", "tryUnlockData more than once, exception:" + e.toString());
        }
    }

    public YMFImageBuffer(int width, int height, int format, boolean allocMemory) {
        if (width <= 0 || height <= 0) {
            YMFLog.error(this, "[Util    ]", "invalid width or height. width:%d, height:%d", width, height);
            return;
        }
        this.mWidth = width;
        this.mHeight = height;
        this.mFormat = format;
        this.mCropLeft = 0;
        this.mCropRight = width - 1;
        this.mCropTop = 0;
        this.mCropBottom = height - 1;
        this.mClipWindow = false;
        this.mStreamStart = true;
        this.mNotifyRenderInfo = true;
        this.mIgnore = false;
        this.mChangeRenderMode = false;
        this.mSsrc = 0;
        if (format == 1 || format == 2 || format == 0 || format == 3) {
            this.mBufSize = this.mWidth * this.mHeight * ImageFormat.getBitsPerPixel((int)17) / 8;
        } else if (format == 36) {
            this.mBufSize = this.mWidth * this.mHeight * this.getBitsPerRgbPixel(format) / 8;
        } else {
            YMFLog.error((Object)this, "[Util    ]", "unsupported format:" + format);
        }
        if (allocMemory && this.mBufSize > 0) {
            this.mData = ByteBuffer.allocateDirect(this.mBufSize + YMFImageBuffer.offset());
            this.mData.order(ByteOrder.nativeOrder());
        }
    }

    private int getBitsPerRgbPixel(int format) {
        switch (format) {
            case 20: {
                return 24;
            }
            case 36: {
                return 32;
            }
            case 52: {
                return 16;
            }
        }
        return -1;
    }

    public static int offset() {
        return mDirectoryBufferOffset;
    }

    public YMFImageBuffer wrap(byte[] buf, int width, int height, int format) {
        if (this.mWidth != width || this.mHeight != height || this.mFormat != format) {
            this.mBufSize = format == 36 ? width * height * this.getBitsPerRgbPixel(format) / 8 : width * height * ImageFormat.getBitsPerPixel((int)17) / 8;
            this.mWidth = width;
            this.mHeight = height;
            this.mFormat = format;
        }
        if (this.mBufSize >= buf.length) {
            this.mData = ByteBuffer.wrap(buf);
        }
        return this;
    }

    public YMFImageBuffer assign(ByteBuffer buffer, int width, int height, int format, long pts, long dts, boolean hw, long streamId, int cropLeft, int cropRight, int cropBottom, int cropTop, boolean clipWindow, int ssrc) {
        if (!buffer.isDirect()) {
            YMFLog.error((Object)this, "[Util    ]", "wrap error, only support directory ByteBuffer.");
            return null;
        }
        this.mBufSize = format == 36 ? width * height * this.getBitsPerRgbPixel(format) / 8 : width * height * ImageFormat.getBitsPerPixel((int)17) / 8;
        this.mWidth = width;
        this.mHeight = height;
        this.mCropRight = cropRight;
        this.mCropBottom = cropBottom;
        this.mCropLeft = cropLeft;
        this.mCropTop = cropTop;
        this.mFormat = format;
        this.mData = buffer;
        this.mPts = pts;
        this.mDts = dts;
        this.mHardware = hw;
        this.mStreamId = streamId;
        this.mClipWindow = clipWindow;
        this.mSsrc = ssrc;
        return this;
    }

    public YMFImageBuffer assign(YMFImageBuffer src) {
        this.mPts = src.mPts;
        this.mDts = src.mDts;
        this.mData = src.mData;
        this.mWidth = src.mWidth;
        this.mHeight = src.mHeight;
        this.mFormat = src.mFormat;
        this.mBufSize = src.mBufSize;
        this.mHardware = src.mHardware;
        this.mStreamId = src.mStreamId;
        this.mCropRight = src.mCropRight;
        this.mCropBottom = src.mCropBottom;
        this.mCropLeft = src.mCropLeft;
        this.mCropTop = src.mCropTop;
        this.mClipWindow = src.mClipWindow;
        this.mNeedRendered = src.mNeedRendered;
        this.mStreamStart = src.mStreamStart;
        this.mSsrc = src.mSsrc;
        this.mNotifyRenderInfo = src.mNotifyRenderInfo;
        this.mIgnore = src.mIgnore;
        this.mChangeRenderMode = src.mChangeRenderMode;
        this.mDeltaPts = src.mDeltaPts;
        if (this.mMultiIgnoreState) {
            this.mIgnore = true;
        } else {
            this.mMultiIgnoreState = src.mMultiIgnoreState;
        }
        return this;
    }

    public YMFImageBuffer assignWithoutBuffer(YMFImageBuffer src) {
        this.mPts = src.mPts;
        this.mDeltaPts = src.mDeltaPts;
        this.mDts = src.mDts;
        this.mWidth = src.mWidth;
        this.mHeight = src.mHeight;
        this.mFormat = src.mFormat;
        this.mBufSize = src.mBufSize;
        this.mHardware = src.mHardware;
        this.mStreamId = src.mStreamId;
        this.mCropRight = src.mCropRight;
        this.mCropBottom = src.mCropBottom;
        this.mCropLeft = src.mCropLeft;
        this.mCropTop = src.mCropTop;
        this.mClipWindow = src.mClipWindow;
        this.mNeedRendered = src.mNeedRendered;
        this.mStreamStart = src.mStreamStart;
        this.mSsrc = src.mSsrc;
        this.mNotifyRenderInfo = src.mNotifyRenderInfo;
        this.mIgnore = src.mIgnore;
        this.mChangeRenderMode = src.mChangeRenderMode;
        if (this.mMultiIgnoreState) {
            this.mIgnore = true;
        } else {
            this.mMultiIgnoreState = src.mMultiIgnoreState;
        }
        return this;
    }

    public boolean deepCopy(YMFImageBuffer src) {
        if (this.mWidth != src.mWidth || this.mHeight != src.mHeight || this.mBufSize != src.mBufSize) {
            YMFLog.error((Object)this, "[Util    ]", "copy with different buffer size.");
            return false;
        }
        if (this.mFormat != src.mFormat) {
            YMFLog.error((Object)this, "[Util    ]", "copy with different image format");
            return false;
        }
        this.mPts = src.mPts;
        this.mDts = src.mDts;
        this.mFormat = src.mFormat;
        System.arraycopy(src.mData.array(), src.mData.arrayOffset(), this.mData.array(), this.mData.arrayOffset(), this.mBufSize);
        return true;
    }

    public int getYoffset() {
        return 0;
    }

    public int getUoffset() {
        return this.mWidth * this.mHeight;
    }

    public int getVoffset() {
        return this.mWidth * this.mHeight * 5 / 4;
    }

    static {
        ByteBuffer b = ByteBuffer.allocateDirect(4);
        if (b.hasArray()) {
            mDirectoryBufferOffset = b.arrayOffset();
            YMFLog.info(null, " YMFImageBuffer ", " mDirectoryBufferOffset " + mDirectoryBufferOffset);
        }
    }
}

