/*
 * Decompiled with CFR 0.152.
 */
package com.yy.videoplayer.decoder.glesunder43;

import com.yy.videoplayer.decoder.VideoConstant;
import com.yy.videoplayer.decoder.glesunder43.Drawable2d;
import com.yy.videoplayer.decoder.glesunder43.GlUtil;
import com.yy.videoplayer.decoder.glesunder43.Texture2dProgram;
import java.nio.FloatBuffer;

public class FullFrameRect {
    private final Drawable2d mRectDrawable = new Drawable2d(Drawable2d.Prefab.FULL_RECTANGLE);
    private Texture2dProgram mProgram;
    private float[] vertices = new float[8];
    private boolean mUseMultiVideoView = false;
    private static final float[] FULL_RECTANGLE_COORDS = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};

    public void setUseMultiVideoview(boolean bUse) {
        this.mUseMultiVideoView = bUse;
    }

    public void upDateVertexCoord(int imageWidth, int imageHeight, int viewWidth, int viewHight, VideoConstant.ScaleMode scaleType) {
        float inputAspect = (float)imageWidth / (float)imageHeight;
        float outputAspect = (float)viewWidth / (float)viewHight;
        System.arraycopy(FULL_RECTANGLE_COORDS, 0, this.vertices, 0, FULL_RECTANGLE_COORDS.length);
        if (scaleType == VideoConstant.ScaleMode.ClipToBounds) {
            if (inputAspect < outputAspect) {
                float heightRatio = outputAspect / inputAspect;
                this.vertices[1] = this.vertices[1] * heightRatio;
                this.vertices[3] = this.vertices[3] * heightRatio;
                this.vertices[5] = this.vertices[5] * heightRatio;
                this.vertices[7] = this.vertices[7] * heightRatio;
            } else {
                float widthRatio = inputAspect / outputAspect;
                this.vertices[0] = this.vertices[0] * widthRatio;
                this.vertices[2] = this.vertices[2] * widthRatio;
                this.vertices[4] = this.vertices[4] * widthRatio;
                this.vertices[6] = this.vertices[6] * widthRatio;
            }
        } else if (scaleType == VideoConstant.ScaleMode.AspectFit) {
            if (inputAspect < outputAspect) {
                float widthRatio = inputAspect / outputAspect;
                this.vertices[0] = this.vertices[0] * widthRatio;
                this.vertices[2] = this.vertices[2] * widthRatio;
                this.vertices[4] = this.vertices[4] * widthRatio;
                this.vertices[6] = this.vertices[6] * widthRatio;
            } else {
                float heightRatio = outputAspect / inputAspect;
                this.vertices[1] = this.vertices[1] * heightRatio;
                this.vertices[3] = this.vertices[3] * heightRatio;
                this.vertices[5] = this.vertices[5] * heightRatio;
                this.vertices[7] = this.vertices[7] * heightRatio;
            }
        }
    }

    public FullFrameRect(Texture2dProgram program) {
        this.mProgram = program;
    }

    public void release(boolean doEglCleanup) {
        if (this.mProgram != null) {
            if (doEglCleanup) {
                this.mProgram.release();
            }
            this.mProgram = null;
        }
    }

    public Texture2dProgram getProgram() {
        return this.mProgram;
    }

    public void changeProgram(Texture2dProgram program) {
        this.mProgram.release();
        this.mProgram = program;
    }

    public int createTextureObject() {
        return this.mProgram.createTextureObject();
    }

    public void drawFrame(int textureId, float[] texMatrix, int waterMarkTextureId) {
        this.drawFrame(textureId, texMatrix, waterMarkTextureId, -1, -1, -1);
    }

    public void drawFrame(int ytextureId, int utextureId, int vtextureId, float[] texMatrix) {
        this.drawFrame(-1, texMatrix, -1, ytextureId, utextureId, vtextureId);
    }

    public void drawFrame(int textureId, float[] texMatrix, int waterMarkTextureId, int ytextureId, int utextureId, int vtextureId) {
        if (!this.mUseMultiVideoView) {
            this.mProgram.draw(GlUtil.IDENTITY_MATRIX, this.mRectDrawable.getVertexArray(), 0, this.mRectDrawable.getVertexCount(), this.mRectDrawable.getCoordsPerVertex(), this.mRectDrawable.getVertexStride(), texMatrix, this.mRectDrawable.getTexCoordArray(), textureId, this.mRectDrawable.getTexCoordStride(), waterMarkTextureId, ytextureId, utextureId, vtextureId);
        } else {
            FloatBuffer TRIANGLE_BUF = GlUtil.createFloatBuffer(this.vertices);
            this.mProgram.draw(GlUtil.IDENTITY_MATRIX, TRIANGLE_BUF, 0, this.mRectDrawable.getVertexCount(), this.mRectDrawable.getCoordsPerVertex(), this.mRectDrawable.getVertexStride(), texMatrix, this.mRectDrawable.getTexCoordArray(), textureId, this.mRectDrawable.getTexCoordStride(), waterMarkTextureId, ytextureId, utextureId, vtextureId);
            TRIANGLE_BUF.clear();
        }
    }
}

